/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelationshipElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.connector.SchemaExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class DataAssetExchangeService
extends SchemaExchangeService {
    private final DataAssetExchangeClient dataAssetExchangeClient;

    DataAssetExchangeService(DataAssetExchangeClient dataAssetExchangeClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        super((SchemaExchangeInterface)dataAssetExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.dataAssetExchangeClient = dataAssetExchangeClient;
    }

    public String createDataAsset(boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAsset";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.createDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, externalIdentifierProperties, assetProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createDataAsset"), this.getClass().getName(), "createDataAsset", this.userId);
    }

    public String createDataAssetFromTemplate(boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAssetFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.createDataAssetFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createDataAssetFromTemplate"), this.getClass().getName(), "createDataAssetFromTemplate", this.userId);
    }

    public void updateDataAsset(String userId, String assetGUID, String assetExternalIdentifier, boolean isMergeUpdate, DataAssetProperties assetProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateDataAsset"), this.getClass().getName(), "updateDataAsset", userId);
        }
        this.dataAssetExchangeClient.updateDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, isMergeUpdate, assetProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void publishDataAsset(String userId, String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "publishDataAsset"), this.getClass().getName(), "publishDataAsset", userId);
        }
        this.dataAssetExchangeClient.publishDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void withdrawDataAsset(String userId, String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "withdrawDataAsset"), this.getClass().getName(), "withdrawDataAsset", userId);
        }
        this.dataAssetExchangeClient.withdrawDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeDataAsset(String userId, String assetGUID, String assetExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeDataAsset"), this.getClass().getName(), "removeDataAsset", userId);
        }
        this.dataAssetExchangeClient.removeDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setDataAssetAsReferenceData(String userId, String assetGUID, String assetExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setDataAssetAsReferenceData";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setDataAssetAsReferenceData"), this.getClass().getName(), "setDataAssetAsReferenceData", userId);
        }
        this.dataAssetExchangeClient.setDataAssetAsReferenceData(userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearDataAssetAsReferenceData(String userId, String assetGUID, String assetExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataAssetAsReferenceData";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearDataAssetAsReferenceData"), this.getClass().getName(), "clearDataAssetAsReferenceData", userId);
        }
        this.dataAssetExchangeClient.clearDataAssetAsReferenceData(userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String setupRelatedDataAsset(String userId, boolean assetManagerIsHome, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipProperties relationshipProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupRelatedDataAsset";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.setupRelatedDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, relationshipTypeName, fromAssetGUID, toAssetGUID, relationshipProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupRelatedDataAsset"), this.getClass().getName(), "setupRelatedDataAsset", userId);
    }

    public RelationshipElement getAssetRelationship(String userId, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getAssetRelationship(userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, fromAssetGUID, toAssetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateAssetRelationship(String userId, String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipProperties relationshipProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateAssetRelationship"), this.getClass().getName(), "updateAssetRelationship", userId);
        }
        this.dataAssetExchangeClient.updateAssetRelationship(userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, relationshipGUID, isMergeUpdate, relationshipProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearAssetRelationship(String userId, String relationshipTypeName, String relationshipGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearAssetRelationship"), this.getClass().getName(), "clearAssetRelationship", userId);
        }
        this.dataAssetExchangeClient.clearAssetRelationship(userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, relationshipGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd2(String userId, String relationshipTypeName, String fromAssetGUID, int startingFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getRelatedAssetsAtEnd2(userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, fromAssetGUID, startingFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd1(String userId, String relationshipTypeName, String toAssetGUID, int startingFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getRelatedAssetsAtEnd1(userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, toAssetGUID, startingFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataAssetElement> findDataAssets(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findDataAssets(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataAssetElement> getDataAssetsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public DataAssetElement getDataAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String dataAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetByGUID(userId, assetManagerGUID, assetManagerName, dataAssetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

