/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class SchemaExchangeService {
    private final SchemaExchangeInterface schemaExchangeClient;
    String userId;
    String assetManagerGUID;
    String assetManagerName;
    String connectorName;
    SynchronizationDirection synchronizationDirection;
    AuditLog auditLog;
    boolean forLineage = false;
    boolean forDuplicateProcessing = false;

    SchemaExchangeService(SchemaExchangeInterface schemaExchangeClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.schemaExchangeClient = schemaExchangeClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public String createSchemaType(boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaType";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, externalIdentifierProperties, this.forLineage, this.forDuplicateProcessing, schemaTypeProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaType"), this.getClass().getName(), "createSchemaType", this.userId);
    }

    public String createSchemaTypeFromTemplate(boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaTypeFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaTypeFromTemplate"), this.getClass().getName(), "createSchemaTypeFromTemplate", this.userId);
    }

    public void updateSchemaType(String schemaTypeGUID, String schemaTypeExternalIdentifier, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateSchemaType"), this.getClass().getName(), "updateSchemaType", this.userId);
        }
        this.schemaExchangeClient.updateSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, schemaTypeExternalIdentifier, isMergeUpdate, schemaTypeProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupSchemaTypeParent(boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, RelationshipProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaTypeParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupSchemaTypeParent"), this.getClass().getName(), "setupSchemaTypeParent", this.userId);
        }
        this.schemaExchangeClient.setupSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaTypeGUID, parentElementGUID, parentElementTypeName, effectiveTime, this.forLineage, this.forDuplicateProcessing, properties);
    }

    public void clearSchemaTypeParent(String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaTypeParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearSchemaTypeParent"), this.getClass().getName(), "clearSchemaTypeParent", this.userId);
        }
        this.schemaExchangeClient.clearSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, parentElementGUID, parentElementTypeName, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeSchemaType(String schemaTypeGUID, String schemaTypeExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeSchemaType"), this.getClass().getName(), "removeSchemaType", this.userId);
        }
        this.schemaExchangeClient.removeSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, schemaTypeExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.findSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeForElement(this.userId, this.assetManagerGUID, this.assetManagerName, parentElementGUID, parentElementTypeName, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String createSchemaAttribute(boolean assetManagerIsHome, String schemaElementGUID, ExternalIdentifierProperties externalIdentifierProperties, SchemaAttributeProperties schemaAttributeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, externalIdentifierProperties, schemaAttributeProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaAttribute"), this.getClass().getName(), "createSchemaAttribute", this.userId);
    }

    public String createSchemaAttributeFromTemplate(boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttributeFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaAttributeFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, templateGUID, externalIdentifierProperties, templateProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaAttributeFromTemplate"), this.getClass().getName(), "createSchemaAttributeFromTemplate", this.userId);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, String schemaAttributeExternalIdentifier, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaAttribute";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateSchemaAttribute"), this.getClass().getName(), "updateSchemaAttribute", this.userId);
        }
        this.schemaExchangeClient.updateSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, schemaAttributeExternalIdentifier, isMergeUpdate, schemaAttributeProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setSchemaElementAsCalculatedValue(boolean assetManagerIsHome, String schemaElementGUID, String schemaElementExternalIdentifier, String formula, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsCanonical";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setGlossaryAsCanonical"), this.getClass().getName(), "setGlossaryAsCanonical", this.userId);
        }
        this.schemaExchangeClient.setSchemaElementAsCalculatedValue(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, schemaElementExternalIdentifier, formula, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearSchemaElementAsCalculatedValue(String schemaElementGUID, String schemaElementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaElementAsCalculatedValue";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearSchemaElementAsCalculatedValue"), this.getClass().getName(), "clearSchemaElementAsCalculatedValue", this.userId);
        }
        this.schemaExchangeClient.clearSchemaElementAsCalculatedValue(this.userId, this.assetManagerGUID, this.assetManagerName, schemaElementGUID, schemaElementExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, String primaryKeyName, KeyPattern primaryKeyPattern, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupColumnAsPrimaryKey";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupColumnAsPrimaryKey"), this.getClass().getName(), "setupColumnAsPrimaryKey", userId);
        }
        this.schemaExchangeClient.setupColumnAsPrimaryKey(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, schemaAttributeGUID, schemaAttributeExternalIdentifier, primaryKeyName, primaryKeyPattern, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearColumnAsPrimaryKey(String schemaAttributeGUID, String schemaAttributeExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearColumnAsPrimaryKey";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearColumnAsPrimaryKey"), this.getClass().getName(), "clearColumnAsPrimaryKey", this.userId);
        }
        this.schemaExchangeClient.clearColumnAsPrimaryKey(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, schemaAttributeExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupForeignKeyRelationship(boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupForeignKeyRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupForeignKeyRelationship"), this.getClass().getName(), "setupForeignKeyRelationship", this.userId);
        }
        this.schemaExchangeClient.setupForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateForeignKeyRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateForeignKeyRelationship"), this.getClass().getName(), "updateForeignKeyRelationship", userId);
        }
        this.schemaExchangeClient.updateForeignKeyRelationship(userId, assetManagerGUID, assetManagerName, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearForeignKeyRelationship(String primaryKeyGUID, String foreignKeyGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearForeignKeyRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearForeignKeyRelationship"), this.getClass().getName(), "clearForeignKeyRelationship", this.userId);
        }
        this.schemaExchangeClient.clearForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, primaryKeyGUID, foreignKeyGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID, String schemaAttributeExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaAttribute";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeSchemaAttribute"), this.getClass().getName(), "removeSchemaAttribute", this.userId);
        }
        this.schemaExchangeClient.removeSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, schemaAttributeExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.findSchemaAttributes(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getNestedSchemaAttributes(this.userId, this.assetManagerGUID, this.assetManagerName, parentSchemaElementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaAttributesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaAttributeByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

