/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.CollaborationExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalReferenceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.InfrastructureExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.StewardshipExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ValidValuesExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.connector.CollaborationExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ConnectionExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.DataAssetExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ExternalReferenceExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.GlossaryExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.GovernanceExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.InfrastructureExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.LineageExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.StewardshipExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ValidValuesExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class CatalogIntegratorContext {
    private static String collaborationExchangeServiceName = "CollaborationExchangeService";
    private static String connectionExchangeServiceName = "ConnectionExchangeService";
    private static String dataAssetExchangeServiceName = "DataAssetExchangeService";
    private static String externalReferenceExchangeServiceName = "ExternalReferenceExchangeService";
    private static String glossaryExchangeServiceName = "GlossaryExchangeService";
    private static String governanceExchangeServiceName = "GovernanceExchangeService";
    private static String infrastructureExchangeServiceName = "InfrastructureExchangeService";
    private static String lineageExchangeServiceName = "LineageExchangeService";
    private static String stewardshipExchangeServiceName = "StewardshipExchangeService";
    private static String validValuesExchangeServiceName = "ValidValuesExchangeService";
    private ExternalAssetManagerClient assetManagerClient;
    private AssetManagerEventClient eventClient;
    private CollaborationExchangeService collaborationExchangeService;
    private ConnectionExchangeService connectionExchangeService;
    private DataAssetExchangeService dataAssetExchangeService;
    private ExternalReferenceExchangeService externalReferenceExchangeService;
    private GlossaryExchangeService glossaryExchangeService;
    private GovernanceExchangeService governanceExchangeService;
    private InfrastructureExchangeService infrastructureExchangeService;
    private LineageExchangeService lineageExchangeService;
    private StewardshipExchangeService stewardshipExchangeService;
    private ValidValuesExchangeService validValuesExchangeService;
    private String userId;
    private String assetManagerGUID;
    private String assetManagerName;
    private String connectorName;
    private String integrationServiceName;
    private SynchronizationDirection synchronizationDirection;
    private boolean glossaryExchangeActive = true;
    private boolean externalReferenceExchangeActive = true;
    private boolean dataAssetExchangeActive = true;
    private boolean collaborationExchangeActive = true;
    private boolean connectionExchangeActive = true;
    private boolean infrastructureExchangeActive = true;
    private boolean lineageExchangeActive = true;
    private boolean stewardshipExchangeActive = true;
    private boolean governanceExchangeActive = true;
    private boolean validValuesExchangeActive = true;

    public CatalogIntegratorContext(ExternalAssetManagerClient assetManagerClient, AssetManagerEventClient eventClient, CollaborationExchangeClient collaborationExchangeClient, ConnectionExchangeClient connectionExchangeClient, DataAssetExchangeClient dataAssetExchangeClient, ExternalReferenceExchangeClient externalReferenceExchangeClient, GlossaryExchangeClient glossaryExchangeClient, GovernanceExchangeClient governanceExchangeClient, InfrastructureExchangeClient infrastructureExchangeClient, LineageExchangeClient lineageExchangeClient, StewardshipExchangeClient stewardshipExchangeClient, ValidValuesExchangeClient validValuesExchangeClient, String userId, String assetManagerGUID, String assetManagerName, String connectorName, String integrationServiceName, SynchronizationDirection synchronizationDirection, List<String> disabledExchangeServices, AuditLog auditLog) {
        String methodName = "CatalogIntegratorContext";
        this.assetManagerClient = assetManagerClient;
        this.eventClient = eventClient;
        this.collaborationExchangeService = new CollaborationExchangeService(collaborationExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.connectionExchangeService = new ConnectionExchangeService(connectionExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.dataAssetExchangeService = new DataAssetExchangeService(dataAssetExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.externalReferenceExchangeService = new ExternalReferenceExchangeService(externalReferenceExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.glossaryExchangeService = new GlossaryExchangeService(glossaryExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.governanceExchangeService = new GovernanceExchangeService(governanceExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.infrastructureExchangeService = new InfrastructureExchangeService(infrastructureExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.lineageExchangeService = new LineageExchangeService(lineageExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.stewardshipExchangeService = new StewardshipExchangeService(stewardshipExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.validValuesExchangeService = new ValidValuesExchangeService(validValuesExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.integrationServiceName = integrationServiceName;
        this.synchronizationDirection = synchronizationDirection;
        auditLog.logMessage("CatalogIntegratorContext", CatalogIntegratorAuditCode.PERMITTED_SYNCHRONIZATION.getMessageDefinition(connectorName, synchronizationDirection.getName()));
        if (disabledExchangeServices != null) {
            for (String exchangeServiceName : disabledExchangeServices) {
                if (collaborationExchangeServiceName.equals(exchangeServiceName)) {
                    this.collaborationExchangeActive = false;
                    continue;
                }
                if (connectionExchangeServiceName.equals(exchangeServiceName)) {
                    this.connectionExchangeActive = false;
                    continue;
                }
                if (glossaryExchangeServiceName.equals(exchangeServiceName)) {
                    this.glossaryExchangeActive = false;
                    continue;
                }
                if (dataAssetExchangeServiceName.equals(exchangeServiceName)) {
                    this.dataAssetExchangeActive = false;
                    continue;
                }
                if (externalReferenceExchangeServiceName.equals(exchangeServiceName)) {
                    this.externalReferenceExchangeActive = false;
                    continue;
                }
                if (infrastructureExchangeServiceName.equals(exchangeServiceName)) {
                    this.infrastructureExchangeActive = false;
                    continue;
                }
                if (lineageExchangeServiceName.equals(exchangeServiceName)) {
                    this.lineageExchangeActive = false;
                    continue;
                }
                if (stewardshipExchangeServiceName.equals(exchangeServiceName)) {
                    this.stewardshipExchangeActive = false;
                    continue;
                }
                if (governanceExchangeServiceName.equals(exchangeServiceName)) {
                    this.governanceExchangeActive = false;
                    continue;
                }
                if (!validValuesExchangeServiceName.equals(exchangeServiceName)) continue;
                this.validValuesExchangeActive = false;
            }
        }
    }

    public void registerListener(AssetManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public void addExternalIdentifier(String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, KeyPattern keyPattern, Map<String, String> mappingProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.addExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, this.synchronizationDirection, null, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifier, externalIdentifierName, externalIdentifierUsage, this.connectorName, keyPattern, mappingProperties);
    }

    public void updateExternalIdentifier(String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, KeyPattern keyPattern, Map<String, String> mappingProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.updateExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, this.synchronizationDirection, null, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifier, externalIdentifierName, externalIdentifierUsage, this.connectorName, keyPattern, mappingProperties);
    }

    public void removeExternalIdentifier(String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier, String externalIdentifierName, String externalIdentifierUsage, KeyPattern keyPattern, Map<String, String> mappingProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.removeExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, this.synchronizationDirection, null, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifier, externalIdentifierName, externalIdentifierUsage, this.connectorName, keyPattern, mappingProperties);
    }

    public void confirmSynchronization(String openMetadataGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.confirmSynchronization(this.userId, this.assetManagerGUID, this.assetManagerName, openMetadataGUID, openMetadataElementTypeName, externalIdentifier);
    }

    List<ElementHeader> getElementsForExternalIdentifier(String externalIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.assetManagerClient.getElementsForExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, externalIdentifier, startFrom, pageSize);
    }

    public CollaborationExchangeService getCollaborationExchangeService() throws UserNotAuthorizedException {
        String methodName = "getCollaborationExchangeService";
        if (this.collaborationExchangeActive) {
            return this.collaborationExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(collaborationExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getCollaborationExchangeService", this.userId);
    }

    public ConnectionExchangeService getConnectionExchangeService() throws UserNotAuthorizedException {
        String methodName = "getConnectionExchangeService";
        if (this.connectionExchangeActive) {
            return this.connectionExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(connectionExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getConnectionExchangeService", this.userId);
    }

    public DataAssetExchangeService getDataAssetExchangeService() throws UserNotAuthorizedException {
        String methodName = "getDataAssetExchangeService";
        if (this.dataAssetExchangeActive) {
            return this.dataAssetExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(dataAssetExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getDataAssetExchangeService", this.userId);
    }

    public GlossaryExchangeService getGlossaryExchangeService() throws UserNotAuthorizedException {
        String methodName = "getGlossaryExchangeService";
        if (this.glossaryExchangeActive) {
            return this.glossaryExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(glossaryExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getGlossaryExchangeService", this.userId);
    }

    public GovernanceExchangeService getGovernanceExchangeService() throws UserNotAuthorizedException {
        String methodName = "getGovernanceExchangeService";
        if (this.governanceExchangeActive) {
            return this.governanceExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(governanceExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getGovernanceExchangeService", this.userId);
    }

    public InfrastructureExchangeService getInfrastructureExchangeService() throws UserNotAuthorizedException {
        String methodName = "getInfrastructureExchangeService";
        if (this.infrastructureExchangeActive) {
            return this.infrastructureExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(infrastructureExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getInfrastructureExchangeService", this.userId);
    }

    public LineageExchangeService getLineageExchangeService() throws UserNotAuthorizedException {
        String methodName = "getLineageExchangeService";
        if (this.lineageExchangeActive) {
            return this.lineageExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(lineageExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getLineageExchangeService", this.userId);
    }

    public StewardshipExchangeService getStewardshipExchangeService() throws UserNotAuthorizedException {
        String methodName = "getStewardshipExchangeService";
        if (this.stewardshipExchangeActive) {
            return this.stewardshipExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(stewardshipExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getStewardshipExchangeService", this.userId);
    }

    public ValidValuesExchangeService getValidValuesExchangeService() throws UserNotAuthorizedException {
        String methodName = "getValidValuesExchangeService";
        if (this.validValuesExchangeActive) {
            return this.validValuesExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(validValuesExchangeServiceName, this.integrationServiceName), this.getClass().getName(), "getValidValuesExchangeService", this.userId);
    }
}

