/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaAttributeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ForeignKeyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaAttributeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class SchemaExchangeService {
    private SchemaExchangeInterface schemaExchangeClient;
    String userId;
    String assetManagerGUID;
    String assetManagerName;
    String connectorName;
    SynchronizationDirection synchronizationDirection;
    AuditLog auditLog;

    SchemaExchangeService(SchemaExchangeInterface schemaExchangeClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.schemaExchangeClient = schemaExchangeClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public String createSchemaType(boolean assetManagerIsHome, String schemaTypeExternalIdentifier, String schemaTypeExternalIdentifierName, String schemaTypeExternalIdentifierUsage, KeyPattern schemaTypeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaType";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaTypeExternalIdentifier, schemaTypeExternalIdentifierName, schemaTypeExternalIdentifierUsage, this.connectorName, schemaTypeExternalIdentifierKeyPattern, mappingProperties, schemaTypeProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaType"), this.getClass().getName(), "createSchemaType", this.userId);
    }

    public String createSchemaTypeFromTemplate(boolean assetManagerIsHome, String templateGUID, String schemaTypeExternalIdentifier, String schemaTypeExternalIdentifierName, String schemaTypeExternalIdentifierUsage, KeyPattern schemaTypeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaTypeFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaTypeFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, schemaTypeExternalIdentifier, schemaTypeExternalIdentifierName, schemaTypeExternalIdentifierUsage, this.connectorName, schemaTypeExternalIdentifierKeyPattern, mappingProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaTypeFromTemplate"), this.getClass().getName(), "createSchemaTypeFromTemplate", this.userId);
    }

    public void updateSchemaType(String schemaTypeGUID, String schemaTypeExternalIdentifier, boolean isMergeUpdate, SchemaTypeProperties schemaTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateSchemaType"), this.getClass().getName(), "updateSchemaType", this.userId);
        }
        this.schemaExchangeClient.updateSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, schemaTypeExternalIdentifier, isMergeUpdate, schemaTypeProperties);
    }

    public void setupSchemaTypeParent(boolean assetManagerIsHome, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSchemaTypeParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupSchemaTypeParent"), this.getClass().getName(), "setupSchemaTypeParent", this.userId);
        }
        this.schemaExchangeClient.setupSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaTypeGUID, parentElementGUID, parentElementTypeName);
    }

    public void clearSchemaTypeParent(String schemaTypeGUID, String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaTypeParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearSchemaTypeParent"), this.getClass().getName(), "clearSchemaTypeParent", this.userId);
        }
        this.schemaExchangeClient.clearSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, parentElementGUID, parentElementTypeName);
    }

    public void removeSchemaType(String schemaTypeGUID, String schemaTypeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaType";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeSchemaType"), this.getClass().getName(), "removeSchemaType", this.userId);
        }
        this.schemaExchangeClient.removeSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID, schemaTypeExternalIdentifier);
    }

    public List<SchemaTypeElement> findSchemaType(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.findSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeForElement(String parentElementGUID, String parentElementTypeName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeForElement(this.userId, this.assetManagerGUID, this.assetManagerName, parentElementGUID, parentElementTypeName);
    }

    public List<SchemaTypeElement> getSchemaTypeByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public SchemaTypeElement getSchemaTypeByGUID(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID);
    }

    public ElementHeader getSchemaTypeParent(String schemaTypeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaTypeParent(this.userId, this.assetManagerGUID, this.assetManagerName, schemaTypeGUID);
    }

    public String createSchemaAttribute(boolean assetManagerIsHome, String schemaElementGUID, String schemaAttributeExternalIdentifier, String schemaAttributeExternalIdentifierName, String schemaAttributeExternalIdentifierUsage, KeyPattern schemaAttributeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttribute";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, schemaAttributeExternalIdentifier, schemaAttributeExternalIdentifierName, schemaAttributeExternalIdentifierUsage, this.connectorName, schemaAttributeExternalIdentifierKeyPattern, mappingProperties, schemaAttributeProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaAttribute"), this.getClass().getName(), "createSchemaAttribute", this.userId);
    }

    public String createSchemaAttributeFromTemplate(boolean assetManagerIsHome, String schemaElementGUID, String templateGUID, String schemaAttributeExternalIdentifier, String schemaAttributeExternalIdentifierName, String schemaAttributeExternalIdentifierUsage, KeyPattern schemaAttributeExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSchemaAttributeFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.schemaExchangeClient.createSchemaAttributeFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, templateGUID, schemaAttributeExternalIdentifier, schemaAttributeExternalIdentifierName, schemaAttributeExternalIdentifierUsage, this.connectorName, schemaAttributeExternalIdentifierKeyPattern, mappingProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createSchemaAttributeFromTemplate"), this.getClass().getName(), "createSchemaAttributeFromTemplate", this.userId);
    }

    public void updateSchemaAttribute(String schemaAttributeGUID, String schemaAttributeExternalIdentifier, boolean isMergeUpdate, SchemaAttributeProperties schemaAttributeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSchemaAttribute";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateSchemaAttribute"), this.getClass().getName(), "updateSchemaAttribute", this.userId);
        }
        this.schemaExchangeClient.updateSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, schemaAttributeExternalIdentifier, isMergeUpdate, schemaAttributeProperties);
    }

    public void setSchemaElementAsCalculatedValue(boolean assetManagerIsHome, String schemaElementGUID, String schemaElementExternalIdentifier, String formula) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsCanonical";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setGlossaryAsCanonical"), this.getClass().getName(), "setGlossaryAsCanonical", this.userId);
        }
        this.schemaExchangeClient.setSchemaElementAsCalculatedValue(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, schemaElementGUID, schemaElementExternalIdentifier, formula);
    }

    public void clearSchemaElementAsCalculatedValue(String schemaElementGUID, String schemaElementExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSchemaElementAsCalculatedValue";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearSchemaElementAsCalculatedValue"), this.getClass().getName(), "clearSchemaElementAsCalculatedValue", this.userId);
        }
        this.schemaExchangeClient.clearSchemaElementAsCalculatedValue(this.userId, this.assetManagerGUID, this.assetManagerName, schemaElementGUID, schemaElementExternalIdentifier);
    }

    public void setupColumnAsPrimaryKey(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String schemaAttributeGUID, String schemaAttributeExternalIdentifier, String primaryKeyName, KeyPattern primaryKeyPattern) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupColumnAsPrimaryKey";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupColumnAsPrimaryKey"), this.getClass().getName(), "setupColumnAsPrimaryKey", userId);
        }
        this.schemaExchangeClient.setupColumnAsPrimaryKey(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, schemaAttributeGUID, schemaAttributeExternalIdentifier, primaryKeyName, primaryKeyPattern);
    }

    public void clearColumnAsPrimaryKey(String schemaAttributeGUID, String schemaAttributeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearColumnAsPrimaryKey";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearColumnAsPrimaryKey"), this.getClass().getName(), "clearColumnAsPrimaryKey", this.userId);
        }
        this.schemaExchangeClient.clearColumnAsPrimaryKey(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, schemaAttributeExternalIdentifier);
    }

    public void setupForeignKeyRelationship(boolean assetManagerIsHome, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupForeignKeyRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupForeignKeyRelationship"), this.getClass().getName(), "setupForeignKeyRelationship", this.userId);
        }
        this.schemaExchangeClient.setupForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties);
    }

    public void updateForeignKeyRelationship(String userId, String assetManagerGUID, String assetManagerName, String primaryKeyGUID, String foreignKeyGUID, ForeignKeyProperties foreignKeyProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateForeignKeyRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateForeignKeyRelationship"), this.getClass().getName(), "updateForeignKeyRelationship", userId);
        }
        this.schemaExchangeClient.updateForeignKeyRelationship(userId, assetManagerGUID, assetManagerName, primaryKeyGUID, foreignKeyGUID, foreignKeyProperties);
    }

    public void clearForeignKeyRelationship(String primaryKeyGUID, String foreignKeyGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearForeignKeyRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearForeignKeyRelationship"), this.getClass().getName(), "clearForeignKeyRelationship", this.userId);
        }
        this.schemaExchangeClient.clearForeignKeyRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, primaryKeyGUID, foreignKeyGUID);
    }

    public void removeSchemaAttribute(String schemaAttributeGUID, String schemaAttributeExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeSchemaAttribute";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeSchemaAttribute"), this.getClass().getName(), "removeSchemaAttribute", this.userId);
        }
        this.schemaExchangeClient.removeSchemaAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID, schemaAttributeExternalIdentifier);
    }

    public List<SchemaAttributeElement> findSchemaAttributes(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.findSchemaAttributes(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getNestedAttributes(String parentSchemaElementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getNestedSchemaAttributes(this.userId, this.assetManagerGUID, this.assetManagerName, parentSchemaElementGUID, startFrom, pageSize);
    }

    public List<SchemaAttributeElement> getSchemaAttributesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaAttributesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public SchemaAttributeElement getSchemaAttributeByGUID(String schemaAttributeGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.schemaExchangeClient.getSchemaAttributeByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, schemaAttributeGUID);
    }
}

