/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataAssetProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.KeyPattern;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.connector.SchemaExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class DataAssetExchangeService
extends SchemaExchangeService {
    private DataAssetExchangeClient dataAssetExchangeClient;

    DataAssetExchangeService(DataAssetExchangeClient dataAssetExchangeClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        super((SchemaExchangeInterface)dataAssetExchangeClient, synchronizationDirection, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.dataAssetExchangeClient = dataAssetExchangeClient;
    }

    public String createDataAsset(boolean assetManagerIsHome, String assetExternalIdentifier, String assetExternalIdentifierName, String assetExternalIdentifierUsage, KeyPattern assetExternalIdentifierKeyPattern, Map<String, String> mappingProperties, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAsset";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.createDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, assetExternalIdentifier, assetExternalIdentifierName, assetExternalIdentifierUsage, this.connectorName, assetExternalIdentifierKeyPattern, mappingProperties, assetProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createDataAsset"), this.getClass().getName(), "createDataAsset", this.userId);
    }

    public String createDataAssetFromTemplate(boolean assetManagerIsHome, String templateGUID, String assetExternalIdentifier, String assetExternalIdentifierName, String assetExternalIdentifierUsage, KeyPattern assetExternalIdentifierKeyPattern, Map<String, String> mappingProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAssetFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.createDataAssetFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, assetExternalIdentifier, assetExternalIdentifierName, assetExternalIdentifierUsage, this.connectorName, assetExternalIdentifierKeyPattern, mappingProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createDataAssetFromTemplate"), this.getClass().getName(), "createDataAssetFromTemplate", this.userId);
    }

    public void updateDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier, boolean isMergeUpdate, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateDataAsset"), this.getClass().getName(), "updateDataAsset", userId);
        }
        this.dataAssetExchangeClient.updateDataAsset(userId, assetManagerGUID, assetManagerName, assetGUID, assetExternalIdentifier, isMergeUpdate, assetProperties);
    }

    public void publishDataAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "publishDataAsset"), this.getClass().getName(), "publishDataAsset", userId);
        }
        this.dataAssetExchangeClient.publishDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetGUID);
    }

    public void withdrawDataAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "withdrawDataAsset"), this.getClass().getName(), "withdrawDataAsset", userId);
        }
        this.dataAssetExchangeClient.withdrawDataAsset(userId, this.assetManagerGUID, this.assetManagerName, assetGUID);
    }

    public void removeDataAsset(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataAsset";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeDataAsset"), this.getClass().getName(), "removeDataAsset", userId);
        }
        this.dataAssetExchangeClient.removeDataAsset(userId, assetManagerGUID, assetManagerName, assetGUID, assetExternalIdentifier);
    }

    public void setDataAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setDataAssetAsReferenceData";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setDataAssetAsReferenceData"), this.getClass().getName(), "setDataAssetAsReferenceData", userId);
        }
        this.dataAssetExchangeClient.setDataAssetAsReferenceData(userId, assetManagerGUID, assetManagerName, assetGUID, assetExternalIdentifier);
    }

    public void clearDataAssetAsReferenceData(String userId, String assetManagerGUID, String assetManagerName, String assetGUID, String assetExternalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataAssetAsReferenceData";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearDataAssetAsReferenceData"), this.getClass().getName(), "clearDataAssetAsReferenceData", userId);
        }
        this.dataAssetExchangeClient.clearDataAssetAsReferenceData(userId, assetManagerGUID, assetManagerName, assetGUID, assetExternalIdentifier);
    }

    public List<DataAssetElement> findDataAssets(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findDataAssets(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize);
    }

    public List<DataAssetElement> getDataAssetsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize);
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize);
    }

    public DataAssetElement getDataAssetByGUID(String userId, String assetManagerGUID, String assetManagerName, String dataAssetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetByGUID(userId, assetManagerGUID, assetManagerName, dataAssetGUID);
    }
}

