/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.CollaborationExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExternalReferenceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.InfrastructureExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.StewardshipExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ValidValuesExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.integrationservices.catalog.connector.CollaborationExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ConnectionExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ConnectorFactoryService;
import org.odpi.openmetadata.integrationservices.catalog.connector.DataAssetExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ExternalReferenceExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.GlossaryExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.GovernanceExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.InfrastructureExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.LineageExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.StewardshipExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.connector.ValidValuesExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class CatalogIntegratorContext
extends IntegrationContext {
    public static final String connectorFactoryServiceName = "ConnectorFactoryExchangeService";
    public static final String collaborationExchangeServiceName = "CollaborationExchangeService";
    public static final String connectionExchangeServiceName = "ConnectionExchangeService";
    public static final String dataAssetExchangeServiceName = "DataAssetExchangeService";
    public static final String externalReferenceExchangeServiceName = "ExternalReferenceExchangeService";
    public static final String glossaryExchangeServiceName = "GlossaryExchangeService";
    public static final String governanceExchangeServiceName = "GovernanceExchangeService";
    public static final String infrastructureExchangeServiceName = "InfrastructureExchangeService";
    public static final String lineageExchangeServiceName = "LineageExchangeService";
    public static final String stewardshipExchangeServiceName = "StewardshipExchangeService";
    public static final String validValuesExchangeServiceName = "ValidValuesExchangeService";
    private final ExternalAssetManagerClient assetManagerClient;
    private final AssetManagerEventClient eventClient;
    private final ConnectorFactoryService connectorFactoryService;
    private final CollaborationExchangeService collaborationExchangeService;
    private final ConnectionExchangeService connectionExchangeService;
    private final DataAssetExchangeService dataAssetExchangeService;
    private final ExternalReferenceExchangeService externalReferenceExchangeService;
    private final GlossaryExchangeService glossaryExchangeService;
    private final GovernanceExchangeService governanceExchangeService;
    private final InfrastructureExchangeService infrastructureExchangeService;
    private final LineageExchangeService lineageExchangeService;
    private final StewardshipExchangeService stewardshipExchangeService;
    private final ValidValuesExchangeService validValuesExchangeService;
    private final String assetManagerGUID;
    private final String assetManagerName;
    private final String integrationServiceName;
    private boolean connectorFactoryActive = true;
    private boolean glossaryExchangeActive = true;
    private boolean externalReferenceExchangeActive = true;
    private boolean dataAssetExchangeActive = true;
    private boolean collaborationExchangeActive = true;
    private boolean connectionExchangeActive = true;
    private boolean infrastructureExchangeActive = true;
    private boolean lineageExchangeActive = true;
    private boolean stewardshipExchangeActive = true;
    private boolean governanceExchangeActive = true;
    private boolean validValuesExchangeActive = true;
    private boolean listenerRegistered = false;

    public CatalogIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, ExternalAssetManagerClient assetManagerClient, AssetManagerEventClient eventClient, ConnectedAssetClient connectedAssetClient, CollaborationExchangeClient collaborationExchangeClient, ConnectionExchangeClient connectionExchangeClient, DataAssetExchangeClient dataAssetExchangeClient, ExternalReferenceExchangeClient externalReferenceExchangeClient, GlossaryExchangeClient glossaryExchangeClient, GovernanceExchangeClient governanceExchangeClient, InfrastructureExchangeClient infrastructureExchangeClient, LineageExchangeClient lineageExchangeClient, StewardshipExchangeClient stewardshipExchangeClient, ValidValuesExchangeClient validValuesExchangeClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String assetManagerGUID, String assetManagerName, String integrationServiceName, List<String> disabledExchangeServices, int maxPageSize, AuditLog auditLog) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, openMetadataStoreClient, generateIntegrationReport, permittedSynchronization, assetManagerGUID, assetManagerName, integrationConnectorGUID, maxPageSize);
        String methodName = "CatalogIntegratorContext";
        SynchronizationDirection synchronizationDirection = this.getSynchronizationDirection(permittedSynchronization);
        this.assetManagerClient = assetManagerClient;
        this.eventClient = eventClient;
        this.connectorFactoryService = new ConnectorFactoryService(connectedAssetClient, this.userId);
        this.collaborationExchangeService = new CollaborationExchangeService(collaborationExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.connectionExchangeService = new ConnectionExchangeService(connectionExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.dataAssetExchangeService = new DataAssetExchangeService(dataAssetExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.externalReferenceExchangeService = new ExternalReferenceExchangeService(externalReferenceExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.glossaryExchangeService = new GlossaryExchangeService(glossaryExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.governanceExchangeService = new GovernanceExchangeService(governanceExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.infrastructureExchangeService = new InfrastructureExchangeService(infrastructureExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.lineageExchangeService = new LineageExchangeService(lineageExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.stewardshipExchangeService = new StewardshipExchangeService(stewardshipExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.validValuesExchangeService = new ValidValuesExchangeService(validValuesExchangeClient, synchronizationDirection, this.userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.integrationServiceName = integrationServiceName;
        auditLog.logMessage("CatalogIntegratorContext", CatalogIntegratorAuditCode.PERMITTED_SYNCHRONIZATION.getMessageDefinition(connectorName, permittedSynchronization.getName()));
        if (disabledExchangeServices != null) {
            for (String exchangeServiceName : disabledExchangeServices) {
                if (connectorFactoryServiceName.equals(exchangeServiceName)) {
                    this.connectorFactoryActive = false;
                    continue;
                }
                if (collaborationExchangeServiceName.equals(exchangeServiceName)) {
                    this.collaborationExchangeActive = false;
                    continue;
                }
                if (connectionExchangeServiceName.equals(exchangeServiceName)) {
                    this.connectionExchangeActive = false;
                    continue;
                }
                if (glossaryExchangeServiceName.equals(exchangeServiceName)) {
                    this.glossaryExchangeActive = false;
                    continue;
                }
                if (dataAssetExchangeServiceName.equals(exchangeServiceName)) {
                    this.dataAssetExchangeActive = false;
                    continue;
                }
                if (externalReferenceExchangeServiceName.equals(exchangeServiceName)) {
                    this.externalReferenceExchangeActive = false;
                    continue;
                }
                if (infrastructureExchangeServiceName.equals(exchangeServiceName)) {
                    this.infrastructureExchangeActive = false;
                    continue;
                }
                if (lineageExchangeServiceName.equals(exchangeServiceName)) {
                    this.lineageExchangeActive = false;
                    continue;
                }
                if (stewardshipExchangeServiceName.equals(exchangeServiceName)) {
                    this.stewardshipExchangeActive = false;
                    continue;
                }
                if (governanceExchangeServiceName.equals(exchangeServiceName)) {
                    this.governanceExchangeActive = false;
                    continue;
                }
                if (!validValuesExchangeServiceName.equals(exchangeServiceName)) continue;
                this.validValuesExchangeActive = false;
            }
        }
    }

    private SynchronizationDirection getSynchronizationDirection(PermittedSynchronization permittedSynchronization) {
        if (permittedSynchronization != null) {
            switch (permittedSynchronization) {
                case TO_THIRD_PARTY: {
                    return SynchronizationDirection.TO_THIRD_PARTY;
                }
                case FROM_THIRD_PARTY: {
                    return SynchronizationDirection.FROM_THIRD_PARTY;
                }
                case BOTH_DIRECTIONS: {
                    return SynchronizationDirection.BOTH_DIRECTIONS;
                }
                case OTHER: {
                    return SynchronizationDirection.OTHER;
                }
            }
        }
        return SynchronizationDirection.BOTH_DIRECTIONS;
    }

    public String getAssetManagerGUID() {
        return this.assetManagerGUID;
    }

    public String getAssetManagerName() {
        return this.assetManagerName;
    }

    public void registerListener(AssetManagerEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
        this.listenerRegistered = true;
    }

    public boolean isListenerRegistered() {
        return this.listenerRegistered;
    }

    public void addExternalIdentifier(String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.addExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifierProperties);
    }

    public void updateExternalIdentifier(String openMetadataElementGUID, String openMetadataElementTypeName, ExternalIdentifierProperties externalIdentifierProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.updateExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifierProperties);
    }

    public void removeExternalIdentifier(String openMetadataElementGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.removeExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, openMetadataElementGUID, openMetadataElementTypeName, externalIdentifier);
    }

    public void confirmSynchronization(String openMetadataGUID, String openMetadataElementTypeName, String externalIdentifier) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.assetManagerClient.confirmSynchronization(this.userId, this.assetManagerGUID, this.assetManagerName, openMetadataGUID, openMetadataElementTypeName, externalIdentifier);
    }

    List<ElementHeader> getElementsForExternalIdentifier(String externalIdentifier, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.assetManagerClient.getElementsForExternalIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, externalIdentifier, startFrom, pageSize);
    }

    public ConnectorFactoryService getConnectorFactoryService() throws UserNotAuthorizedException {
        String methodName = "getConnectorFactoryService";
        if (this.connectorFactoryActive) {
            return this.connectorFactoryService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(connectorFactoryServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getConnectorFactoryService", this.userId);
    }

    public CollaborationExchangeService getCollaborationExchangeService() throws UserNotAuthorizedException {
        String methodName = "getCollaborationExchangeService";
        if (this.collaborationExchangeActive) {
            return this.collaborationExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(collaborationExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getCollaborationExchangeService", this.userId);
    }

    public ConnectionExchangeService getConnectionExchangeService() throws UserNotAuthorizedException {
        String methodName = "getConnectionExchangeService";
        if (this.connectionExchangeActive) {
            return this.connectionExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(connectionExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getConnectionExchangeService", this.userId);
    }

    public DataAssetExchangeService getDataAssetExchangeService() throws UserNotAuthorizedException {
        String methodName = "getDataAssetExchangeService";
        if (this.dataAssetExchangeActive) {
            return this.dataAssetExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(dataAssetExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getDataAssetExchangeService", this.userId);
    }

    public ExternalReferenceExchangeService getExternalReferenceService() throws UserNotAuthorizedException {
        String methodName = "getExternalReferenceService";
        if (this.externalReferenceExchangeActive) {
            return this.externalReferenceExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(externalReferenceExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getExternalReferenceService", this.userId);
    }

    public GlossaryExchangeService getGlossaryExchangeService() throws UserNotAuthorizedException {
        String methodName = "getGlossaryExchangeService";
        if (this.glossaryExchangeActive) {
            return this.glossaryExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(glossaryExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getGlossaryExchangeService", this.userId);
    }

    public GovernanceExchangeService getGovernanceExchangeService() throws UserNotAuthorizedException {
        String methodName = "getGovernanceExchangeService";
        if (this.governanceExchangeActive) {
            return this.governanceExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(governanceExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getGovernanceExchangeService", this.userId);
    }

    public InfrastructureExchangeService getInfrastructureExchangeService() throws UserNotAuthorizedException {
        String methodName = "getInfrastructureExchangeService";
        if (this.infrastructureExchangeActive) {
            return this.infrastructureExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(infrastructureExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getInfrastructureExchangeService", this.userId);
    }

    public LineageExchangeService getLineageExchangeService() throws UserNotAuthorizedException {
        String methodName = "getLineageExchangeService";
        if (this.lineageExchangeActive) {
            return this.lineageExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(lineageExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getLineageExchangeService", this.userId);
    }

    public StewardshipExchangeService getStewardshipExchangeService() throws UserNotAuthorizedException {
        String methodName = "getStewardshipExchangeService";
        if (this.stewardshipExchangeActive) {
            return this.stewardshipExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(stewardshipExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getStewardshipExchangeService", this.userId);
    }

    public ValidValuesExchangeService getValidValuesExchangeService() throws UserNotAuthorizedException {
        String methodName = "getValidValuesExchangeService";
        if (this.validValuesExchangeActive) {
            return this.validValuesExchangeService;
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.DISABLED_EXCHANGE_SERVICE.getMessageDefinition(validValuesExchangeServiceName, this.integrationServiceName), ((Object)((Object)this)).getClass().getName(), "getValidValuesExchangeService", this.userId);
    }
}

