/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import org.odpi.openmetadata.accessservices.assetmanager.client.ConnectedAssetClient;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public class ConnectorFactoryService {
    private final ConnectedAssetClient connectedAssetClient;
    private final String userId;

    ConnectorFactoryService(ConnectedAssetClient connectedAssetClient, String userId) {
        this.connectedAssetClient = connectedAssetClient;
        this.userId = userId;
    }

    public Connector getConnectorByName(String connectionName) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        return this.connectedAssetClient.getConnectorByName(this.userId, connectionName);
    }

    public Connector getConnectorForAsset(String assetGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        return this.connectedAssetClient.getConnectorForAsset(this.userId, assetGUID);
    }

    public Connector getConnectorByGUID(String connectionGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        return this.connectedAssetClient.getConnectorByGUID(this.userId, connectionGUID);
    }

    public Connector getConnectorByConnection(Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        return this.connectedAssetClient.getConnectorByConnection(this.userId, connection);
    }
}

