/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExternalReferenceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalReferenceLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalReferenceLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalReferenceProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class ExternalReferenceExchangeService {
    private final ExternalReferenceExchangeClient externalReferenceClient;
    private final String userId;
    private final String assetManagerGUID;
    private final String assetManagerName;
    private final String connectorName;
    private final SynchronizationDirection synchronizationDirection;
    private final AuditLog auditLog;
    private boolean assetManagerIsHome = true;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;

    ExternalReferenceExchangeService(ExternalReferenceExchangeClient externalReferenceClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.externalReferenceClient = externalReferenceClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public void setAssetManagerIsHome(boolean assetManagerIsHome) {
        this.assetManagerIsHome = assetManagerIsHome;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public String createExternalReference(ExternalIdentifierProperties externalIdentifierProperties, String anchorGUID, ExternalReferenceProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalReference";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.externalReferenceClient.createExternalReference(this.userId, this.assetManagerGUID, this.assetManagerName, this.assetManagerIsHome, externalIdentifierProperties, anchorGUID, properties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createExternalReference"), this.getClass().getName(), "createExternalReference", this.userId);
    }

    public void updateExternalReference(String externalReferenceGUID, String referenceExternalIdentifier, boolean isMergeUpdate, ExternalReferenceProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalReference";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateExternalReference"), this.getClass().getName(), "updateExternalReference", this.userId);
        }
        this.externalReferenceClient.updateExternalReference(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceGUID, referenceExternalIdentifier, isMergeUpdate, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void deleteExternalReference(String externalReferenceGUID, String referenceExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteExternalReference";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "deleteExternalReference"), this.getClass().getName(), "deleteExternalReference", this.userId);
        }
        this.externalReferenceClient.deleteExternalReference(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceGUID, referenceExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String linkExternalReferenceToElement(String attachedToGUID, String externalReferenceGUID, ExternalReferenceLinkProperties linkProperties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.externalReferenceClient.linkExternalReferenceToElement(this.userId, this.assetManagerGUID, this.assetManagerName, this.assetManagerIsHome, attachedToGUID, externalReferenceGUID, linkProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "linkExternalReferenceToElement"), this.getClass().getName(), "linkExternalReferenceToElement", this.userId);
    }

    public void updateExternalReferenceToElementLink(String externalReferenceLinkGUID, ExternalReferenceLinkProperties linkProperties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "linkExternalReferenceToElement";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "linkExternalReferenceToElement"), this.getClass().getName(), "linkExternalReferenceToElement", this.userId);
        }
        this.externalReferenceClient.updateExternalReferenceToElementLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceLinkGUID, linkProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void unlinkExternalReferenceFromElement(String externalReferenceLinkGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "unlinkExternalReferenceFromElement";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "unlinkExternalReferenceFromElement"), this.getClass().getName(), "unlinkExternalReferenceFromElement", this.userId);
        }
        this.externalReferenceClient.unlinkExternalReferenceFromElement(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceLinkGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceElement> getExternalReferences(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferences(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceElement> getExternalReferencesById(String resourceId, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferencesById(this.userId, this.assetManagerGUID, this.assetManagerName, resourceId, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceElement> getExternalReferencesByURL(String url, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferencesByURL(this.userId, this.assetManagerGUID, this.assetManagerName, url, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceElement> getExternalReferencesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.getExternalReferencesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceElement> getExternalReferencesForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.externalReferenceClient.getExternalReferencesForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceElement> findExternalReferences(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.findExternalReferences(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalReferenceLinkElement> retrieveAttachedExternalReferences(String attachedToGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceClient.retrieveAttachedExternalReferences(this.userId, this.assetManagerGUID, this.assetManagerName, attachedToGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public ExternalReferenceElement getExternalReferenceByGUID(String externalReferenceGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.externalReferenceClient.getExternalReferenceByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, externalReferenceGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

