/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ExternalGlossaryLinkElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ActivityDescriptionProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CanonicalVocabularyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryElementLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalGlossaryLinkProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryCategoryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermCategorization;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermContextDefinition;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationship;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TaxonomyProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class GlossaryExchangeService {
    private final GlossaryExchangeClient glossaryManagerClient;
    private final String userId;
    private final String assetManagerGUID;
    private final String assetManagerName;
    private final String connectorName;
    private final SynchronizationDirection synchronizationDirection;
    private final AuditLog auditLog;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;

    GlossaryExchangeService(GlossaryExchangeClient glossaryManagerClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.glossaryManagerClient = glossaryManagerClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public String createGlossary(boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, GlossaryProperties glossaryProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossary";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, externalIdentifierProperties, glossaryProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createGlossary"), this.getClass().getName(), "createGlossary", this.userId);
    }

    public String createGlossaryFromTemplate(boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties, boolean deepCopy) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createGlossaryFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, externalIdentifierProperties, deepCopy, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createGlossaryFromTemplate"), this.getClass().getName(), "createGlossaryFromTemplate", this.userId);
    }

    public void updateGlossary(String glossaryGUID, String glossaryExternalIdentifier, boolean isMergeUpdate, GlossaryProperties glossaryProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossary";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateGlossary"), this.getClass().getName(), "updateGlossary", this.userId);
        }
        this.glossaryManagerClient.updateGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, glossaryExternalIdentifier, isMergeUpdate, glossaryProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeGlossary(String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossary";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeGlossary"), this.getClass().getName(), "removeGlossary", this.userId);
        }
        this.glossaryManagerClient.removeGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, glossaryExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setGlossaryAsTaxonomy(String glossaryGUID, String glossaryExternalIdentifier, TaxonomyProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsTaxonomy";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setGlossaryAsTaxonomy"), this.getClass().getName(), "setGlossaryAsTaxonomy", this.userId);
        }
        this.glossaryManagerClient.setGlossaryAsTaxonomy(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, glossaryExternalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearGlossaryAsTaxonomy(String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsTaxonomy";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearGlossaryAsTaxonomy"), this.getClass().getName(), "clearGlossaryAsTaxonomy", this.userId);
        }
        this.glossaryManagerClient.clearGlossaryAsTaxonomy(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, glossaryExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setGlossaryAsCanonical(String glossaryGUID, String glossaryExternalIdentifier, CanonicalVocabularyProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setGlossaryAsCanonical";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setGlossaryAsCanonical"), this.getClass().getName(), "setGlossaryAsCanonical", this.userId);
        }
        this.glossaryManagerClient.setGlossaryAsCanonical(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, glossaryExternalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearGlossaryAsCanonical(String glossaryGUID, String glossaryExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearGlossaryAsCanonical";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearGlossaryAsCanonical"), this.getClass().getName(), "clearGlossaryAsCanonical", this.userId);
        }
        this.glossaryManagerClient.clearGlossaryAsCanonical(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, glossaryExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryElement> findGlossaries(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.findGlossaries(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryElement> getGlossariesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossariesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryElement> getGlossariesForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossariesForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public GlossaryElement getGlossaryByGUID(String glossaryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public GlossaryElement getGlossaryForCategory(String glossaryCategoryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryForCategory(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public GlossaryElement getGlossaryForTerm(String glossaryTermGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryForTerm(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String createGlossaryCategory(String glossaryGUID, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, GlossaryCategoryProperties glossaryCategoryProperties, boolean isRootCategory, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryCategory";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createGlossaryCategory(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, glossaryGUID, externalIdentifierProperties, glossaryCategoryProperties, isRootCategory, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createGlossaryCategory"), this.getClass().getName(), "createGlossaryCategory", this.userId);
    }

    public String createGlossaryCategoryFromTemplate(String glossaryGUID, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties, boolean deepCopy) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryCategoryFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createGlossaryCategoryFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, glossaryGUID, templateGUID, externalIdentifierProperties, deepCopy, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createGlossaryCategoryFromTemplate"), this.getClass().getName(), "createGlossaryCategoryFromTemplate", this.userId);
    }

    public void updateGlossaryCategory(String glossaryCategoryGUID, String glossaryCategoryExternalIdentifier, boolean isMergeUpdate, GlossaryCategoryProperties glossaryCategoryProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryCategory";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateGlossaryCategory"), this.getClass().getName(), "updateGlossaryCategory", this.userId);
        }
        this.glossaryManagerClient.updateGlossaryCategory(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, glossaryCategoryExternalIdentifier, isMergeUpdate, glossaryCategoryProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupCategoryParent(String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupCategoryParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupCategoryParent"), this.getClass().getName(), "setupCategoryParent", this.userId);
        }
        this.glossaryManagerClient.setupCategoryParent(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryParentCategoryGUID, glossaryChildCategoryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearCategoryParent(String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCategoryParent";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearCategoryParent"), this.getClass().getName(), "clearCategoryParent", this.userId);
        }
        this.glossaryManagerClient.clearCategoryParent(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryParentCategoryGUID, glossaryChildCategoryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeGlossaryCategory(String glossaryCategoryGUID, String glossaryCategoryExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossaryCategory";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeGlossaryCategory"), this.getClass().getName(), "removeGlossaryCategory", this.userId);
        }
        this.glossaryManagerClient.removeGlossaryCategory(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, glossaryCategoryExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.findGlossaryCategories(this.userId, this.assetManagerGUID, this.assetManagerName, null, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> findGlossaryCategories(String glossaryGUID, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.findGlossaryCategories(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getCategoriesForGlossary(String glossaryGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getCategoriesForGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getCategoriesForTerm(String glossaryTermGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getCategoriesForTerm(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryCategoriesByName(this.userId, this.assetManagerGUID, this.assetManagerName, null, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getGlossaryCategoriesByName(String glossaryGUID, String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryCategoriesByName(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public GlossaryCategoryElement getGlossaryCategoryByGUID(String guid, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryCategoryByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, guid, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public GlossaryCategoryElement getGlossaryCategoryParent(String glossaryCategoryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryCategoryParent(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryCategoryElement> getGlossarySubCategories(String glossaryCategoryGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossarySubCategories(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String createGlossaryTerm(String glossaryGUID, boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, GlossaryTermProperties glossaryTermProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryTerm";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createGlossaryTerm(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, glossaryGUID, externalIdentifierProperties, glossaryTermProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createGlossaryTerm"), this.getClass().getName(), "createGlossaryTerm", this.userId);
    }

    public String createControlledGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, boolean assetManagerIsHome, String glossaryGUID, ExternalIdentifierProperties externalIdentifierProperties, GlossaryTermProperties glossaryTermProperties, GlossaryTermStatus initialStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createControlledGlossaryTerm";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createControlledGlossaryTerm(userId, assetManagerGUID, assetManagerName, assetManagerIsHome, glossaryGUID, externalIdentifierProperties, glossaryTermProperties, initialStatus, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createControlledGlossaryTerm"), this.getClass().getName(), "createControlledGlossaryTerm", userId);
    }

    public String createGlossaryTermFromTemplate(String glossaryGUID, boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties, boolean deepCopy, GlossaryTermStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createGlossaryTermFromTemplate";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createGlossaryTermFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, glossaryGUID, templateGUID, externalIdentifierProperties, deepCopy, initialStatus, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createGlossaryTermFromTemplate"), this.getClass().getName(), "createGlossaryTermFromTemplate", this.userId);
    }

    public void updateGlossaryTerm(String glossaryTermGUID, String glossaryTermExternalIdentifier, boolean isMergeUpdate, GlossaryTermProperties glossaryTermProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTerm";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateGlossaryTerm"), this.getClass().getName(), "updateGlossaryTerm", this.userId);
        }
        this.glossaryManagerClient.updateGlossaryTerm(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, isMergeUpdate, glossaryTermProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateGlossaryTermStatus(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermStatus glossaryTermStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateGlossaryTermStatus";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateGlossaryTermStatus"), this.getClass().getName(), "updateGlossaryTermStatus", userId);
        }
        this.glossaryManagerClient.updateGlossaryTermStatus(userId, assetManagerGUID, assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, glossaryTermStatus, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupTermCategory(String glossaryCategoryGUID, String glossaryTermGUID, GlossaryTermCategorization categorizationProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupTermCategory";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupTermCategory"), this.getClass().getName(), "setupTermCategory", this.userId);
        }
        this.glossaryManagerClient.setupTermCategory(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, glossaryTermGUID, categorizationProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermCategory(String glossaryCategoryGUID, String glossaryTermGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermCategory";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermCategory"), this.getClass().getName(), "clearTermCategory", this.userId);
        }
        this.glossaryManagerClient.clearTermCategory(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, glossaryTermGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupTermRelationship(String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupTermRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setupTermRelationship"), this.getClass().getName(), "setupTermRelationship", this.userId);
        }
        this.glossaryManagerClient.setupTermRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, relationshipsProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateTermRelationship(String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, GlossaryTermRelationship relationshipsProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateTermRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateTermRelationship"), this.getClass().getName(), "updateTermRelationship", this.userId);
        }
        this.glossaryManagerClient.updateTermRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, relationshipsProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermRelationship(String relationshipTypeName, String glossaryTermOneGUID, String glossaryTermTwoGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermRelationship";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermRelationship"), this.getClass().getName(), "clearTermRelationship", this.userId);
        }
        this.glossaryManagerClient.clearTermRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsAbstractConcept(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsAbstractConcept";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsAbstractConcept"), this.getClass().getName(), "setTermAsAbstractConcept", this.userId);
        }
        this.glossaryManagerClient.setTermAsAbstractConcept(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsAbstractConcept(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsAbstractConcept";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsAbstractConcept"), this.getClass().getName(), "clearTermAsAbstractConcept", this.userId);
        }
        this.glossaryManagerClient.clearTermAsAbstractConcept(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsDataValue(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsDataValue";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsDataValue"), this.getClass().getName(), "setTermAsDataValue", this.userId);
        }
        this.glossaryManagerClient.setTermAsDataValue(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsDataValue(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsDataValue";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsDataValue"), this.getClass().getName(), "clearTermAsDataValue", this.userId);
        }
        this.glossaryManagerClient.clearTermAsDataValue(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsActivity(String glossaryTermGUID, String glossaryTermExternalIdentifier, ActivityDescriptionProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsActivity";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsActivity"), this.getClass().getName(), "setTermAsActivity", this.userId);
        }
        this.glossaryManagerClient.setTermAsActivity(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsActivity(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsActivity";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsActivity"), this.getClass().getName(), "clearTermAsActivity", this.userId);
        }
        this.glossaryManagerClient.clearTermAsActivity(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsContext(String glossaryTermGUID, String glossaryTermExternalIdentifier, GlossaryTermContextDefinition contextDefinition, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsContext";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsContext"), this.getClass().getName(), "setTermAsContext", this.userId);
        }
        this.glossaryManagerClient.setTermAsContext(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, contextDefinition, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsContext(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsContext";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsContext"), this.getClass().getName(), "clearTermAsContext", this.userId);
        }
        this.glossaryManagerClient.clearTermAsContext(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsSpineObject(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsSpineObject";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsSpineObject"), this.getClass().getName(), "setTermAsSpineObject", this.userId);
        }
        this.glossaryManagerClient.setTermAsSpineObject(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsSpineObject(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsSpineObject";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsSpineObject"), this.getClass().getName(), "clearTermAsSpineObject", this.userId);
        }
        this.glossaryManagerClient.clearTermAsSpineObject(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsSpineAttribute(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsSpineAttribute";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsSpineAttribute"), this.getClass().getName(), "setTermAsSpineAttribute", this.userId);
        }
        this.glossaryManagerClient.setTermAsSpineAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsSpineAttribute(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsSpineAttribute";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsSpineAttribute"), this.getClass().getName(), "clearTermAsSpineAttribute", this.userId);
        }
        this.glossaryManagerClient.clearTermAsSpineAttribute(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setTermAsObjectIdentifier(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setTermAsObjectIdentifier";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "setTermAsObjectIdentifier"), this.getClass().getName(), "setTermAsObjectIdentifier", this.userId);
        }
        this.glossaryManagerClient.setTermAsObjectIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearTermAsObjectIdentifier(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearTermAsObjectIdentifier";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "clearTermAsObjectIdentifier"), this.getClass().getName(), "clearTermAsObjectIdentifier", this.userId);
        }
        this.glossaryManagerClient.clearTermAsObjectIdentifier(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeGlossaryTerm(String glossaryTermGUID, String glossaryTermExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGlossaryTerm";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeGlossaryTerm"), this.getClass().getName(), "removeGlossaryTerm", this.userId);
        }
        this.glossaryManagerClient.removeGlossaryTerm(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, glossaryTermExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> findGlossaryTerms(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.findGlossaryTerms(this.userId, this.assetManagerGUID, this.assetManagerName, null, searchString, null, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> findGlossaryTerms(String glossaryGUID, String searchString, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.findGlossaryTerms(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, searchString, limitResultsByStatus, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getTermsForGlossary(String glossaryGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getTermsForGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getTermsForGlossaryCategory(String glossaryCategoryGUID, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getTermsForGlossaryCategory(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryCategoryGUID, limitResultsByStatus, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getRelatedTerms(String glossaryTermGUID, List<GlossaryTermRelationshipStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getRelatedTerms(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, limitResultsByStatus, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryTermsByName(this.userId, this.assetManagerGUID, this.assetManagerName, null, name, null, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getGlossaryTermsByName(String glossaryGUID, String name, List<GlossaryTermStatus> limitResultsByStatus, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryTermsByName(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, name, limitResultsByStatus, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public GlossaryTermElement getGlossaryTermByGUID(String guid, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossaryTermByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, guid, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String createExternalGlossaryLink(ExternalGlossaryLinkProperties linkProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalGlossaryLink";
        if (this.synchronizationDirection != SynchronizationDirection.TO_THIRD_PARTY) {
            return this.glossaryManagerClient.createExternalGlossaryLink(this.userId, this.assetManagerGUID, this.assetManagerName, linkProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createExternalGlossaryLink"), this.getClass().getName(), "createExternalGlossaryLink", this.userId);
    }

    public void updateExternalGlossaryLink(String externalLinkGUID, boolean isMergeUpdate, ExternalGlossaryLinkProperties linkProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateExternalGlossaryLink";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateExternalGlossaryLink"), this.getClass().getName(), "updateExternalGlossaryLink", this.userId);
        }
        this.glossaryManagerClient.updateExternalGlossaryLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, isMergeUpdate, linkProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeExternalGlossaryLink(String externalLinkGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeExternalGlossaryLink";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "removeExternalGlossaryLink"), this.getClass().getName(), "removeExternalGlossaryLink", this.userId);
        }
        this.glossaryManagerClient.removeExternalGlossaryLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void attachExternalLinkToGlossary(String externalLinkGUID, String glossaryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalLinkToGlossary";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "attachExternalLinkToGlossary"), this.getClass().getName(), "attachExternalLinkToGlossary", this.userId);
        }
        this.glossaryManagerClient.attachExternalLinkToGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, glossaryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void detachExternalLinkFromGlossary(String externalLinkGUID, String glossaryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalLinkFromGlossary";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "detachExternalLinkFromGlossary"), this.getClass().getName(), "detachExternalLinkFromGlossary", this.userId);
        }
        this.glossaryManagerClient.detachExternalLinkFromGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, glossaryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ExternalGlossaryLinkElement> getExternalLinksForGlossary(String glossaryGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getExternalLinksForGlossary(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryElement> getGlossariesForExternalLink(String externalLinkGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.glossaryManagerClient.getGlossariesForExternalLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void attachExternalCategoryLink(String externalLinkGUID, String glossaryCategoryGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalCategoryLink";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "attachExternalCategoryLink"), this.getClass().getName(), "attachExternalCategoryLink", this.userId);
        }
        this.glossaryManagerClient.attachExternalCategoryLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, glossaryCategoryGUID, linkProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void detachExternalCategoryLink(String externalLinkGUID, String glossaryCategoryGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalCategoryLink";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "detachExternalCategoryLink"), this.getClass().getName(), "detachExternalCategoryLink", this.userId);
        }
        this.glossaryManagerClient.detachExternalCategoryLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, glossaryCategoryGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void attachExternalTermLink(String externalLinkGUID, String glossaryTermGUID, ExternalGlossaryElementLinkProperties linkProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachExternalTermLink";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "attachExternalTermLink"), this.getClass().getName(), "attachExternalTermLink", this.userId);
        }
        this.glossaryManagerClient.attachExternalTermLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, glossaryTermGUID, linkProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void detachExternalTermLink(String externalLinkGUID, String glossaryTermGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachExternalTermLink";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "detachExternalTermLink"), this.getClass().getName(), "detachExternalTermLink", this.userId);
        }
        this.glossaryManagerClient.detachExternalTermLink(this.userId, this.assetManagerGUID, this.assetManagerName, externalLinkGUID, glossaryTermGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

