/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElements;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class OpenMetadataExchangeService {
    private final OpenMetadataStoreClient openMetadataStoreClient;
    private final String userId;
    private final String assetManagerGUID;
    private final String assetManagerName;
    private final String connectorName;
    private final SynchronizationDirection synchronizationDirection;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;
    private boolean assetManagerIsHome = false;

    OpenMetadataExchangeService(OpenMetadataStoreClient openMetadataStoreClient, SynchronizationDirection synchronizationDirection, String userId, String assetManagerGUID, String assetManagerName, String connectorName) {
        this.openMetadataStoreClient = openMetadataStoreClient;
        this.synchronizationDirection = synchronizationDirection;
        this.userId = userId;
        this.connectorName = connectorName;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
    }

    public boolean isAssetManagerHome() {
        return this.assetManagerIsHome;
    }

    public void setAssetManagerIsHome(boolean assetManagerIsHome) {
        this.assetManagerIsHome = assetManagerIsHome;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public OpenMetadataElement getMetadataElementByGUID(String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getMetadataElementByGUID(this.userId, elementGUID, this.forLineage, this.forDuplicateProcessing, effectiveTime);
    }

    public OpenMetadataElement getMetadataElementByUniqueName(String uniqueName, String uniquePropertyName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getMetadataElementByUniqueName(this.userId, uniqueName, uniquePropertyName, this.forLineage, this.forDuplicateProcessing, effectiveTime);
    }

    public String getMetadataElementGUIDByUniqueName(String uniqueName, String uniquePropertyName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getMetadataElementGUIDByUniqueName(this.userId, uniqueName, uniquePropertyName, this.forLineage, this.forDuplicateProcessing, effectiveTime);
    }

    public List<OpenMetadataElement> findMetadataElementsWithString(String searchString, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.findMetadataElementsWithString(this.userId, searchString, this.forLineage, this.forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElement> getRelatedMetadataElements(String elementGUID, int startingAtEnd, String relationshipTypeName, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getRelatedMetadataElements(this.userId, elementGUID, startingAtEnd, relationshipTypeName, this.forLineage, this.forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<OpenMetadataElement> findMetadataElements(String metadataElementTypeName, List<String> metadataElementSubtypeName, SearchProperties searchProperties, List<ElementStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.findMetadataElements(this.userId, metadataElementTypeName, metadataElementSubtypeName, searchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, this.forLineage, this.forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public List<RelatedMetadataElements> findRelationshipsBetweenMetadataElements(String relationshipTypeName, SearchProperties searchProperties, String sequencingProperty, SequencingOrder sequencingOrder, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.findRelationshipsBetweenMetadataElements(this.userId, relationshipTypeName, searchProperties, sequencingProperty, sequencingOrder, this.forLineage, this.forDuplicateProcessing, effectiveTime, startFrom, pageSize);
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataElementInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createMetadataElementInStore"), this.getClass().getName(), "createMetadataElementInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            return this.openMetadataStoreClient.createMetadataElementInStore(this.userId, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
    }

    public void updateMetadataElementInStore(String metadataElementGUID, boolean replaceProperties, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateMetadataElementInStore"), this.getClass().getName(), "updateMetadataElementInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.updateMetadataElementInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, effectiveTime);
        } else {
            this.openMetadataStoreClient.updateMetadataElementInStore(this.userId, metadataElementGUID, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, effectiveTime);
        }
    }

    public void updateMetadataElementStatusInStore(String metadataElementGUID, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementStatusInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateMetadataElementStatusInStore"), this.getClass().getName(), "updateMetadataElementStatusInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.updateMetadataElementStatusInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, newElementStatus, effectiveTime);
        } else {
            this.openMetadataStoreClient.updateMetadataElementStatusInStore(this.userId, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, newElementStatus, effectiveTime);
        }
    }

    public void updateMetadataElementEffectivityInStore(String metadataElementGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateMetadataElementEffectivityInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateMetadataElementEffectivityInStore"), this.getClass().getName(), "updateMetadataElementEffectivityInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.updateMetadataElementEffectivityInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        } else {
            this.openMetadataStoreClient.updateMetadataElementEffectivityInStore(this.userId, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        }
    }

    public void deleteMetadataElementInStore(String metadataElementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteMetadataElementInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "deleteMetadataElementInStore"), this.getClass().getName(), "deleteMetadataElementInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.deleteMetadataElementInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, effectiveTime);
        } else {
            this.openMetadataStoreClient.deleteMetadataElementInStore(this.userId, metadataElementGUID, this.forLineage, this.forDuplicateProcessing, effectiveTime);
        }
    }

    public void classifyMetadataElementInStore(String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "classifyMetadataElementInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "classifyMetadataElementInStore"), this.getClass().getName(), "classifyMetadataElementInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.classifyMetadataElementInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
        } else {
            this.openMetadataStoreClient.classifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
        }
    }

    public void reclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean replaceProperties, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "reclassifyMetadataElementInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "reclassifyMetadataElementInStore"), this.getClass().getName(), "reclassifyMetadataElementInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.reclassifyMetadataElementInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, classificationName, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, effectiveTime);
        } else {
            this.openMetadataStoreClient.reclassifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, effectiveTime);
        }
    }

    public void updateClassificationEffectivityInStore(String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateClassificationEffectivityInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateClassificationEffectivityInStore"), this.getClass().getName(), "updateClassificationEffectivityInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.updateClassificationEffectivityInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        } else {
            this.openMetadataStoreClient.updateClassificationEffectivityInStore(this.userId, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        }
    }

    public void unclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unclassifyMetadataElementInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "unclassifyMetadataElementInStore"), this.getClass().getName(), "unclassifyMetadataElementInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.declassifyMetadataElementInStore(this.userId, this.assetManagerGUID, this.assetManagerName, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveTime);
        } else {
            this.openMetadataStoreClient.declassifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, this.forLineage, this.forDuplicateProcessing, effectiveTime);
        }
    }

    public String createRelatedElementsInStore(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createRelatedElementsInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "createRelatedElementsInStore"), this.getClass().getName(), "createRelatedElementsInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            return this.openMetadataStoreClient.createRelatedElementsInStore(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
        }
        return this.openMetadataStoreClient.createRelatedElementsInStore(this.userId, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    public void updateRelatedElementsInStore(String relationshipGUID, boolean replaceProperties, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateRelatedElementsInStore"), this.getClass().getName(), "updateRelatedElementsInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.updateRelatedElementsInStore(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipGUID, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, effectiveTime);
        } else {
            this.openMetadataStoreClient.updateRelatedElementsInStore(this.userId, relationshipGUID, replaceProperties, this.forLineage, this.forDuplicateProcessing, properties, effectiveTime);
        }
    }

    public void updateRelatedElementsEffectivityInStore(String relationshipGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateRelatedElementsEffectivityInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "updateRelatedElementsEffectivityInStore"), this.getClass().getName(), "updateRelatedElementsEffectivityInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.updateRelatedElementsEffectivityInStore(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipGUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        } else {
            this.openMetadataStoreClient.updateRelatedElementsEffectivityInStore(this.userId, relationshipGUID, this.forLineage, this.forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
        }
    }

    public void deleteRelatedElementsInStore(String relationshipGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteRelatedElementsInStore";
        if (this.synchronizationDirection == SynchronizationDirection.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.synchronizationDirection.getName(), this.connectorName, "deleteRelatedElementsInStore"), this.getClass().getName(), "deleteRelatedElementsInStore", this.userId);
        }
        if (this.assetManagerIsHome) {
            this.openMetadataStoreClient.deleteRelatedElementsInStore(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipGUID, this.forLineage, this.forDuplicateProcessing, effectiveTime);
        } else {
            this.openMetadataStoreClient.deleteRelatedElementsInStore(this.userId, relationshipGUID, this.forLineage, this.forDuplicateProcessing, effectiveTime);
        }
    }
}

