/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorBase;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorOMISConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogTargetEventProcessor;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public abstract class CatalogIntegratorConnector
extends IntegrationConnectorBase
implements CatalogIntegratorOMISConnector {
    private CatalogIntegratorContext context = null;

    public synchronized void setContext(CatalogIntegratorContext context) {
        super.setContext((IntegrationContext)context);
        this.context = context;
    }

    public synchronized CatalogIntegratorContext getContext() throws ConnectorCheckedException {
        String methodName = "getContext";
        if (this.context != null) {
            return this.context;
        }
        if (this.auditLog != null) {
            this.auditLog.logMessage("getContext", CatalogIntegratorAuditCode.NULL_CONTEXT.getMessageDefinition(this.connectorName));
        }
        throw new ConnectorCheckedException(CatalogIntegratorErrorCode.NULL_CONTEXT.getMessageDefinition(this.connectorName), this.getClass().getName(), "getContext");
    }

    protected void passEventToCatalogTargets(CatalogTargetEventProcessor catalogTargetEventProcessor, AssetManagerOutTopicEvent event) throws ConnectorCheckedException {
        String methodName = "passEventToCatalogTargets";
        List requestedCatalogTargets = this.catalogTargetsManager.refreshKnownCatalogTargets(this.integrationContext, (CatalogTargetIntegrator)catalogTargetEventProcessor);
        if (requestedCatalogTargets == null || requestedCatalogTargets.isEmpty()) {
            this.auditLog.logMessage("passEventToCatalogTargets", OIFAuditCode.NO_CATALOG_TARGETS.getMessageDefinition(new String[]{this.connectorName}));
        } else {
            try {
                for (RequestedCatalogTarget requestedCatalogTarget : requestedCatalogTargets) {
                    boolean savedExternalSourceIsHome = this.integrationContext.getExternalSourceIsHome();
                    String savedMetadataSourceQualifiedName = this.integrationContext.getMetadataSourceQualifiedName();
                    if (requestedCatalogTarget != null && super.isActive()) {
                        try {
                            if (requestedCatalogTarget.getMetadataSourceQualifiedName() == null) {
                                this.integrationContext.setExternalSourceIsHome(false);
                            } else {
                                this.integrationContext.setMetadataSourceQualifiedName(requestedCatalogTarget.getMetadataSourceQualifiedName());
                                this.integrationContext.setExternalSourceIsHome(true);
                            }
                            this.auditLog.logMessage("passEventToCatalogTargets", OIFAuditCode.REFRESHING_CATALOG_TARGET.getMessageDefinition(new String[]{this.connectorName, requestedCatalogTarget.getCatalogTargetName()}));
                            catalogTargetEventProcessor.passEventToCatalogTarget(requestedCatalogTarget, event);
                        }
                        catch (Exception error) {
                            this.auditLog.logMessage("passEventToCatalogTargets", OIFAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{this.connectorName, error.getClass().getName(), "passEventToCatalogTargets::" + requestedCatalogTarget.getCatalogTargetName(), error.getMessage()}));
                        }
                    }
                    this.integrationContext.setExternalSourceIsHome(savedExternalSourceIsHome);
                    this.integrationContext.setMetadataSourceQualifiedName(savedMetadataSourceQualifiedName);
                }
            }
            catch (Exception error) {
                this.auditLog.logMessage("passEventToCatalogTargets", OIFAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{this.connectorName, error.getClass().getName(), "passEventToCatalogTargets", error.getMessage()}));
            }
            this.auditLog.logMessage("passEventToCatalogTargets", OIFAuditCode.REFRESHED_CATALOG_TARGETS.getMessageDefinition(new String[]{this.connectorName, Integer.toString(requestedCatalogTargets.size())}));
        }
    }
}

