/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ConnectorTypeElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.EndpointElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.connections.EndpointProperties;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class ConnectionExchangeService {
    private final ConnectionExchangeClient connectionExchangeClient;
    private final String userId;
    private final String externalSourceGUID;
    private final String externalSourceName;
    private final String connectorName;
    private final PermittedSynchronization permittedSynchronization;
    private final AuditLog auditLog;
    private boolean forLineage = false;
    private final boolean forDuplicateProcessing = false;

    ConnectionExchangeService(ConnectionExchangeClient connectionExchangeClient, PermittedSynchronization permittedSynchronization, String userId, String externalSourceGUID, String externalSourceName, String connectorName, AuditLog auditLog) {
        this.connectionExchangeClient = connectionExchangeClient;
        this.permittedSynchronization = permittedSynchronization;
        this.userId = userId;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public String createConnection(boolean externalSourceIsHome, ExternalIdentifierProperties externalIdentifierProperties, ConnectionProperties connectionProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnection";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnection(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, externalIdentifierProperties, connectionProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createConnection"), this.getClass().getName(), "createConnection", this.userId);
    }

    public String createConnectionFromTemplate(boolean externalSourceIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectionFromTemplate";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnectionFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createConnectionFromTemplate"), this.getClass().getName(), "createConnectionFromTemplate", this.userId);
    }

    public void updateConnection(String connectionGUID, String connectionExternalIdentifier, boolean isMergeUpdate, ConnectionProperties connectionProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnection";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateConnection"), this.getClass().getName(), "updateConnection", this.userId);
        }
        this.connectionExchangeClient.updateConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, connectionExternalIdentifier, isMergeUpdate, connectionProperties, effectiveTime, this.forLineage, false);
    }

    public void setupConnectorType(boolean externalSourceIsHome, String connectionGUID, String connectorTypeGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupConnectorType";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupConnectorType"), this.getClass().getName(), "setupConnectorType", this.userId);
        }
        this.connectionExchangeClient.setupConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, connectionGUID, connectorTypeGUID, effectiveFrom, effectiveTo, effectiveTime, this.forLineage, false);
    }

    public void clearConnectorType(String connectionGUID, String connectorTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConnectorType";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearConnectorType"), this.getClass().getName(), "clearConnectorType", this.userId);
        }
        this.connectionExchangeClient.clearConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, connectorTypeGUID, effectiveTime, this.forLineage, false);
    }

    public void setupEndpoint(boolean externalSourceIsHome, String connectionGUID, String endpointGUID, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEndpoint";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupEndpoint"), this.getClass().getName(), "setupEndpoint", this.userId);
        }
        this.connectionExchangeClient.setupEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, connectionGUID, endpointGUID, effectiveFrom, effectiveTo, effectiveTime, this.forLineage, false);
    }

    public void clearEndpoint(String connectionGUID, String endpointGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEndpoint";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearEndpoint"), this.getClass().getName(), "clearEndpoint", this.userId);
        }
        this.connectionExchangeClient.clearEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, endpointGUID, effectiveTime, this.forLineage, false);
    }

    public void setupEmbeddedConnection(boolean externalSourceIsHome, String connectionGUID, String embeddedConnectionGUID, EmbeddedConnectionProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupEmbeddedConnection";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupEmbeddedConnection"), this.getClass().getName(), "setupEmbeddedConnection", this.userId);
        }
        this.connectionExchangeClient.setupEmbeddedConnection(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, connectionGUID, embeddedConnectionGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearEmbeddedConnection(String connectionGUID, String embeddedConnectionGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearEmbeddedConnection";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearEmbeddedConnection"), this.getClass().getName(), "clearEmbeddedConnection", this.userId);
        }
        this.connectionExchangeClient.clearEmbeddedConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, embeddedConnectionGUID, effectiveTime, this.forLineage, false);
    }

    public void setupAssetConnection(boolean externalSourceIsHome, String assetGUID, String connectionGUID, AssetConnectionProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupAssetConnection";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupAssetConnection"), this.getClass().getName(), "setupAssetConnection", this.userId);
        }
        this.connectionExchangeClient.setupAssetConnection(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, assetGUID, connectionGUID, properties, effectiveTime, this.forLineage, false);
    }

    public void clearAssetConnection(String assetGUID, String connectionGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetConnection";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearAssetConnection"), this.getClass().getName(), "clearAssetConnection", this.userId);
        }
        this.connectionExchangeClient.clearAssetConnection(this.userId, this.externalSourceGUID, this.externalSourceName, assetGUID, connectionGUID, effectiveTime, this.forLineage, false);
    }

    public void removeConnection(String connectionGUID, String connectionExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnection";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeConnection"), this.getClass().getName(), "removeConnection", this.userId);
        }
        this.connectionExchangeClient.removeConnection(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, connectionExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<ConnectionElement> findConnections(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.findConnections(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectionElement> getConnectionsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectionsByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectionElement> getConnectionsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectionsForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public ConnectionElement getConnectionByGUID(String connectionGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectionByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, connectionGUID, effectiveTime, this.forLineage, false);
    }

    public String createEndpoint(boolean externalSourceIsHome, ExternalIdentifierProperties externalIdentifierProperties, EndpointProperties endpointProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpoint";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, externalIdentifierProperties, endpointProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createEndpoint"), this.getClass().getName(), "createEndpoint", this.userId);
    }

    public String createEndpointFromTemplate(boolean externalSourceIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createEndpointFromTemplate";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createEndpointFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createEndpointFromTemplate"), this.getClass().getName(), "createEndpointFromTemplate", this.userId);
    }

    public void updateEndpoint(String connectorTypeGUID, String endpointExternalIdentifier, boolean isMergeUpdate, EndpointProperties endpointProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateEndpoint";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateEndpoint"), this.getClass().getName(), "updateEndpoint", this.userId);
        }
        this.connectionExchangeClient.updateEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, connectorTypeGUID, endpointExternalIdentifier, isMergeUpdate, endpointProperties, effectiveTime, this.forLineage, false);
    }

    public void removeEndpoint(String connectorTypeGUID, String endpointExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeEndpoint";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeEndpoint"), this.getClass().getName(), "removeEndpoint", this.userId);
        }
        this.connectionExchangeClient.removeEndpoint(this.userId, this.externalSourceGUID, this.externalSourceName, connectorTypeGUID, endpointExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<EndpointElement> findEndpoints(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.findEndpoints(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<EndpointElement> getEndpointsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getEndpointsByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<EndpointElement> getEndpointsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getEndpointsForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public EndpointElement getEndpointByGUID(String endpointGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getEndpointByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, endpointGUID, effectiveTime, this.forLineage, false);
    }

    public String createConnectorType(boolean externalSourceIsHome, ExternalIdentifierProperties externalIdentifierProperties, ConnectorTypeProperties connectorTypeProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorType";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, externalIdentifierProperties, connectorTypeProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createConnectorType"), this.getClass().getName(), "createConnectorType", this.userId);
    }

    public String createConnectorTypeFromTemplate(boolean externalSourceIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createConnectorTypeFromTemplate";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.connectionExchangeClient.createConnectorTypeFromTemplate(this.userId, this.externalSourceGUID, this.externalSourceName, externalSourceIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createConnectorTypeFromTemplate"), this.getClass().getName(), "createConnectorTypeFromTemplate", this.userId);
    }

    public void updateConnectorType(String connectorTypeGUID, String connectorTypeExternalIdentifier, boolean isMergeUpdate, ConnectorTypeProperties connectorTypeProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateConnectorType";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateConnectorType"), this.getClass().getName(), "updateConnectorType", this.userId);
        }
        this.connectionExchangeClient.updateConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectorTypeGUID, connectorTypeExternalIdentifier, isMergeUpdate, connectorTypeProperties, effectiveTime, this.forLineage, false);
    }

    public void removeConnectorType(String connectorTypeGUID, String connectorTypeExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConnectorType";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeConnectorType"), this.getClass().getName(), "removeConnectorType", this.userId);
        }
        this.connectionExchangeClient.removeConnectorType(this.userId, this.externalSourceGUID, this.externalSourceName, connectorTypeGUID, connectorTypeExternalIdentifier, effectiveTime, this.forLineage, false);
    }

    public List<ConnectorTypeElement> findConnectorTypes(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.findConnectorTypes(this.userId, this.externalSourceGUID, this.externalSourceName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectorTypeElement> getConnectorTypesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectorTypesByName(this.userId, this.externalSourceGUID, this.externalSourceName, name, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public List<ConnectorTypeElement> getConnectorTypesForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectorTypesForAssetManager(this.userId, this.externalSourceGUID, this.externalSourceName, startFrom, pageSize, effectiveTime, this.forLineage, false);
    }

    public ConnectorTypeElement getConnectorTypeByGUID(String dataAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.connectionExchangeClient.getConnectorTypeByGUID(this.userId, this.externalSourceGUID, this.externalSourceName, dataAssetGUID, effectiveTime, this.forLineage, false);
    }
}

