/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.DataAssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelationshipElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.DataAssetProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.SchemaExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class DataAssetExchangeService
extends SchemaExchangeService {
    private final DataAssetExchangeClient dataAssetExchangeClient;

    DataAssetExchangeService(DataAssetExchangeClient dataAssetExchangeClient, PermittedSynchronization permittedSynchronization, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        super((SchemaExchangeInterface)dataAssetExchangeClient, permittedSynchronization, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.dataAssetExchangeClient = dataAssetExchangeClient;
    }

    public String createDataAsset(boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, DataAssetProperties assetProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAsset";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.createDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, externalIdentifierProperties, assetProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createDataAsset"), this.getClass().getName(), "createDataAsset", this.userId);
    }

    public String createDataAssetFromTemplate(boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDataAssetFromTemplate";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.createDataAssetFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createDataAssetFromTemplate"), this.getClass().getName(), "createDataAssetFromTemplate", this.userId);
    }

    public void updateDataAsset(String assetGUID, String assetExternalIdentifier, boolean isMergeUpdate, DataAssetProperties assetProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataAsset";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateDataAsset"), this.getClass().getName(), "updateDataAsset", this.userId);
        }
        this.dataAssetExchangeClient.updateDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, isMergeUpdate, assetProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void publishDataAsset(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishDataAsset";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "publishDataAsset"), this.getClass().getName(), "publishDataAsset", this.userId);
        }
        this.dataAssetExchangeClient.publishDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void withdrawDataAsset(String assetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawDataAsset";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "withdrawDataAsset"), this.getClass().getName(), "withdrawDataAsset", this.userId);
        }
        this.dataAssetExchangeClient.withdrawDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeDataAsset(String assetGUID, String assetExternalIdentifier, boolean cascadedDelete, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeDataAsset";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeDataAsset"), this.getClass().getName(), "removeDataAsset", this.userId);
        }
        this.dataAssetExchangeClient.removeDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, cascadedDelete, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setDataAssetAsReferenceData(String assetGUID, String assetExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setDataAssetAsReferenceData";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setDataAssetAsReferenceData"), this.getClass().getName(), "setDataAssetAsReferenceData", this.userId);
        }
        this.dataAssetExchangeClient.setDataAssetAsReferenceData(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearDataAssetAsReferenceData(String assetGUID, String assetExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataAssetAsReferenceData";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearDataAssetAsReferenceData"), this.getClass().getName(), "clearDataAssetAsReferenceData", this.userId);
        }
        this.dataAssetExchangeClient.clearDataAssetAsReferenceData(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, assetExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String setupRelatedDataAsset(boolean assetManagerIsHome, String relationshipTypeName, String fromAssetGUID, String toAssetGUID, RelationshipProperties relationshipProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupRelatedDataAsset";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.dataAssetExchangeClient.setupRelatedDataAsset(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, relationshipTypeName, fromAssetGUID, toAssetGUID, relationshipProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupRelatedDataAsset"), this.getClass().getName(), "setupRelatedDataAsset", this.userId);
    }

    public RelationshipElement getAssetRelationship(String relationshipTypeName, String fromAssetGUID, String toAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getAssetRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, fromAssetGUID, toAssetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateAssetRelationship(String relationshipTypeName, String relationshipGUID, boolean isMergeUpdate, RelationshipProperties relationshipProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAssetRelationship";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateAssetRelationship"), this.getClass().getName(), "updateAssetRelationship", this.userId);
        }
        this.dataAssetExchangeClient.updateAssetRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, relationshipGUID, isMergeUpdate, relationshipProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearAssetRelationship(String relationshipTypeName, String relationshipGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetRelationship";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearAssetRelationship"), this.getClass().getName(), "clearAssetRelationship", this.userId);
        }
        this.dataAssetExchangeClient.clearAssetRelationship(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, relationshipGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd2(String relationshipTypeName, String fromAssetGUID, int startingFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getRelatedAssetsAtEnd2(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, fromAssetGUID, startingFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelationshipElement> getRelatedAssetsAtEnd1(String relationshipTypeName, String toAssetGUID, int startingFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getRelatedAssetsAtEnd1(this.userId, this.assetManagerGUID, this.assetManagerName, relationshipTypeName, toAssetGUID, startingFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataAssetElement> findDataAssets(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.findDataAssets(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataAssetElement> getDataAssetsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataAssetElement> getDataAssetsForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetsForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public DataAssetElement getDataAssetByGUID(String dataAssetGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.dataAssetExchangeClient.getDataAssetByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, dataAssetGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

