/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.api.exchange.SchemaExchangeInterface;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.PortElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ProcessElement;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ControlFlowElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DataFlowElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.LineageMappingElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProcessCallElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.PortProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessContainmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.processes.ProcessProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ControlFlowProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.DataFlowProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.LineageMappingProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.lineage.ProcessCallProperties;
import org.odpi.openmetadata.integrationservices.catalog.connector.SchemaExchangeService;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class LineageExchangeService
extends SchemaExchangeService {
    private final LineageExchangeClient lineageExchangeClient;

    LineageExchangeService(LineageExchangeClient lineageExchangeClient, PermittedSynchronization permittedSynchronization, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        super((SchemaExchangeInterface)lineageExchangeClient, permittedSynchronization, userId, assetManagerGUID, assetManagerName, connectorName, auditLog);
        this.lineageExchangeClient = lineageExchangeClient;
    }

    public String createProcess(boolean assetManagerIsHome, ExternalIdentifierProperties externalIdentifierProperties, ProcessProperties processProperties, ProcessStatus initialStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.createProcess(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, externalIdentifierProperties, initialStatus, processProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createProcess"), this.getClass().getName(), "createProcess", this.userId);
    }

    public String createProcessFromTemplate(boolean assetManagerIsHome, String templateGUID, ExternalIdentifierProperties externalIdentifierProperties, TemplateProperties templateProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.createProcessFromTemplate(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, templateGUID, externalIdentifierProperties, templateProperties);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createProcessFromTemplate"), this.getClass().getName(), "createProcessFromTemplate", this.userId);
    }

    public void updateProcess(String processGUID, String processExternalIdentifier, boolean isMergeUpdate, ProcessProperties processProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcess";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateProcess"), this.getClass().getName(), "updateProcess", this.userId);
        }
        this.lineageExchangeClient.updateProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier, isMergeUpdate, processProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateProcessStatus(String processGUID, String processExternalIdentifier, ProcessStatus processStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessStatus";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateProcessStatus"), this.getClass().getName(), "updateProcessStatus", this.userId);
        }
        this.lineageExchangeClient.updateProcessStatus(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier, processStatus, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupProcessParent(boolean assetManagerIsHome, String parentProcessGUID, String childProcessGUID, ProcessContainmentProperties containmentProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessParent";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupProcessParent"), this.getClass().getName(), "setupProcessParent", this.userId);
        }
        this.lineageExchangeClient.setupProcessParent(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, parentProcessGUID, childProcessGUID, containmentProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearProcessParent(String parentProcessGUID, String childProcessGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessParent";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearProcessParent"), this.getClass().getName(), "clearProcessParent", this.userId);
        }
        this.lineageExchangeClient.clearProcessParent(this.userId, this.assetManagerGUID, this.assetManagerName, parentProcessGUID, childProcessGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void publishProcess(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishProcess";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "publishProcess"), this.getClass().getName(), "publishProcess", this.userId);
        }
        this.lineageExchangeClient.publishProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void withdrawProcess(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "withdrawProcess";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "withdrawProcess"), this.getClass().getName(), "withdrawProcess", this.userId);
        }
        this.lineageExchangeClient.withdrawProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeProcess(String processGUID, String processExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeProcess";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeProcess"), this.getClass().getName(), "removeProcess", this.userId);
        }
        this.lineageExchangeClient.removeProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, processExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ProcessElement> findProcesses(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findProcesses(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ProcessElement> getProcessesForAssetManager(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesForAssetManager(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ProcessElement> getProcessesByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessesByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public ProcessElement getProcessByGUID(String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public ProcessElement getProcessParent(String assetManagerGUID, String assetManagerName, String processGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessParent(this.userId, assetManagerGUID, assetManagerName, processGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ProcessElement> getSubProcesses(String processGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSubProcesses(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String createPort(boolean assetManagerIsHome, String processGUID, ExternalIdentifierProperties externalIdentifierProperties, PortProperties portProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createPort";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.createPort(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processGUID, externalIdentifierProperties, portProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createPort"), this.getClass().getName(), "createPort", this.userId);
    }

    public void updatePort(String portGUID, String portExternalIdentifier, PortProperties portProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updatePort";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updatePort"), this.getClass().getName(), "updatePort", this.userId);
        }
        this.lineageExchangeClient.updatePort(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, portExternalIdentifier, portProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupProcessPort(boolean assetManagerIsHome, String processGUID, String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessPort";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupProcessPort"), this.getClass().getName(), "setupProcessPort", this.userId);
        }
        this.lineageExchangeClient.setupProcessPort(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, processGUID, portGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearProcessPort(String processGUID, String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessPort";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearProcessPort"), this.getClass().getName(), "clearProcessPort", this.userId);
        }
        this.lineageExchangeClient.clearProcessPort(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, portGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupPortDelegation(boolean assetManagerIsHome, String portOneGUID, String portTwoGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortDelegation";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupPortDelegation"), this.getClass().getName(), "setupPortDelegation", this.userId);
        }
        this.lineageExchangeClient.setupPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, portOneGUID, portTwoGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearPortDelegation(String portOneGUID, String portTwoGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortDelegation";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearPortDelegation"), this.getClass().getName(), "clearPortDelegation", this.userId);
        }
        this.lineageExchangeClient.clearPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, portOneGUID, portTwoGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupPortSchemaType(boolean assetManagerIsHome, String portGUID, String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupPortSchemaType";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupPortSchemaType"), this.getClass().getName(), "setupPortSchemaType", this.userId);
        }
        this.lineageExchangeClient.setupPortSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, portGUID, schemaTypeGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearPortSchemaType(String portGUID, String schemaTypeGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearPortSchemaType";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearPortSchemaType"), this.getClass().getName(), "clearPortSchemaType", this.userId);
        }
        this.lineageExchangeClient.clearPortSchemaType(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, schemaTypeGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removePort(String portGUID, String portExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removePort";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removePort"), this.getClass().getName(), "removePort", this.userId);
        }
        this.lineageExchangeClient.removePort(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, portExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<PortElement> findPorts(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.findPorts(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<PortElement> getPortsForProcess(String processGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsForProcess(this.userId, this.assetManagerGUID, this.assetManagerName, processGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<PortElement> getPortUse(String portGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortUse(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public PortElement getPortDelegation(String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortDelegation(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<PortElement> getPortsByName(String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortsByName(this.userId, this.assetManagerGUID, this.assetManagerName, name, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public PortElement getPortByGUID(String portGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getPortByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, portGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setBusinessSignificant(String elementGUID, String elementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setBusinessSignificant";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setBusinessSignificant"), this.getClass().getName(), "setBusinessSignificant", this.userId);
        }
        this.lineageExchangeClient.setBusinessSignificant(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, elementExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearBusinessSignificant(String elementGUID, String elementExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearBusinessSignificant";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearBusinessSignificant"), this.getClass().getName(), "clearBusinessSignificant", this.userId);
        }
        this.lineageExchangeClient.clearBusinessSignificant(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, elementExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String setupDataFlow(boolean assetManagerIsHome, String dataSupplierGUID, String dataConsumerGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupDataFlow";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.setupDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, dataSupplierGUID, dataConsumerGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupDataFlow"), this.getClass().getName(), "setupDataFlow", this.userId);
    }

    public DataFlowElement getDataFlow(String dataSupplierGUID, String dataConsumerGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataSupplierGUID, dataConsumerGUID, qualifiedName, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateDataFlow(String dataFlowGUID, DataFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataFlow";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateDataFlow"), this.getClass().getName(), "updateDataFlow", this.userId);
        }
        this.lineageExchangeClient.updateDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataFlowGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearDataFlow(String dataFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearDataFlow";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearDataFlow"), this.getClass().getName(), "clearDataFlow", this.userId);
        }
        this.lineageExchangeClient.clearDataFlow(this.userId, this.assetManagerGUID, this.assetManagerName, dataFlowGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataFlowElement> getDataFlowConsumers(String dataSupplierGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowConsumers(this.userId, this.assetManagerGUID, this.assetManagerName, dataSupplierGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<DataFlowElement> getDataFlowSuppliers(String dataConsumerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDataFlowSuppliers(this.userId, this.assetManagerGUID, this.assetManagerName, dataConsumerGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String setupControlFlow(boolean assetManagerIsHome, String currentStepGUID, String nextStepGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupControlFlow";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.setupControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, currentStepGUID, nextStepGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupControlFlow"), this.getClass().getName(), "setupControlFlow", this.userId);
    }

    public ControlFlowElement getControlFlow(String currentStepGUID, String nextStepGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID, nextStepGUID, qualifiedName, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateControlFlow(String controlFlowGUID, ControlFlowProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateControlFlow";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateControlFlow"), this.getClass().getName(), "updateControlFlow", this.userId);
        }
        this.lineageExchangeClient.updateControlFlow(this.userId, this.assetManagerGUID, this.assetManagerName, controlFlowGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearControlFlow(String assetManagerGUID, String assetManagerName, String controlFlowGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearControlFlow";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearControlFlow"), this.getClass().getName(), "clearControlFlow", this.userId);
        }
        this.lineageExchangeClient.clearControlFlow(this.userId, assetManagerGUID, assetManagerName, controlFlowGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ControlFlowElement> getControlFlowNextSteps(String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowNextSteps(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ControlFlowElement> getControlFlowPreviousSteps(String currentStepGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getControlFlowPreviousSteps(this.userId, this.assetManagerGUID, this.assetManagerName, currentStepGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public String setupProcessCall(boolean assetManagerIsHome, String callerGUID, String calledGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupProcessCall";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.lineageExchangeClient.setupProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, assetManagerIsHome, callerGUID, calledGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupProcessCall"), this.getClass().getName(), "setupProcessCall", this.userId);
    }

    public ProcessCallElement getProcessCall(String callerGUID, String calledGUID, String qualifiedName, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, callerGUID, calledGUID, qualifiedName, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void updateProcessCall(String processCallGUID, ProcessCallProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateProcessCall";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateProcessCall"), this.getClass().getName(), "updateProcessCall", this.userId);
        }
        this.lineageExchangeClient.updateProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, processCallGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearProcessCall(String processCallGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearProcessCall";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearProcessCall"), this.getClass().getName(), "clearProcessCall", this.userId);
        }
        this.lineageExchangeClient.clearProcessCall(this.userId, this.assetManagerGUID, this.assetManagerName, processCallGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ProcessCallElement> getProcessCalled(String callerGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCalled(this.userId, this.assetManagerGUID, this.assetManagerName, callerGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ProcessCallElement> getProcessCallers(String calledGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getProcessCallers(this.userId, this.assetManagerGUID, this.assetManagerName, calledGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupLineageMapping(String sourceElementGUID, String destinationElementGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupLineageMapping";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupLineageMapping"), this.getClass().getName(), "setupLineageMapping", this.userId);
        }
        this.lineageExchangeClient.setupLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, destinationElementGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public LineageMappingElement getLineageMapping(String sourceElementGUID, String destinationElementGUID, String qualifiedName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, destinationElementGUID, qualifiedName, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void updateLineageMapping(String lineageMappingGUID, LineageMappingProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateLineageMapping";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateLineageMapping"), this.getClass().getName(), "updateLineageMapping", this.userId);
        }
        this.lineageExchangeClient.updateLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, lineageMappingGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearLineageMapping(String lineageMappingGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearLineageMapping";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearLineageMapping"), this.getClass().getName(), "clearLineageMapping", this.userId);
        }
        this.lineageExchangeClient.clearLineageMapping(this.userId, this.assetManagerGUID, this.assetManagerName, lineageMappingGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<LineageMappingElement> getDestinationLineageMappings(String sourceElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getDestinationLineageMappings(this.userId, this.assetManagerGUID, this.assetManagerName, sourceElementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<LineageMappingElement> getSourceLineageMappings(String destinationElementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.lineageExchangeClient.getSourceLineageMappings(this.userId, this.assetManagerGUID, this.assetManagerName, destinationElementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

