/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.openmetadata.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.TranslationDetail;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ValidMetadataValue;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ValidMetadataValueDetail;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.ContextEventImpactProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.ContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.DependentContextEventProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.contextevents.RelatedContextEventProperties;

public class OpenMetadataGovernanceService {
    private final OpenMetadataStoreClient openMetadataStoreClient;
    private final String userId;
    private final String connectorName;
    private final String originatorGUID;

    OpenMetadataGovernanceService(OpenMetadataStoreClient openMetadataStoreClient, String userId, String connectorName, String originatorGUID) {
        this.openMetadataStoreClient = openMetadataStoreClient;
        this.userId = userId;
        this.connectorName = connectorName;
        this.originatorGUID = originatorGUID;
    }

    public String createIncidentReport(String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties, String originatorGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createIncidentReport(this.userId, qualifiedName, domainIdentifier, background, impactedResources, previousIncidents, incidentClassifiers, additionalProperties, originatorGUID);
    }

    public String openToDo(String qualifiedName, String title, String instructions, String todoCategory, int priority, Date dueDate, Map<String, String> additionalProperties, String assignTo, String sponsorGUID, List<NewActionTarget> actionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.openToDo(this.userId, qualifiedName, title, instructions, todoCategory, priority, dueDate, additionalProperties, assignTo, sponsorGUID, this.originatorGUID, actionTargets);
    }

    public String registerContextEvent(String anchorGUID, Map<String, DependentContextEventProperties> parentContextEvents, Map<String, DependentContextEventProperties> childContextEvents, Map<String, RelatedContextEventProperties> relatedContextEvents, Map<String, ContextEventImpactProperties> impactedElements, Map<String, RelationshipProperties> effectedDataResourceGUIDs, Map<String, RelationshipProperties> contextEventEvidenceGUIDs, ContextEventProperties contextEventProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.registerContextEvent(this.userId, anchorGUID, parentContextEvents, childContextEvents, relatedContextEvents, impactedElements, effectedDataResourceGUIDs, contextEventEvidenceGUIDs, contextEventProperties);
    }

    public void setTranslation(String elementGUID, TranslationDetail translationDetail) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.setTranslation(this.userId, elementGUID, translationDetail);
    }

    public void clearTranslation(String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.clearTranslation(this.userId, elementGUID, language, locale);
    }

    public TranslationDetail getTranslation(String elementGUID, String language, String locale) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getTranslation(this.userId, elementGUID, language, locale);
    }

    public List<TranslationDetail> getTranslations(String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getTranslations(this.userId, elementGUID, startFrom, pageSize);
    }

    public void setUpValidMetadataValue(String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.setUpValidMetadataValue(this.userId, typeName, propertyName, validMetadataValue);
    }

    public void setUpValidMetadataMapName(String typeName, String propertyName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.setUpValidMetadataMapName(this.userId, typeName, propertyName, validMetadataValue);
    }

    public void setUpValidMetadataMapValue(String typeName, String propertyName, String mapName, ValidMetadataValue validMetadataValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.setUpValidMetadataMapValue(this.userId, typeName, propertyName, mapName, validMetadataValue);
    }

    public void clearValidMetadataValue(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.clearValidMetadataValue(this.userId, typeName, propertyName, preferredValue);
    }

    public void clearValidMetadataMapName(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.clearValidMetadataMapName(this.userId, typeName, propertyName, preferredValue);
    }

    public void clearValidMetadataMapValue(String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStoreClient.clearValidMetadataMapValue(this.userId, typeName, propertyName, mapName, preferredValue);
    }

    public boolean validateMetadataValue(String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.validateMetadataValue(this.userId, typeName, propertyName, actualValue);
    }

    public boolean validateMetadataMapName(String typeName, String propertyName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.validateMetadataMapName(this.userId, typeName, propertyName, actualValue);
    }

    public boolean validateMetadataMapValue(String typeName, String propertyName, String mapName, String actualValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.validateMetadataMapValue(this.userId, typeName, propertyName, mapName, actualValue);
    }

    public ValidMetadataValue getValidMetadataValue(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getValidMetadataValue(this.userId, typeName, propertyName, preferredValue);
    }

    public ValidMetadataValue getValidMetadataMapName(String typeName, String propertyName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getValidMetadataMapName(this.userId, typeName, propertyName, preferredValue);
    }

    public ValidMetadataValue getValidMetadataMapValue(String typeName, String propertyName, String mapName, String preferredValue) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getValidMetadataMapValue(this.userId, typeName, propertyName, mapName, preferredValue);
    }

    public List<ValidMetadataValueDetail> getValidMetadataValues(String typeName, String propertyName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.getValidMetadataValues(this.userId, typeName, propertyName, startFrom, pageSize);
    }
}

