/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.StewardshipExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.AssetElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GovernanceDefinitionElement;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindPropertyNamesProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.AssetOriginProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.FindAssetOriginProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.OwnerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.RetentionClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SemanticAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityTagsProperties;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class StewardshipExchangeService {
    private final StewardshipExchangeClient stewardshipExchangeClient;
    private final String userId;
    private final String assetManagerGUID;
    private final String assetManagerName;
    private final String connectorName;
    private final PermittedSynchronization permittedSynchronization;
    private final AuditLog auditLog;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;

    StewardshipExchangeService(StewardshipExchangeClient stewardshipExchangeClient, PermittedSynchronization permittedSynchronization, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.stewardshipExchangeClient = stewardshipExchangeClient;
        this.permittedSynchronization = permittedSynchronization;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public void setConfidenceClassification(String elementGUID, String externalIdentifier, GovernanceClassificationProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConfidenceClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setConfidenceClassification"), this.getClass().getName(), "setConfidenceClassification", this.userId);
        }
        this.stewardshipExchangeClient.setConfidenceClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearConfidenceClassification(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConfidenceClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearConfidenceClassification"), this.getClass().getName(), "clearConfidenceClassification", this.userId);
        }
        this.stewardshipExchangeClient.clearConfidenceClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getConfidenceClassifiedElements(boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getConfidenceClassifiedElements(this.userId, this.assetManagerGUID, this.assetManagerName, returnSpecificLevel, levelIdentifier, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setCriticalityClassification(String elementGUID, GovernanceClassificationProperties properties, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setCriticalityClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setCriticalityClassification"), this.getClass().getName(), "setCriticalityClassification", this.userId);
        }
        this.stewardshipExchangeClient.setCriticalityClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, properties, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearCriticalityClassification(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearCriticalityClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearCriticalityClassification"), this.getClass().getName(), "clearCriticalityClassification", this.userId);
        }
        this.stewardshipExchangeClient.clearCriticalityClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getCriticalityClassifiedElements(boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getCriticalityClassifiedElements(this.userId, this.assetManagerGUID, this.assetManagerName, returnSpecificLevel, levelIdentifier, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setConfidentialityClassification(String elementGUID, String externalIdentifier, GovernanceClassificationProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setConfidentialityClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setConfidentialityClassification"), this.getClass().getName(), "setConfidentialityClassification", this.userId);
        }
        this.stewardshipExchangeClient.setConfidentialityClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearConfidentialityClassification(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearConfidentialityClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearConfidentialityClassification"), this.getClass().getName(), "clearConfidentialityClassification", this.userId);
        }
        this.stewardshipExchangeClient.clearConfidentialityClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getConfidentialityClassifiedElements(boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getConfidentialityClassifiedElements(this.userId, this.assetManagerGUID, this.assetManagerName, returnSpecificLevel, levelIdentifier, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setRetentionClassification(String elementGUID, String externalIdentifier, RetentionClassificationProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setRetentionClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setRetentionClassification"), this.getClass().getName(), "setRetentionClassification", this.userId);
        }
        this.stewardshipExchangeClient.setRetentionClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearRetentionClassification(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearRetentionClassification";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearRetentionClassification"), this.getClass().getName(), "clearRetentionClassification", this.userId);
        }
        this.stewardshipExchangeClient.clearRetentionClassification(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getRetentionClassifiedElements(boolean returnSpecificBasisIdentifier, int basisIdentifier, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getRetentionClassifiedElements(this.userId, this.assetManagerGUID, this.assetManagerName, returnSpecificBasisIdentifier, basisIdentifier, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void addSecurityTags(String elementGUID, String externalIdentifier, SecurityTagsProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addSecurityTags";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "addSecurityTags"), this.getClass().getName(), "addSecurityTags", this.userId);
        }
        this.stewardshipExchangeClient.addSecurityTags(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearSecurityTags(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSecurityTags";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearSecurityTags"), this.getClass().getName(), "clearSecurityTags", this.userId);
        }
        this.stewardshipExchangeClient.clearSecurityTags(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getSecurityTaggedElements(int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getSecurityTaggedElements(this.userId, this.assetManagerGUID, this.assetManagerName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void addOwnership(String elementGUID, String externalIdentifier, OwnerProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addOwnership";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "addOwnership"), this.getClass().getName(), "addOwnership", this.userId);
        }
        this.stewardshipExchangeClient.addOwnership(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearOwnership(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearOwnership";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearOwnership"), this.getClass().getName(), "clearOwnership", this.userId);
        }
        this.stewardshipExchangeClient.clearOwnership(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getOwnersElements(String owner, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getOwnersElements(this.userId, this.assetManagerGUID, this.assetManagerName, owner, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void addAssetOrigin(String assetGUID, String externalIdentifier, AssetOriginProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAssetOrigin";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "addAssetOrigin"), this.getClass().getName(), "addAssetOrigin", this.userId);
        }
        this.stewardshipExchangeClient.addAssetOrigin(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearAssetOrigin(String assetGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearAssetOrigin";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearAssetOrigin"), this.getClass().getName(), "clearAssetOrigin", this.userId);
        }
        this.stewardshipExchangeClient.clearAssetOrigin(this.userId, this.assetManagerGUID, this.assetManagerName, assetGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<AssetElement> getAssetsByOrigin(FindAssetOriginProperties properties, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getAssetsByOrigin(this.userId, this.assetManagerGUID, this.assetManagerName, properties, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void addElementToSubjectArea(String elementGUID, String externalIdentifier, SubjectAreaClassificationProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addElementToSubjectArea";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "addElementToSubjectArea"), this.getClass().getName(), "addElementToSubjectArea", this.userId);
        }
        this.stewardshipExchangeClient.addElementToSubjectArea(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeElementFromSubjectArea(String elementGUID, String externalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeElementFromSubjectArea";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeElementFromSubjectArea"), this.getClass().getName(), "removeElementFromSubjectArea", this.userId);
        }
        this.stewardshipExchangeClient.removeElementFromSubjectArea(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, externalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getMembersOfSubjectArea(String subjectAreaName, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getMembersOfSubjectArea(this.userId, this.assetManagerGUID, this.assetManagerName, subjectAreaName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void setupSemanticAssignment(String elementGUID, String glossaryTermGUID, SemanticAssignmentProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setupSemanticAssignment";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "setupSemanticAssignment"), this.getClass().getName(), "setupSemanticAssignment", this.userId);
        }
        this.stewardshipExchangeClient.setupSemanticAssignment(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, glossaryTermGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void clearSemanticAssignment(String elementGUID, String glossaryTermGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "clearSemanticAssignment";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "clearSemanticAssignment"), this.getClass().getName(), "clearSemanticAssignment", this.userId);
        }
        this.stewardshipExchangeClient.clearSemanticAssignment(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, glossaryTermGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GlossaryTermElement> getMeanings(String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getMeanings(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelatedMetadataElementSummary> getSemanticAssignees(String glossaryTermGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getSemanticAssignees(this.userId, this.assetManagerGUID, this.assetManagerName, glossaryTermGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void addGovernanceDefinitionToElement(String definitionGUID, String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addGovernanceDefinitionToElement";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "addGovernanceDefinitionToElement"), this.getClass().getName(), "addGovernanceDefinitionToElement", this.userId);
        }
        this.stewardshipExchangeClient.addGovernanceDefinitionToElement(this.userId, this.assetManagerGUID, this.assetManagerName, definitionGUID, elementGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeGovernanceDefinitionFromElement(String definitionGUID, String elementGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeGovernanceDefinitionFromElement";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeGovernanceDefinitionFromElement"), this.getClass().getName(), "removeGovernanceDefinitionFromElement", this.userId);
        }
        this.stewardshipExchangeClient.removeGovernanceDefinitionFromElement(this.userId, this.assetManagerGUID, this.assetManagerName, definitionGUID, elementGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<GovernanceDefinitionElement> getGovernedByDefinitions(String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getGovernedByDefinitions(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelatedMetadataElementSummary> getGovernedElements(String governanceDefinitionGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getGovernedElements(this.userId, this.assetManagerGUID, this.assetManagerName, governanceDefinitionGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelatedMetadataElementSummary> getSourceElements(String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getSourceElements(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<RelatedMetadataElementSummary> getElementsSourceFrom(String elementGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getElementsSourceFrom(this.userId, this.assetManagerGUID, this.assetManagerName, elementGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getElements(FindProperties findProperties, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.getElements(this.userId, findProperties, startFrom, pageSize, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> getElementsByPropertyValue(FindPropertyNamesProperties findProperties, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsByPropertyValue";
        return this.stewardshipExchangeClient.getElementsByPropertyValue(this.userId, findProperties, startFrom, pageSize, this.forLineage, this.forDuplicateProcessing);
    }

    public List<MetadataElementSummary> findElementsByPropertyValue(FindPropertyNamesProperties findProperties, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.stewardshipExchangeClient.findElementsByPropertyValue(this.userId, findProperties, startFrom, pageSize, this.forLineage, this.forDuplicateProcessing);
    }
}

