/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ValidValuesExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ReferenceValueAssignmentDefinitionElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ReferenceValueAssignmentItemElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.ValidValueMember;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ValidValueProperties;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class ValidValuesExchangeService {
    private final ValidValuesExchangeClient validValuesExchangeClient;
    private final String userId;
    private final String assetManagerGUID;
    private final String assetManagerName;
    private final String connectorName;
    private final PermittedSynchronization permittedSynchronization;
    private final AuditLog auditLog;
    private boolean forLineage = false;
    private boolean forDuplicateProcessing = false;

    ValidValuesExchangeService(ValidValuesExchangeClient validValuesExchangeClient, PermittedSynchronization permittedSynchronization, String userId, String assetManagerGUID, String assetManagerName, String connectorName, AuditLog auditLog) {
        this.validValuesExchangeClient = validValuesExchangeClient;
        this.permittedSynchronization = permittedSynchronization;
        this.userId = userId;
        this.assetManagerGUID = assetManagerGUID;
        this.assetManagerName = assetManagerName;
        this.connectorName = connectorName;
        this.auditLog = auditLog;
    }

    public boolean isForLineage() {
        return this.forLineage;
    }

    public void setForLineage(boolean forLineage) {
        this.forLineage = forLineage;
    }

    public boolean isForDuplicateProcessing() {
        return this.forDuplicateProcessing;
    }

    public void setForDuplicateProcessing(boolean forDuplicateProcessing) {
        this.forDuplicateProcessing = forDuplicateProcessing;
    }

    public String createValidValueSet(ExternalIdentifierProperties externalIdentifierProperties, ValidValueProperties validValueProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueSet";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.validValuesExchangeClient.createValidValueSet(this.userId, this.assetManagerGUID, this.assetManagerName, externalIdentifierProperties, validValueProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createValidValueSet"), this.getClass().getName(), "createValidValueSet", this.userId);
    }

    public String createValidValueDefinition(String setGUID, ExternalIdentifierProperties externalIdentifierProperties, ValidValueProperties validValueProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createValidValueDefinition";
        if (this.permittedSynchronization != PermittedSynchronization.TO_THIRD_PARTY) {
            return this.validValuesExchangeClient.createValidValueDefinition(this.userId, this.assetManagerGUID, this.assetManagerName, setGUID, externalIdentifierProperties, validValueProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
        }
        throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "createValidValueDefinition"), this.getClass().getName(), "createValidValueDefinition", this.userId);
    }

    public void updateValidValue(String validValueGUID, String validValueExternalIdentifier, boolean isMergeUpdate, ValidValueProperties validValueProperties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateValidValue";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "updateValidValue"), this.getClass().getName(), "updateValidValue", this.userId);
        }
        this.validValuesExchangeClient.updateValidValue(this.userId, this.assetManagerGUID, this.assetManagerName, validValueGUID, validValueExternalIdentifier, isMergeUpdate, validValueProperties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void removeValidValue(String validValueGUID, String validValueExternalIdentifier, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeValidValue";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "removeValidValue"), this.getClass().getName(), "removeValidValue", this.userId);
        }
        this.validValuesExchangeClient.removeValidValue(this.userId, this.assetManagerGUID, this.assetManagerName, validValueGUID, validValueExternalIdentifier, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void attachValidValueToSet(String setGUID, String validValueGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachValidValueToSet";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "attachValidValueToSet"), this.getClass().getName(), "attachValidValueToSet", this.userId);
        }
        this.validValuesExchangeClient.attachValidValueToSet(this.userId, this.assetManagerGUID, this.assetManagerName, setGUID, validValueGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void attachValidValueToSet(String setGUID, String validValueGUID, ValidValueMembershipProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "attachValidValueToSet";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "attachValidValueToSet"), this.getClass().getName(), "attachValidValueToSet", this.userId);
        }
        this.validValuesExchangeClient.attachValidValueToSet(this.userId, this.assetManagerGUID, this.assetManagerName, setGUID, validValueGUID, properties, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void detachValidValueFromSet(String setGUID, String validValueGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "detachValidValueFromSet";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "detachValidValueFromSet"), this.getClass().getName(), "detachValidValueFromSet", this.userId);
        }
        this.validValuesExchangeClient.detachValidValueFromSet(this.userId, this.assetManagerGUID, this.assetManagerName, setGUID, validValueGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public void assignReferenceValueToItem(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, String referenceableGUID, ReferenceValueAssignmentProperties properties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "assignReferenceValueToItem";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "assignReferenceValueToItem"), this.getClass().getName(), "assignReferenceValueToItem", userId);
        }
        this.validValuesExchangeClient.assignReferenceValueToItem(userId, assetManagerGUID, assetManagerName, validValueGUID, referenceableGUID, properties, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public void unassignReferenceValueFromItem(String userId, String assetManagerGUID, String assetManagerName, String validValueGUID, String referenceableGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unassignReferenceValueFromItem";
        if (this.permittedSynchronization == PermittedSynchronization.TO_THIRD_PARTY) {
            throw new UserNotAuthorizedException(CatalogIntegratorErrorCode.NOT_PERMITTED_SYNCHRONIZATION.getMessageDefinition(this.permittedSynchronization.getName(), this.connectorName, "unassignReferenceValueFromItem"), this.getClass().getName(), "unassignReferenceValueFromItem", userId);
        }
        this.validValuesExchangeClient.unassignReferenceValueFromItem(userId, assetManagerGUID, assetManagerName, validValueGUID, referenceableGUID, effectiveTime, forLineage, forDuplicateProcessing);
    }

    public ValidValueElement getValidValueByGUID(String validValueGUID, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.getValidValueByGUID(this.userId, this.assetManagerGUID, this.assetManagerName, validValueGUID, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ValidValueElement> getValidValueByName(String validValueName, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.getValidValueByName(this.userId, this.assetManagerGUID, this.assetManagerName, validValueName, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ValidValueElement> findValidValues(String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.findValidValues(this.userId, this.assetManagerGUID, this.assetManagerName, searchString, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ValidValueMember> getValidValueSetMembers(String validValueSetGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.getValidValueSetMembers(this.userId, this.assetManagerGUID, this.assetManagerName, validValueSetGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ValidValueElement> getSetsForValidValue(String validValueGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.getSetsForValidValue(this.userId, this.assetManagerGUID, this.assetManagerName, validValueGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ReferenceValueAssignmentItemElement> getReferenceValueAssignedItems(String validValueGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.getReferenceValueAssignedItems(this.userId, this.assetManagerGUID, this.assetManagerName, validValueGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }

    public List<ReferenceValueAssignmentDefinitionElement> getReferenceValueAssignments(String referenceableGUID, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.validValuesExchangeClient.getReferenceValueAssignments(this.userId, this.assetManagerGUID, this.assetManagerName, referenceableGUID, startFrom, pageSize, effectiveTime, this.forLineage, this.forDuplicateProcessing);
    }
}

