/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum CatalogIntegratorErrorCode implements ExceptionMessageSet
{
    INVALID_CONNECTOR(400, "OMIS-CATALOG-INTEGRATOR-400-001", "Integration connector {0} is not of the correct type to run in the {1} integration service.  It must inherit from {2}", "The integration service fails to start and this in turn causes the integration daemon to fail.", "The connector was configured through the administration calls for the integration service.Either move it to an appropriate integration service or update the connector implementation to inherit from the correct class."),
    DISABLED_EXCHANGE_SERVICE(400, "OMIS-CATALOG-INTEGRATOR-400-002", "The {0} has been disabled by the configuration for the {1} integration service", "The integration service's context is unable to return the client interface to this service.", "The exchange service was disabled through the administration calls for the integration service.Either change the configuration of the integration service or change the connector to skip the part of the synchronization that uses this exchange service since the organization does not want this type of metadata synchronized."),
    NOT_PERMITTED_SYNCHRONIZATION(400, "OMIS-CATALOG-INTEGRATOR-400-003", "The permitted synchronization direction of {0} does not allow connector {1} to issue {2} requests on behalf of asset manager {3}", "The request is not issued and an exception is returned to the caller.", "The request was disabled through the administration calls for the integration connector.Either change the configuration of the integration service or change the connector to skip the part of the synchronization that uses this request since the organization does not want this type of metadata synchronized."),
    BAD_CONFIG_PROPERTIES(400, "OMIS-CATALOG-INTEGRATOR-400-004", "The {0} Open Metadata Integration Service (OMIS) has been passed an invalid value of {1} in the {2} property.  The resulting exception of {3} included the following message: {4}", "The access service has not been passed valid configuration .", "Correct the value of the failing configuration property and restart the server."),
    NULL_ELEMENT_PASSED(400, "OMIS-CATALOG-INTEGRATOR-400-006", "Integration connector {0} has passed a null element to {1} in parameter {2}", "The integration connector called the method with a null element. This means it has a logic error because the element should not be null.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server. Look at the logic and path through the code and correct the error."),
    NULL_CONTEXT(400, "OMIS-CATALOG-INTEGRATOR-500-001", "Integration connector {0} has a null context", "The integration connector is running but does not have a context.  This is a timing issue in the integration daemon.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private CatalogIntegratorErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

