/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.contextmanager;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.CollaborationExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalReferenceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.InfrastructureExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.StewardshipExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ValidValuesExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.SynchronizationDirection;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class CatalogIntegratorContextManager
extends IntegrationContextManager {
    private static String disabledExchangeServicesOption = "disabledExchangeServices";
    private ExternalAssetManagerClient assetManagerClient;
    private CollaborationExchangeClient collaborationExchangeClient;
    private ConnectionExchangeClient connectionExchangeClient;
    private DataAssetExchangeClient dataAssetExchangeClient;
    private ExternalReferenceExchangeClient externalReferenceExchangeClient;
    private GlossaryExchangeClient glossaryExchangeClient;
    private GovernanceExchangeClient governanceExchangeClient;
    private InfrastructureExchangeClient infrastructureExchangeClient;
    private LineageExchangeClient lineageExchangeClient;
    private StewardshipExchangeClient stewardshipExchangeClient;
    private ValidValuesExchangeClient validValuesExchangeClient;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", CatalogIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        AssetManagerRESTClient restClient = this.localServerPassword == null ? new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.assetManagerClient = new ExternalAssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.collaborationExchangeClient = new CollaborationExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.connectionExchangeClient = new ConnectionExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.dataAssetExchangeClient = new DataAssetExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.externalReferenceExchangeClient = new ExternalReferenceExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.glossaryExchangeClient = new GlossaryExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.governanceExchangeClient = new GovernanceExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.infrastructureExchangeClient = new InfrastructureExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.lineageExchangeClient = new LineageExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.stewardshipExchangeClient = new StewardshipExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
        this.validValuesExchangeClient = new ValidValuesExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.assetManagerClient.getExternalAssetManagerGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            AssetManagerProperties properties = new AssetManagerProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.assetManagerClient.createExternalAssetManager(this.localServerUserId, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (!(integrationConnector instanceof CatalogIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(CatalogIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName(), CatalogIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", CatalogIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        AssetManagerEventClient eventClient = new AssetManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.maxPageSize, this.auditLog, connectorId);
        CatalogIntegratorConnector serviceSpecificConnector = (CatalogIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        serviceSpecificConnector.setContext(new CatalogIntegratorContext(this.assetManagerClient, eventClient, this.collaborationExchangeClient, this.connectionExchangeClient, this.dataAssetExchangeClient, this.externalReferenceExchangeClient, this.glossaryExchangeClient, this.governanceExchangeClient, this.infrastructureExchangeClient, this.lineageExchangeClient, this.stewardshipExchangeClient, this.validValuesExchangeClient, this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName, connectorName, IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.getSynchronizationDirection(permittedSynchronization), this.extractDisabledExchangeServices(this.serviceOptions, connectorName), this.auditLog));
    }

    private SynchronizationDirection getSynchronizationDirection(PermittedSynchronization permittedSynchronization) {
        if (permittedSynchronization != null) {
            switch (permittedSynchronization) {
                case TO_THIRD_PARTY: {
                    return SynchronizationDirection.TO_THIRD_PARTY;
                }
                case FROM_THIRD_PARTY: {
                    return SynchronizationDirection.FROM_THIRD_PARTY;
                }
                case BOTH_DIRECTIONS: {
                    return SynchronizationDirection.BOTH_DIRECTIONS;
                }
                case OTHER: {
                    return SynchronizationDirection.OTHER;
                }
            }
        }
        return SynchronizationDirection.BOTH_DIRECTIONS;
    }

    private List<String> extractDisabledExchangeServices(Map<String, Object> serviceOptions, String connectorName) throws InvalidParameterException {
        String methodName = "extractDisabledExchangeServices";
        if (serviceOptions == null) {
            return null;
        }
        Object serviceListObject = serviceOptions.get(disabledExchangeServicesOption);
        if (serviceListObject == null) {
            return null;
        }
        try {
            List serviceList = (List)serviceListObject;
            this.auditLog.logMessage("extractDisabledExchangeServices", CatalogIntegratorAuditCode.DISABLED_EXCHANGE_SERVICES.getMessageDefinition(new String[]{connectorName, serviceList.toString()}));
            return serviceList;
        }
        catch (Exception error) {
            String parameterName = "serviceOptions";
            throw new InvalidParameterException(CatalogIntegratorErrorCode.BAD_CONFIG_PROPERTIES.getMessageDefinition(new String[]{IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName(), serviceListObject.toString(), disabledExchangeServicesOption, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "extractDisabledExchangeServices", "serviceOptions");
        }
    }
}

