/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.contextmanager;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.CollaborationExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ConnectionExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.DataAssetExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ExternalReferenceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GovernanceExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.InfrastructureExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.LineageExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.StewardshipExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.ValidValuesExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.catalog.ffdc.CatalogIntegratorErrorCode;

public class CatalogIntegratorContextManager
extends IntegrationContextManager {
    private static final String disabledExchangeServicesOption = "disabledExchangeServices";
    private ConnectedAssetClient connectedAssetClient;
    private OpenMetadataStoreClient openMetadataStoreClient;
    private ExternalAssetManagerClient assetManagerClient;
    private CollaborationExchangeClient collaborationExchangeClient;
    private ConnectionExchangeClient connectionExchangeClient;
    private DataAssetExchangeClient dataAssetExchangeClient;
    private ExternalReferenceExchangeClient externalReferenceExchangeClient;
    private GlossaryExchangeClient glossaryExchangeClient;
    private GovernanceExchangeClient governanceExchangeClient;
    private InfrastructureExchangeClient infrastructureExchangeClient;
    private LineageExchangeClient lineageExchangeClient;
    private StewardshipExchangeClient stewardshipExchangeClient;
    private ValidValuesExchangeClient validValuesExchangeClient;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", CatalogIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients(int maxPageSize) throws InvalidParameterException {
        AssetManagerRESTClient restClient;
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        ((IntegrationContextManager)this).openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.actionControlInterface = new OpenGovernanceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.governanceConfiguration = new GovernanceConfigurationClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        if (this.localServerPassword == null) {
            restClient = new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog);
            this.connectedAssetClient = new ConnectedAssetClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog);
            this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        } else {
            restClient = new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
            this.connectedAssetClient = new ConnectedAssetClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
            this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, maxPageSize);
        }
        this.assetManagerClient = new ExternalAssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.collaborationExchangeClient = new CollaborationExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.connectionExchangeClient = new ConnectionExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.dataAssetExchangeClient = new DataAssetExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.externalReferenceExchangeClient = new ExternalReferenceExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.glossaryExchangeClient = new GlossaryExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.governanceExchangeClient = new GovernanceExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.infrastructureExchangeClient = new InfrastructureExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.lineageExchangeClient = new LineageExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.stewardshipExchangeClient = new StewardshipExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
        this.validValuesExchangeClient = new ValidValuesExchangeClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize, this.auditLog);
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof CatalogIntegratorConnector) {
            CatalogIntegratorConnector serviceSpecificConnector = (CatalogIntegratorConnector)integrationConnector;
            this.auditLog.logMessage("setContext", CatalogIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            AssetManagerEventClient eventClient = new AssetManagerEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.maxPageSize, this.auditLog, connectorId);
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, DeployedImplementationType.ASSET_CATALOG.getAssociatedTypeName(), DeployedImplementationType.ASSET_CATALOG.getAssociatedClassification(), DeployedImplementationType.ASSET_CATALOG.getDeployedImplementationType());
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            CatalogIntegratorContext integratorContext = new CatalogIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.governanceConfiguration, (OpenMetadataClient)this.openMetadataStoreClient, this.actionControlInterface, this.assetManagerClient, eventClient, this.connectedAssetClient, this.collaborationExchangeClient, this.connectionExchangeClient, this.dataAssetExchangeClient, this.externalReferenceExchangeClient, this.glossaryExchangeClient, this.governanceExchangeClient, this.infrastructureExchangeClient, this.lineageExchangeClient, this.stewardshipExchangeClient, this.validValuesExchangeClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.extractDisabledExchangeServices(this.serviceOptions, connectorName), this.maxPageSize, this.auditLog);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(CatalogIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName(), CatalogIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }

    private List<String> extractDisabledExchangeServices(Map<String, Object> serviceOptions, String connectorName) throws InvalidParameterException {
        String methodName = "extractDisabledExchangeServices";
        if (serviceOptions == null) {
            return null;
        }
        Object serviceListObject = serviceOptions.get(disabledExchangeServicesOption);
        if (serviceListObject == null) {
            return null;
        }
        try {
            List serviceList = (List)serviceListObject;
            this.auditLog.logMessage("extractDisabledExchangeServices", CatalogIntegratorAuditCode.DISABLED_EXCHANGE_SERVICES.getMessageDefinition(new String[]{connectorName, serviceList.toString()}));
            return serviceList;
        }
        catch (Exception error) {
            String parameterName = "serviceOptions";
            throw new InvalidParameterException(CatalogIntegratorErrorCode.BAD_CONFIG_PROPERTIES.getMessageDefinition(new String[]{IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName(), serviceListObject.toString(), disabledExchangeServicesOption, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "extractDisabledExchangeServices", "serviceOptions");
        }
    }
}

