/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.catalog.rest;

import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceRegistry;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.server.IntegrationDaemonInstanceHandler;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorOMISConnector;
import org.odpi.openmetadata.integrationservices.catalog.contextmanager.CatalogIntegratorContextManager;
import org.slf4j.LoggerFactory;

public class CatalogIntegratorRESTServices {
    private static final IntegrationDaemonInstanceHandler instanceHandler = new IntegrationDaemonInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(CatalogIntegratorRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public CatalogIntegratorRESTServices() {
        IntegrationServiceRegistry.registerIntegrationService((IntegrationServiceDescription)IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS, (String)CatalogIntegratorContextManager.class.getName(), (String)CatalogIntegratorOMISConnector.class.getName());
    }

    public ConnectorReportResponse validateConnector(String serverName, String userId, String connectorProviderClassName) {
        String methodName = "validateConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateConnector");
        ConnectorReportResponse response = new ConnectorReportResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateConnector");
            ConnectorReport connectorReport = instanceHandler.validateConnector(connectorProviderClassName, CatalogIntegratorConnector.class, IntegrationServiceDescription.CATALOG_INTEGRATOR_OMIS.getIntegrationServiceFullName());
            if (connectorReport != null) {
                response.setConnectorReport(connectorReport);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

