/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.classificationmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.client.management.CollaborationManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.GlossaryManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.StewardshipManagementClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class ClassificationManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.CLASSIFICATION_MANAGER;
    private final CollaborationManagementClient collaborationManagementClient;
    private final GlossaryManagementClient glossaryManagementClient;
    private final StewardshipManagementClient stewardshipManagementClient;

    public ClassificationManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.collaborationManagementClient = new CollaborationManagementClient(remoteServerName, remoteServerURL, auditLog, maxPageSize);
        this.glossaryManagementClient = new GlossaryManagementClient(remoteServerName, remoteServerURL, auditLog, maxPageSize);
        this.stewardshipManagementClient = new StewardshipManagementClient(remoteServerName, remoteServerURL, auditLog, maxPageSize);
    }

    public CollaborationManagementClient getCollaborationManagementClient() {
        return this.collaborationManagementClient;
    }

    public GlossaryManagementClient getGlossaryManagementClient() {
        return this.glossaryManagementClient;
    }

    public StewardshipManagementClient getStewardshipManagementClient() {
        return this.stewardshipManagementClient;
    }
}

