/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.classificationmanager.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.StewardshipManagementClient;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeaderResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataElementSummaryResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataRelationshipSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedMetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindPropertyNamesProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.OwnerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.RetentionClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SemanticAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityTagsProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.server.ClassificationManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class ClassificationManagerRESTServices
extends TokenController {
    private static final ClassificationManagerInstanceHandler instanceHandler = new ClassificationManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ClassificationManagerRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setConfidenceClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidenceClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setConfidenceClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidenceClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setConfidenceClassification");
                    handler.setConfidenceClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidenceClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidenceClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidenceClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearConfidenceClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearConfidenceClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidenceClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearConfidenceClassification");
            if (requestBody != null) {
                handler.clearConfidenceClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearConfidenceClassification(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setCriticalityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setCriticalityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setCriticalityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setCriticalityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setCriticalityClassification");
                    handler.setCriticalityClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setCriticalityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setCriticalityClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCriticalityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearCriticalityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearCriticalityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCriticalityClassification");
            if (requestBody != null) {
                StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearCriticalityClassification");
                handler.clearCriticalityClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearCriticalityClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConfidentialityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidentialityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setConfidentialityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidentialityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setConfidentialityClassification");
                    handler.setConfidentialityClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidentialityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidentialityClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidentialityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearConfidentialityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearConfidentialityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidentialityClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearConfidentialityClassification");
            if (requestBody != null) {
                handler.clearConfidentialityClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearConfidentialityClassification(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRetentionClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setRetentionClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setRetentionClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setRetentionClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof RetentionClassificationProperties) {
                    RetentionClassificationProperties properties = (RetentionClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setRetentionClassification");
                    handler.setRetentionClassification(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(RetentionClassificationProperties.class.getName(), "setRetentionClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setRetentionClassification", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearRetentionClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearRetentionClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearRetentionClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearRetentionClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearRetentionClassification");
            if (requestBody != null) {
                handler.clearRetentionClassification(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearRetentionClassification(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addSecurityTags");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SecurityTagsProperties) {
                    SecurityTagsProperties properties = (SecurityTagsProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addSecurityTags");
                    handler.addSecurityTags(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SecurityTagsProperties.class.getName(), "addSecurityTags");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSecurityTags(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearSecurityTags");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSecurityTags");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearSecurityTags");
            if (requestBody != null) {
                handler.clearSecurityTags(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearSecurityTags(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOwnership(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addOwnership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addOwnership");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addOwnership");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof OwnerProperties) {
                    OwnerProperties properties = (OwnerProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addOwnership");
                    handler.addOwnership(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(OwnerProperties.class.getName(), "addOwnership");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addOwnership", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearOwnership(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearOwnership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearOwnership");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearOwnership");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearOwnership");
            if (requestBody != null) {
                handler.clearOwnership(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearOwnership(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addElementToSubjectArea(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addElementToSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addElementToSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addElementToSubjectArea");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addElementToSubjectArea");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SubjectAreaClassificationProperties) {
                    SubjectAreaClassificationProperties properties = (SubjectAreaClassificationProperties)classificationProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addElementToSubjectArea");
                    handler.addElementToSubjectArea(userId, elementGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaClassificationProperties.class.getName(), "addElementToSubjectArea");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addElementToSubjectArea", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addElementToSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeElementFromSubjectArea(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "removeElementFromSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeElementFromSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeElementFromSubjectArea");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementFromSubjectArea");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "removeElementFromSubjectArea");
            if (requestBody == null) {
                handler.removeElementFromSubjectArea(userId, elementGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.removeElementFromSubjectArea(userId, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeElementFromSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSemanticAssignment(String serverName, String elementGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupSemanticAssignment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSemanticAssignment");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof SemanticAssignmentProperties) {
                    SemanticAssignmentProperties properties = (SemanticAssignmentProperties)relationshipProperties;
                    StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "setupSemanticAssignment");
                    handler.setupSemanticAssignment(userId, elementGUID, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SemanticAssignmentProperties.class.getName(), "setupSemanticAssignment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupSemanticAssignment", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSemanticAssignment(String serverName, String elementGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearSemanticAssignment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSemanticAssignment");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "clearSemanticAssignment");
            if (requestBody == null) {
                handler.clearSemanticAssignment(userId, elementGUID, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.clearSemanticAssignment(userId, elementGUID, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addGovernanceDefinitionToElement(String serverName, String definitionGUID, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "addGovernanceDefinitionToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addGovernanceDefinitionToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addGovernanceDefinitionToElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addGovernanceDefinitionToElement");
            if (requestBody != null) {
                StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "addGovernanceDefinitionToElement");
                handler.addGovernanceDefinitionToElement(userId, definitionGUID, elementGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addGovernanceDefinitionToElement", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addGovernanceDefinitionToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceDefinitionFromElement(String serverName, String definitionGUID, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeGovernanceDefinitionFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGovernanceDefinitionFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGovernanceDefinitionFromElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceDefinitionFromElement");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "removeGovernanceDefinitionFromElement");
            if (requestBody == null) {
                handler.removeGovernanceDefinitionFromElement(userId, elementGUID, definitionGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.removeGovernanceDefinitionFromElement(userId, elementGUID, definitionGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeGovernanceDefinitionFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummaryResponse getMetadataElementByGUID(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementByGUID");
        MetadataElementSummaryResponse response = new MetadataElementSummaryResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMetadataElementByGUID");
            if (requestBody == null) {
                response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, new Date()));
            } else {
                response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummaryResponse getMetadataElementByUniqueName(String serverName, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getMetadataElementByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementByUniqueName");
        MetadataElementSummaryResponse response = new MetadataElementSummaryResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementByUniqueName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByUniqueName");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMetadataElementByUniqueName");
            if (requestBody == null) {
                restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementByUniqueName", serverName);
            } else if (requestBody.getNamePropertyName() == null) {
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), OpenMetadataProperty.QUALIFIED_NAME.name, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getMetadataElementByUniqueName(userId, requestBody.getName(), requestBody.getNamePropertyName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataElementGUIDByUniqueName(String serverName, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getMetadataElementGUIDByUniqueName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementGUIDByUniqueName");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementGUIDByUniqueName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementGUIDByUniqueName");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMetadataElementGUIDByUniqueName");
            if (requestBody == null) {
                restExceptionHandler.handleNoRequestBody(userId, "getMetadataElementGUIDByUniqueName", serverName);
            } else if (requestBody.getNamePropertyName() == null) {
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), OpenMetadataProperty.QUALIFIED_NAME.name, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            } else {
                response.setGUID(handler.getMetadataElementGUIDByUniqueName(userId, requestBody.getName(), requestBody.getNamePropertyName(), forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementGUIDByUniqueName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindProperties requestBody) {
        String methodName = "getElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getElements");
            response.setElements(handler.getElements(userId, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getElementsByPropertyValue(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "getElementsByPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementsByPropertyValue");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementsByPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getElementsByPropertyValue");
            response.setElements(handler.getElementsByPropertyValue(userId, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse findElementsByPropertyValue(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "findElementsByPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findElementsByPropertyValue");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findElementsByPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findElementsByPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "findElementsByPropertyValue");
            response.setElements(handler.findElementsByPropertyValue(userId, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findElementsByPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getElementsByClassification(String serverName, String classificationName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindProperties requestBody) {
        String methodName = "getElementsByClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementsByClassification");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementsByClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByClassification");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getElementsByClassification");
            response.setElements(handler.getElementsByClassification(userId, classificationName, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getElementsByClassificationWithPropertyValue(String serverName, String classificationName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "getElementsByClassificationWithPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementsByClassificationWithPropertyValue");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementsByClassificationWithPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByClassificationWithPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getElementsByClassificationWithPropertyValue");
            response.setElements(handler.getElementsByClassificationWithPropertyValue(userId, classificationName, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByClassificationWithPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse findElementsByClassificationWithPropertyValue(String serverName, String classificationName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "findElementsByClassificationWithPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findElementsByClassificationWithPropertyValue");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findElementsByClassificationWithPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findElementsByClassificationWithPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "findElementsByClassificationWithPropertyValue");
            response.setElements(handler.findElementsByClassificationWithPropertyValue(userId, classificationName, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findElementsByClassificationWithPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse getRelatedElements(String serverName, String elementGUID, String relationshipTypeName, int startingAtEnd, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindProperties requestBody) {
        String methodName = "getRelatedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelatedElements");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelatedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getRelatedElements");
            response.setElements(handler.getRelatedElements(userId, elementGUID, relationshipTypeName, startingAtEnd, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse getRelatedElementsWithPropertyValue(String serverName, String elementGUID, String relationshipTypeName, int startingAtEnd, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "getRelatedElementsWithPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelatedElementsWithPropertyValue");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelatedElementsWithPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedElementsWithPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getRelatedElementsWithPropertyValue");
            response.setElements(handler.getRelatedElementsWithPropertyValue(userId, elementGUID, relationshipTypeName, startingAtEnd, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedElementsWithPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse findRelatedElementsWithPropertyValue(String serverName, String elementGUID, String relationshipTypeName, int startingAtEnd, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "findRelatedElementsWithPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findRelatedElementsWithPropertyValue");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findRelatedElementsWithPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelatedElementsWithPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "findRelatedElementsWithPropertyValue");
            response.setElements(handler.findRelatedElementsWithPropertyValue(userId, elementGUID, relationshipTypeName, startingAtEnd, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findRelatedElementsWithPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataRelationshipSummariesResponse getRelationships(String serverName, String relationshipTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindProperties requestBody) {
        String methodName = "getRelatedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelatedElements");
        MetadataRelationshipSummariesResponse response = new MetadataRelationshipSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelatedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getRelatedElements");
            response.setRelationships(handler.getRelationships(userId, relationshipTypeName, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataRelationshipSummariesResponse getRelationshipsWithPropertyValue(String serverName, String relationshipTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "getRelationshipsWithPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelationshipsWithPropertyValue");
        MetadataRelationshipSummariesResponse response = new MetadataRelationshipSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelationshipsWithPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationshipsWithPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getRelationshipsWithPropertyValue");
            response.setRelationships(handler.getRelationshipsWithPropertyValue(userId, relationshipTypeName, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelationshipsWithPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataRelationshipSummariesResponse findRelationshipsWithPropertyValue(String serverName, String relationshipTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindPropertyNamesProperties requestBody) {
        String methodName = "findRelationshipsWithPropertyValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findRelationshipsWithPropertyValue");
        MetadataRelationshipSummariesResponse response = new MetadataRelationshipSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findRelationshipsWithPropertyValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationshipsWithPropertyValue");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "findRelationshipsWithPropertyValue");
            response.setRelationships(handler.findRelationshipsWithPropertyValue(userId, relationshipTypeName, requestBody, startFrom, pageSize, forLineage, forDuplicateProcessing));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findRelationshipsWithPropertyValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementHeaderResponse retrieveInstanceForGUID(String serverName, String guid, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "retrieveInstanceForGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "retrieveInstanceForGUID");
        ElementHeaderResponse response = new ElementHeaderResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "retrieveInstanceForGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "retrieveInstanceForGUID");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "retrieveInstanceForGUID");
            if (requestBody == null) {
                response.setElement(handler.retrieveInstanceForGUID(userId, guid, forLineage, forDuplicateProcessing, null));
            } else {
                response.setElement(handler.retrieveInstanceForGUID(userId, guid, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "retrieveInstanceForGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

