/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.classificationmanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.StewardshipExchangeClient;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.OwnerProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.RetentionClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SemanticAssignmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.SubjectAreaClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityTagsProperties;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.server.ClassificationManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class ClassificationManagerRESTServices
extends TokenController {
    private static final ClassificationManagerInstanceHandler instanceHandler = new ClassificationManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(ClassificationManagerRESTServices.class), instanceHandler.getServiceName());

    public VoidResponse setConfidenceClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidenceClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setConfidenceClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidenceClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "setConfidenceClassification");
                    handler.setConfidenceClassification(userId, null, null, elementGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidenceClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidenceClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidenceClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearConfidenceClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearConfidenceClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearConfidenceClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidenceClassification");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearConfidenceClassification");
            if (requestBody != null) {
                handler.clearConfidenceClassification(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearConfidenceClassification(userId, null, null, elementGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearConfidenceClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setCriticalityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setCriticalityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setCriticalityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setCriticalityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "setCriticalityClassification");
                    handler.setCriticalityClassification(userId, elementGUID, null, null, properties, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setCriticalityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setCriticalityClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCriticalityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearCriticalityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearCriticalityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearCriticalityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCriticalityClassification");
            if (requestBody != null) {
                StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearCriticalityClassification");
                handler.clearCriticalityClassification(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "clearCriticalityClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearCriticalityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setConfidentialityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setConfidentialityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setConfidentialityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setConfidentialityClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GovernanceClassificationProperties) {
                    GovernanceClassificationProperties properties = (GovernanceClassificationProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "setConfidentialityClassification");
                    handler.setConfidentialityClassification(userId, null, null, elementGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GovernanceClassificationProperties.class.getName(), "setConfidentialityClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setConfidentialityClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearConfidentialityClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearConfidentialityClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearConfidentialityClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearConfidentialityClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearConfidentialityClassification");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearConfidentialityClassification");
            if (requestBody != null) {
                handler.clearConfidentialityClassification(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearConfidentialityClassification(userId, null, null, elementGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearConfidentialityClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setRetentionClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setRetentionClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setRetentionClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setRetentionClassification");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof RetentionClassificationProperties) {
                    RetentionClassificationProperties properties = (RetentionClassificationProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "setRetentionClassification");
                    handler.setRetentionClassification(userId, null, null, elementGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(RetentionClassificationProperties.class.getName(), "setRetentionClassification");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setRetentionClassification", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearRetentionClassification(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ResultsRequestBody requestBody) {
        String methodName = "clearRetentionClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearRetentionClassification");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearRetentionClassification");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearRetentionClassification");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearRetentionClassification");
            if (requestBody != null) {
                handler.clearRetentionClassification(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearRetentionClassification(userId, null, null, elementGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearRetentionClassification", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addSecurityTags(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addSecurityTags");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addSecurityTags");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SecurityTagsProperties) {
                    SecurityTagsProperties properties = (SecurityTagsProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "addSecurityTags");
                    handler.addSecurityTags(userId, null, null, elementGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SecurityTagsProperties.class.getName(), "addSecurityTags");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addSecurityTags", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSecurityTags(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearSecurityTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearSecurityTags");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearSecurityTags");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSecurityTags");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearSecurityTags");
            if (requestBody != null) {
                handler.clearSecurityTags(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearSecurityTags(userId, null, null, elementGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSecurityTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOwnership(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addOwnership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addOwnership");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addOwnership");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof OwnerProperties) {
                    OwnerProperties properties = (OwnerProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "addOwnership");
                    handler.addOwnership(userId, null, null, elementGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(OwnerProperties.class.getName(), "addOwnership");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addOwnership", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearOwnership(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearOwnership";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearOwnership");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearOwnership");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearOwnership");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearOwnership");
            if (requestBody != null) {
                handler.clearOwnership(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearOwnership(userId, null, null, elementGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearOwnership", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addElementToSubjectArea(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "addElementToSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addElementToSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addElementToSubjectArea");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addElementToSubjectArea");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof SubjectAreaClassificationProperties) {
                    SubjectAreaClassificationProperties properties = (SubjectAreaClassificationProperties)classificationProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "addElementToSubjectArea");
                    handler.addElementToSubjectArea(userId, null, null, elementGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SubjectAreaClassificationProperties.class.getName(), "addElementToSubjectArea");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addElementToSubjectArea", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addElementToSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeElementFromSubjectArea(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "removeElementFromSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeElementFromSubjectArea");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeElementFromSubjectArea");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementFromSubjectArea");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "removeElementFromSubjectArea");
            if (requestBody == null) {
                handler.removeElementFromSubjectArea(userId, null, null, elementGUID, null, null, forLineage, forDuplicateProcessing);
            } else {
                handler.removeElementFromSubjectArea(userId, null, null, elementGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeElementFromSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupSemanticAssignment(String serverName, String elementGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupSemanticAssignment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupSemanticAssignment");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof SemanticAssignmentProperties) {
                    SemanticAssignmentProperties properties = (SemanticAssignmentProperties)relationshipProperties;
                    StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "setupSemanticAssignment");
                    handler.setupSemanticAssignment(userId, null, null, elementGUID, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(SemanticAssignmentProperties.class.getName(), "setupSemanticAssignment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupSemanticAssignment", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearSemanticAssignment(String serverName, String elementGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearSemanticAssignment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearSemanticAssignment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearSemanticAssignment");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearSemanticAssignment");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "clearSemanticAssignment");
            if (requestBody == null) {
                handler.clearSemanticAssignment(userId, null, null, elementGUID, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.clearSemanticAssignment(userId, null, null, elementGUID, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearSemanticAssignment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addGovernanceDefinitionToElement(String serverName, String definitionGUID, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "addGovernanceDefinitionToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addGovernanceDefinitionToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addGovernanceDefinitionToElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addGovernanceDefinitionToElement");
            if (requestBody != null) {
                StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "addGovernanceDefinitionToElement");
                handler.addGovernanceDefinitionToElement(userId, definitionGUID, elementGUID, null, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addGovernanceDefinitionToElement", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addGovernanceDefinitionToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGovernanceDefinitionFromElement(String serverName, String definitionGUID, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "removeGovernanceDefinitionFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGovernanceDefinitionFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGovernanceDefinitionFromElement");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGovernanceDefinitionFromElement");
            StewardshipExchangeClient handler = instanceHandler.getStewardshipExchangeClient(userId, serverName, "removeGovernanceDefinitionFromElement");
            if (requestBody == null) {
                handler.removeGovernanceDefinitionFromElement(userId, null, null, elementGUID, definitionGUID, null, forLineage, forDuplicateProcessing);
            } else {
                handler.removeGovernanceDefinitionFromElement(userId, null, null, elementGUID, definitionGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeGovernanceDefinitionFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

