/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.classificationmanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementHeaderResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataElementSummaryResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataRelationshipSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedMetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindPropertyNamesProperties;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.classificationmanager.server.ClassificationManagerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/classification-manager"})
@Tag(name="API: Classification Manager OMVS", description="The Classification Manager OMVS enables the caller to maintain classifications and governance relationships attached to open metadata elements.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/classification-manager/overview/"))
public class ClassificationManagerResource {
    private final ClassificationManagerRESTServices restAPI = new ClassificationManagerRESTServices();

    @PostMapping(path={"/elements/{elementGUID}/confidence"})
    @Operation(summary="setConfidenceClassification", description="Classify/reclassify the element (typically an asset) to indicate the level of confidence that the organization has that the data is complete, accurate and up-to-date.  The level of confidence is expressed by the levelIdentifier property.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse setConfidenceClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setConfidenceClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidence/remove"})
    @Operation(summary="clearConfidenceClassification", description="Remove the confidence classification from the element.  This normally occurs when the organization has lost track of the level of confidence to assign to the element.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse clearConfidenceClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.clearConfidenceClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/criticality"})
    @Operation(summary="setCriticalityClassification", description="Classify/reclassify the element (typically an asset) to indicate how critical the element (or associated resource) is to the organization.  The level of criticality is expressed by the levelIdentifier property.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse setCriticalityClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setCriticalityClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/criticality/remove"})
    @Operation(summary="clearCriticalityClassification", description="Remove the criticality classification from the element.  This normally occurs when the organization has lost track of the level of criticality to assign to the element.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse clearCriticalityClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.clearCriticalityClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidentiality"})
    @Operation(summary="setConfidentialityClassification", description="Classify/reclassify the element (typically a data field, schema attribute or glossary term) to indicate the level of confidentiality that any data associated with the element should be given.  If the classification is attached to a glossary term, the level of confidentiality is a suggestion for any element linked to the glossary term via the SemanticAssignment classification. The level of confidence is expressed by the levelIdentifier property.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse setConfidentialityClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setConfidentialityClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/confidentiality/remove"})
    @Operation(summary="clearConfidentialityClassification", description="Remove the confidence classification from the element.  This normally occurs when the organization has lost track of the level of confidentiality to assign to the element.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse clearConfidentialityClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.clearConfidentialityClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/retention"})
    @Operation(summary="setRetentionClassification", description="Classify/reclassify the element (typically an asset) to indicate how long the element (or associated resource) is to be retained by the organization.  The policy to apply to the element/resource is captured by the retentionBasis property.  The dates after which the element/resource is archived and then deleted are specified in the archiveAfter and deleteAfter properties respectively.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse setRetentionClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setRetentionClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/retention/remove"})
    @Operation(summary="clearRetentionClassification", description="Remove the retention classification from the element.  This normally occurs when the organization has lost track of, or no longer needs to track the retention period to assign to the element.", externalDocs=@ExternalDocumentation(description="Governance Action Classifications", url="https://egeria-project.org/types/4/0422-Governance-Action-Classifications/"))
    public VoidResponse clearRetentionClassification(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.clearRetentionClassification(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/security-tags"})
    @Operation(summary="addSecurityTags", description="Add or replace the security tags for an element.", externalDocs=@ExternalDocumentation(description="Security Tags", url="https://egeria-project.org/types/4/0423-Security-Definitions/"))
    public VoidResponse addSecurityTags(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addSecurityTags(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/security-tags/remove"})
    @Operation(summary="clearSecurityTags", description="Clear the security tags for an element.", externalDocs=@ExternalDocumentation(description="Security Tags", url="https://egeria-project.org/types/4/0423-Security-Definitions/"))
    public VoidResponse clearSecurityTags(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearSecurityTags(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ownership"})
    @Operation(summary="addOwnership", description="Add or replace the ownership classification for an element.", externalDocs=@ExternalDocumentation(description="Ownership", url="https://egeria-project.org/types/4/0445-Governance-Roles/"))
    public VoidResponse addOwnership(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addOwnership(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ownership/remove"})
    @Operation(summary="clearOwnership", description="Add or replace the ownership classification for an element.", externalDocs=@ExternalDocumentation(description="Ownership", url="https://egeria-project.org/types/4/0445-Governance-Roles/"))
    public VoidResponse clearOwnership(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearOwnership(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/subject-area-member"})
    @Operation(summary="addElementToSubjectArea", description="Classify the element to assert that the definitions it represents are part of a subject area definition.", externalDocs=@ExternalDocumentation(description="Subject Areas", url="https://egeria-project.org/types/4/0425-Subject-Areas/"))
    public VoidResponse addElementToSubjectArea(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.addElementToSubjectArea(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/subject-area-member/remove"})
    @Operation(summary="removeElementFromSubjectArea", description="Remove the subject area designation from the identified element.", externalDocs=@ExternalDocumentation(description="Subject Areas", url="https://egeria-project.org/types/4/0425-Subject-Areas/"))
    public VoidResponse removeElementFromSubjectArea(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.removeElementFromSubjectArea(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/semantic-assignment/terms/{glossaryTermGUID}"})
    @Operation(summary="setupSemanticAssignment", description="Create a semantic assignment relationship between a glossary term and an element (normally a schema attribute, data field or asset). This relationship indicates that the data associated with the element meaning matches the description in the glossary term.", externalDocs=@ExternalDocumentation(description="Semantic Assignments", url="https://egeria-project.org/types/3/0370-Semantic-Assignment/"))
    public VoidResponse setupSemanticAssignment(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupSemanticAssignment(serverName, elementGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/semantic-assignment/terms/{glossaryTermGUID}/remove"})
    @Operation(summary="clearSemanticAssignment", description="Remove a semantic assignment relationship between an element and its glossary term.", externalDocs=@ExternalDocumentation(description="Semantic Assignments", url="https://egeria-project.org/types/3/0370-Semantic-Assignment/"))
    public VoidResponse clearSemanticAssignment(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearSemanticAssignment(serverName, elementGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by/definition/{definitionGUID}"})
    @Operation(summary="addGovernanceDefinitionToElement", description="Link a governance definition to an element using the GovernedBy relationship.", externalDocs=@ExternalDocumentation(description="Governance Definitions", url="https://egeria-project.org/types/4/0401-Governance-Definitions/"))
    public VoidResponse addGovernanceDefinitionToElement(@PathVariable String serverName, @PathVariable String definitionGUID, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.addGovernanceDefinitionToElement(serverName, definitionGUID, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by/definition/{definitionGUID}/remove"})
    @Operation(summary="removeGovernanceDefinitionFromElement", description="Remove the GovernedBy relationship between a governance definition and an element.", externalDocs=@ExternalDocumentation(description="Governance Definitions", url="https://egeria-project.org/types/4/0401-Governance-Definitions/"))
    public VoidResponse removeGovernanceDefinitionFromElement(@PathVariable String serverName, @PathVariable String definitionGUID, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.removeGovernanceDefinitionFromElement(serverName, definitionGUID, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}"})
    @Operation(summary="getMetadataElementByGUID", description="Retrieve the metadata element using its unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
    public MetadataElementSummaryResponse getMetadataElementByGUID(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getMetadataElementByGUID(serverName, elementGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-unique-name"})
    @Operation(summary="getMetadataElementByUniqueName", description="Retrieve the metadata element using its unique name (typically the qualified name, but it is possible to specify a different property name in the request body as long as it is unique).  If multiple matching instances are found, and exception is thrown.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
    public MetadataElementSummaryResponse getMetadataElementByUniqueName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementByUniqueName(serverName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/guid-by-unique-name"})
    @Operation(summary="getMetadataElementGUIDByUniqueName", description="Retrieve the metadata element GUID using its unique name (typically the qualified name, but it is possible to specify a different property name in the request body as long as it is unique).  If multiple matching instances are found, and exception is thrown.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/gaf-metadata-management/"))
    public GUIDResponse getMetadataElementGUIDByUniqueName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.getMetadataElementGUIDByUniqueName(serverName, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-type"})
    @Operation(summary="getElements", description="Retrieve elements of the requested type name.  If no type name is specified then any type of element may be returned.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataElementSummariesResponse getElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindProperties requestBody) {
        return this.restAPI.getElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-exact-property-value"})
    @Operation(summary="getElementsByPropertyValue", description="Retrieve elements by a value found in one of the properties specified.  The value must match exactly. An open metadata type name may be supplied to restrict the results.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataElementSummariesResponse getElementsByPropertyValue(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.getElementsByPropertyValue(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-property-value-search"})
    @Operation(summary="findElementsByPropertyValue", description="Retrieve elements by a value found in one of the properties specified.  The value must only be contained in the properties rather than needing to be an exact match.  An open metadata type name may be supplied to restrict the results.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataElementSummariesResponse findElementsByPropertyValue(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.findElementsByPropertyValue(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-classification/{classificationName}"})
    @Operation(summary="getElementsByClassification", description="Retrieve elements with the requested classification name. It is also possible to limit the results by specifying a type name for the elements that should be returned. If no type name is specified then any type of element may be returned.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataElementSummariesResponse getElementsByClassification(@PathVariable String serverName, @PathVariable String classificationName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindProperties requestBody) {
        return this.restAPI.getElementsByClassification(serverName, classificationName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-classification/{classificationName}/with-exact-property-value"})
    @Operation(summary="getElementsByClassificationWithPropertyValue", description="Retrieve elements with the requested classification name and with the requested a value found in one of the classification's properties specified.  The value must match exactly. An open metadata type name may be supplied to restrict the types of elements returned.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataElementSummariesResponse getElementsByClassificationWithPropertyValue(@PathVariable String serverName, @PathVariable String classificationName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.getElementsByClassificationWithPropertyValue(serverName, classificationName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-classification/{classificationName}/with-property-value-search"})
    @Operation(summary="findElementsByClassificationWithPropertyValue", description="Retrieve elements with the requested classification name and with the requested a value found in one of the classification's properties specified.  The value must only be contained in the properties rather than needing to be an exact match.  An open metadata type name may be supplied to restrict the results.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataElementSummariesResponse findElementsByClassificationWithPropertyValue(@PathVariable String serverName, @PathVariable String classificationName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.findElementsByClassificationWithPropertyValue(serverName, classificationName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/by-relationship"})
    @Operation(summary="getRelatedElements", description="Retrieve elements linked via the requested relationship type name. It is also possible to limit the results by specifying a type name for the elements that should be returned. If no type name is specified then any type of element may be returned.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public RelatedMetadataElementSummariesResponse getRelatedElements(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startingAtEnd, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindProperties requestBody) {
        return this.restAPI.getRelatedElements(serverName, elementGUID, null, startingAtEnd, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/by-relationship/{relationshipTypeName}"})
    @Operation(summary="getRelatedElements", description="Retrieve elements linked via the requested relationship type name. It is also possible to limit the results by specifying a type name for the elements that should be returned. If no type name is specified then any type of element may be returned.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public RelatedMetadataElementSummariesResponse getRelatedElements(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @RequestParam(required=false, defaultValue="0") int startingAtEnd, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindProperties requestBody) {
        return this.restAPI.getRelatedElements(serverName, elementGUID, relationshipTypeName, startingAtEnd, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/by-relationship/{relationshipTypeName}/with-exact-property-value"})
    @Operation(summary="getRelatedElementsWithPropertyValue", description="Retrieve elements linked via the requested relationship type name and with the requested a value found in one of the relationship's properties specified.  The value must match exactly. An open metadata type name may be supplied to restrict the types of elements returned.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public RelatedMetadataElementSummariesResponse getRelatedElementsWithPropertyValue(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @RequestParam(required=false, defaultValue="0") int startingAtEnd, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.getRelatedElementsWithPropertyValue(serverName, elementGUID, relationshipTypeName, startingAtEnd, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/by-relationship/{relationshipTypeName}/with-property-value-search"})
    @Operation(summary="findRelatedElementsWithPropertyValue", description="Retrieve elements linked via the requested relationship type name and with the requested value found in one of the relationship's properties specified.  The value must only be contained in the properties rather than needing to be an exact match.  An open metadata type name may be supplied to restrict the results.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public RelatedMetadataElementSummariesResponse findRelatedElementsWithPropertyValue(@PathVariable String serverName, @PathVariable String elementGUID, @PathVariable String relationshipTypeName, @RequestParam(required=false, defaultValue="0") int startingAtEnd, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.findRelatedElementsWithPropertyValue(serverName, elementGUID, relationshipTypeName, startingAtEnd, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/relationships/{relationshipTypeName}"})
    @Operation(summary="getRelationships", description="Retrieve relationships of the requested relationship type name.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataRelationshipSummariesResponse getRelationships(@PathVariable String serverName, @PathVariable String relationshipTypeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindProperties requestBody) {
        return this.restAPI.getRelationships(serverName, relationshipTypeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/relationships/{relationshipTypeName}/with-exact-property-value"})
    @Operation(summary="getRelationshipsWithPropertyValue", description="Retrieve relationships of the requested relationship type name and with the requested a value found in one of the relationship's properties specified.  The value must match exactly.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataRelationshipSummariesResponse getRelationshipsWithPropertyValue(@PathVariable String serverName, @PathVariable String relationshipTypeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.getRelationshipsWithPropertyValue(serverName, relationshipTypeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/relationships/{relationshipTypeName}/with-property-value-search"})
    @Operation(summary="findRelationshipsWithPropertyValue", description="Retrieve relationships of the requested relationship type name and with the requested a value found in one of the relationship's properties specified.  The value must only be contained in the properties rather than needing to be an exact match.", externalDocs=@ExternalDocumentation(description="Open Metadata Types", url="https://egeria-project.org/types/"))
    public MetadataRelationshipSummariesResponse findRelationshipsWithPropertyValue(@PathVariable String serverName, @PathVariable String relationshipTypeName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindPropertyNamesProperties requestBody) {
        return this.restAPI.findRelationshipsWithPropertyValue(serverName, relationshipTypeName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/guids/{guid}"})
    @Operation(summary="retrieveInstanceForGUID", description="Retrieve the header for the instance identified by the supplied unique identifier.  It may be an element (entity) or a relationship between elements.", externalDocs=@ExternalDocumentation(description="Unique Identifiers (GUID)", url="https://egeria-project.org/concepts/guid/"))
    public ElementHeaderResponse retrieveInstanceForGUID(@PathVariable String serverName, @PathVariable String guid, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.retrieveInstanceForGUID(serverName, guid, forLineage, forDuplicateProcessing, requestBody);
    }
}

