/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel;

import com.github.jsonldjava.utils.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Attribute;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Concept;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.ConceptGroup;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Link;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.LinkChoice;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Model;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.PropertyDescription;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.PropertyGroup;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.SubjectArea;

class CloudInformationModelParser {
    private static final String AT_GRAPH_TAG = "@graph";
    private static final String AT_ID_TAG = "@id";
    private static final String AT_TYPE_TAG = "@type";
    private static final String NAME_TAG = "name";
    private static final String ENTITY_GROUPS_TAG = "entityGroups";
    private static final String DESCRIPTION_TAG = "description";
    private static final String CLASS_CONCEPTS_TAG = "classConcepts";
    private static final String PROPERTY_CONCEPTS_TAG = "propertyConcepts";
    private static final String DOMAIN_TAG = "domain";
    private static final String RANGE_TAG = "range";
    private static final String SCHEMAS_TAG = "schemas";
    private static final String VERSION_TAG = "version";
    private static final String PROPERTIES_TAG = "properties";
    private static final String PATH_TAG = "path";
    private static final String NODE_TAG = "node";
    private static final String XOR_TAG = "xor";
    private static final String MAX_COUNT_TAG = "maxCount";
    private static final String MIN_COUNT_TAG = "minCount";
    private static final String DATA_TYPE_TAG = "datatype";
    private static final String SUB_CLASS_TAG = "subClassOf";
    private static final String ENTITY_GROUP_TYPE = "EntityGroup";
    private static final String PROPERTY_GROUP_TYPE = "PropertyGroup";
    private static final String SHAPE_TYPE = "Shape";
    private static final String SUBJECT_AREA_TYPE = "SubjectArea";
    private static final String SUBJECT_AREA_PROPERTY = "subjectArea";
    private static final String TARGET_CLASS_PROPERTY = "targetClass";
    private static final String DATA_TYPE_RANGE = "DataType";
    private static final String modelName = "Cloud Information Model (CIM)";
    private static final String modelTechnicalName = "CloudInformationModel";
    private static final String modelDescription = "The Cloud Information Model (CIM) is an open source glossary and data model that spans the following subject areas:\n\n\u2022\tParty \u2013 people, their roles and organizations.\n\u2022\tProduct \u2013 product descriptions, structures and packaging.\n\u2022\tSales Order \u2013 customer orders for goods and services.\n\u2022\tPayment Method \u2013 payment methods including cards, coupons and digital wallets.\n\u2022\tPayment \u2013 individual payments for goods and services.\n\u2022\tShipment \u2013 shipment of goods and services to the customer to fulfil an order.\n\nThis means it can provide common data structures for new services spanning customer and employee interaction around typical commercial activities such as buying and selling of goods and services.\n\nThe motivation behind the cloud information model is to support organizations who are transforming their digital services to run on a variety of cloud platforms and with their own data centres.  Often, they are dealing with systems built on many different generations of technology, with data distributed amongst them.  The CIM provides a common language to describe the different types of data.\n\nThe CIM has been created to simplify the growing complexity companies experience when integrating data across different systemsin order to deliver highly intelligent and personalized customer engagements. It standardizes data interoperability by creating a set of guidelines to easily connect systems such as a point of sale system, email marketing platform, customer service center, customer relationship management (CRM) system and more. Developers will no longer need to spend months creating custom code in order to deliver innovative customer experiences. The CIM can be easily adopted and extended within days so that developers can focus on creating new innovations faster that deliver a truly connected, personalized and intelligent customer experience. \n";
    private static final String modelLocation = "https://cloudinformationmodel.org/";
    private static final String modelScope = "People, organizations, accounts and contact details, orders and payments.";
    private static final String modelLanguage = "En_US";
    private final Map<String, SubjectArea> subjectAreaMap = new HashMap<String, SubjectArea>();
    private final Map<String, PropertyGroup> propertyGroupMap = new HashMap<String, PropertyGroup>();
    private final Map<String, ConceptGroup> conceptGroupMap = new HashMap<String, ConceptGroup>();
    private final Map<String, Concept> conceptNameMap = new HashMap<String, Concept>();
    private final Map<String, Concept> conceptGUIDMap = new HashMap<String, Concept>();
    private final Map<String, PropertyDescription> propertyDescriptionMap = new HashMap<String, PropertyDescription>();
    private final List<ConceptGroup> orphanedConceptGroups = new ArrayList<ConceptGroup>();
    private final List<String> errorReport = new ArrayList<String>();

    public CloudInformationModelParser(String cimLocation) {
        try {
            System.out.println("\nModel Name: Cloud Information Model (CIM)");
            File cimContent = new File(cimLocation);
            this.parseSingleFile(cimContent);
            this.reviewConcepts();
            if (!this.conceptNameMap.isEmpty()) {
                for (Concept concept : this.conceptNameMap.values()) {
                    if (concept == null || concept.getDescription() != null && concept.getDisplayName() != null) continue;
                    this.errorReport.add("Missing bead: " + concept.getGUID());
                }
            }
            if (!this.errorReport.isEmpty()) {
                System.out.println("Error Report from parsing Source Model");
                for (String error : this.errorReport) {
                    System.out.println(error);
                }
            }
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    private void parseSingleFile(File cimContentFile) throws IOException {
        List schemasJsonLD;
        String conceptGroupGUID;
        System.out.println("\nRetrieving model contents from: " + cimContentFile.getName());
        LinkedHashMap modelJsonLD = (LinkedHashMap)JsonUtils.fromInputStream((InputStream)new FileInputStream(cimContentFile));
        List graphJsonLD = (List)modelJsonLD.get(AT_GRAPH_TAG);
        ArrayList<Map> propertyGroupsJsonLD = new ArrayList<Map>();
        ArrayList<Map> entityGroupsJsonLD = new ArrayList<Map>();
        ArrayList<Map> subjectAreasJsonLD = new ArrayList<Map>();
        if (graphJsonLD != null) {
            for (Map modelEntryJsonLD : graphJsonLD) {
                String type;
                if (modelEntryJsonLD == null) continue;
                switch (type = modelEntryJsonLD.get(AT_TYPE_TAG).toString()) {
                    case "PropertyGroup": {
                        propertyGroupsJsonLD.add(modelEntryJsonLD);
                        break;
                    }
                    case "EntityGroup": {
                        entityGroupsJsonLD.add(modelEntryJsonLD);
                        break;
                    }
                    case "SubjectArea": {
                        subjectAreasJsonLD.add(modelEntryJsonLD);
                    }
                }
            }
        }
        for (Map propertyGroupJsonLD : propertyGroupsJsonLD) {
            this.getPropertyGroup(propertyGroupJsonLD);
        }
        for (Map subjectAreaJsonLD : subjectAreasJsonLD) {
            if (subjectAreaJsonLD == null) continue;
            SubjectArea subjectArea = new SubjectArea();
            subjectArea.setGUID(this.getStringValue(subjectAreaJsonLD.get(AT_ID_TAG)));
            subjectArea.setTechnicalName(this.getStringValue(subjectAreaJsonLD.get(NAME_TAG)));
            subjectArea.setDisplayName(this.getStringValue(subjectAreaJsonLD.get(NAME_TAG)));
            subjectArea.setDescription(this.getStringValue(subjectAreaJsonLD.get(DESCRIPTION_TAG)));
            subjectArea.setVersion(this.getStringValue(subjectAreaJsonLD.get(VERSION_TAG)));
            System.out.println("Subject area name: " + subjectArea.getDisplayName() + " with id: " + subjectArea.getGUID());
            this.subjectAreaMap.put(subjectArea.getGUID(), subjectArea);
            List entityGroupDefinitionsJsonLD = (List)subjectAreaJsonLD.get(ENTITY_GROUPS_TAG);
            if (entityGroupDefinitionsJsonLD == null) continue;
            for (Map entityGroupDefinitionJsonLD : entityGroupDefinitionsJsonLD) {
                String conceptGroupGUID2 = this.getStringValue(entityGroupDefinitionJsonLD.get(AT_ID_TAG));
                String conceptGroupDisplayName = this.getStringValue(entityGroupDefinitionJsonLD.get(NAME_TAG));
                String conceptGroupDescription = this.getStringValue(entityGroupDefinitionJsonLD.get(DESCRIPTION_TAG));
                ConceptGroup conceptGroup = this.conceptGroupMap.get(conceptGroupGUID2);
                if (conceptGroup == null) {
                    conceptGroup = new ConceptGroup();
                    conceptGroup.setGUID(conceptGroupGUID2);
                    conceptGroup.setDisplayName(conceptGroupDisplayName);
                    conceptGroup.setDescription(conceptGroupDescription);
                    conceptGroup.setSubjectAreaGUID(subjectArea.getGUID());
                    subjectArea.addConceptGroup(conceptGroupGUID2, conceptGroup);
                    this.conceptGroupMap.put(conceptGroupGUID2, conceptGroup);
                    continue;
                }
                System.out.println("ERROR: duplicate entity group: " + conceptGroupDisplayName + " (" + conceptGroupGUID2 + ")");
                this.errorReport.add("ERROR: duplicate entity group: " + conceptGroupDisplayName + " (" + conceptGroupGUID2 + ")");
            }
        }
        for (Map entityGroupJsonLD : entityGroupsJsonLD) {
            conceptGroupGUID = this.getStringValue(entityGroupJsonLD.get(AT_ID_TAG));
            Iterator conceptGroupTechnicalName = this.getStringValue(entityGroupJsonLD.get(NAME_TAG));
            String conceptGroupVersion = this.getStringValue(entityGroupJsonLD.get(VERSION_TAG));
            String conceptGroupDescription = this.getStringValue(entityGroupJsonLD.get(DESCRIPTION_TAG));
            String subjectAreaGUID = this.getStringValue(entityGroupJsonLD.get(SUBJECT_AREA_PROPERTY));
            ConceptGroup conceptGroup = this.conceptGroupMap.get(conceptGroupGUID);
            if (conceptGroup == null) {
                conceptGroup = new ConceptGroup();
                conceptGroup.setGUID(conceptGroupGUID);
                conceptGroup.setDisplayName((String)((Object)conceptGroupTechnicalName));
                conceptGroup.setDescription(conceptGroupDescription);
                conceptGroup.setSubjectAreaGUID(subjectAreaGUID);
            } else {
                String errorText;
                if (!subjectAreaGUID.equals(conceptGroup.getSubjectAreaGUID())) {
                    errorText = "ERROR: inconsistent subject area GUID for: " + conceptGroup.getDisplayName() + " (" + conceptGroup.getDisplayName() + ") - " + subjectAreaGUID + " verses " + conceptGroup.getSubjectAreaGUID();
                    System.out.println(errorText);
                    this.errorReport.add(errorText);
                }
                if (!conceptGroupDescription.equals(conceptGroup.getDescription())) {
                    errorText = "ERROR: inconsistent description for: " + conceptGroup.getDisplayName() + " (" + conceptGroup.getDisplayName() + ") - " + conceptGroupDescription + " verses " + conceptGroup.getDescription();
                    System.out.println(errorText);
                    this.errorReport.add(errorText);
                }
            }
            conceptGroup.setTechnicalName((String)((Object)conceptGroupTechnicalName));
            conceptGroup.setVersion(conceptGroupVersion);
            List classConceptsJsonLD = (List)entityGroupJsonLD.get(CLASS_CONCEPTS_TAG);
            if (classConceptsJsonLD == null) continue;
            for (Map classConceptJsonLD : classConceptsJsonLD) {
                if (classConceptJsonLD == null) continue;
                this.getConceptsForEntityGroup(conceptGroup, classConceptJsonLD);
            }
        }
        for (Map entityGroupJsonLD : entityGroupsJsonLD) {
            schemasJsonLD = (List)entityGroupJsonLD.get(SCHEMAS_TAG);
            if (schemasJsonLD == null) continue;
            for (Map schemaJsonLD : schemasJsonLD) {
                if (schemaJsonLD == null) continue;
                this.getGUIDsForConcepts(schemaJsonLD);
            }
        }
        for (Map entityGroupJsonLD : entityGroupsJsonLD) {
            schemasJsonLD = (List)entityGroupJsonLD.get(SCHEMAS_TAG);
            if (schemasJsonLD == null) continue;
            for (Map schemaJsonLD : schemasJsonLD) {
                if (schemaJsonLD == null) continue;
                this.getPropertiesForConcepts(schemaJsonLD);
            }
        }
        for (Map entityGroupJsonLD : entityGroupsJsonLD) {
            List propertyConceptsJsonLD = (List)entityGroupJsonLD.get(PROPERTY_CONCEPTS_TAG);
            if (propertyConceptsJsonLD == null) continue;
            for (Map propertyConceptJsonLD : propertyConceptsJsonLD) {
                if (propertyConceptJsonLD == null) continue;
                this.validatePropertiesForEntityGroup(propertyConceptJsonLD);
            }
        }
        for (Map entityGroupJsonLD : entityGroupsJsonLD) {
            conceptGroupGUID = this.getStringValue(entityGroupJsonLD.get(AT_ID_TAG));
            ConceptGroup conceptGroup = this.conceptGroupMap.get(conceptGroupGUID);
            SubjectArea subjectArea = null;
            String subjectAreaId = this.getStringValue(entityGroupJsonLD.get(SUBJECT_AREA_PROPERTY));
            if (subjectAreaId != null) {
                subjectArea = this.subjectAreaMap.get(subjectAreaId);
            }
            if (subjectArea != null) continue;
            System.out.println("WARN: Orphaned concept group: " + conceptGroup.getDisplayName());
            this.orphanedConceptGroups.add(conceptGroup);
        }
    }

    private Concept getConcept(String conceptTechnicalName) {
        Concept bead = this.conceptNameMap.get(conceptTechnicalName);
        if (bead == null) {
            bead = new Concept();
            bead.setTechnicalName(conceptTechnicalName);
            this.conceptNameMap.put(conceptTechnicalName, bead);
        }
        return bead;
    }

    private String getStringValue(Object modelElement) {
        if (modelElement == null) {
            return null;
        }
        return modelElement.toString();
    }

    private PropertyDescription getPropertyDescription(String propertyTechnicalName, String rangeTag) {
        PropertyDescription propertyDescription = this.propertyDescriptionMap.get(propertyTechnicalName);
        if (propertyDescription == null) {
            propertyDescription = new PropertyDescription();
            if (DATA_TYPE_RANGE.equals(rangeTag)) {
                propertyDescription.setPrimitive(true);
            } else {
                propertyDescription.setPrimitive(false);
                propertyDescription.setDataTypeId(rangeTag);
            }
            this.propertyDescriptionMap.put(propertyTechnicalName, propertyDescription);
        }
        return propertyDescription;
    }

    private void addProperty(Concept concept, String propertyGUID, String propertyTechnicalName, String dataType, Object node, String maxCount, String minCount) {
        PropertyDescription propertyDescription = this.getPropertyDescription(propertyTechnicalName);
        if (dataType != null) {
            Attribute attribute = new Attribute(propertyGUID, propertyTechnicalName, propertyDescription);
            attribute.setDataType(dataType);
            attribute.setMaxCount(maxCount);
            attribute.setMinCount(minCount);
            concept.setAttribute(propertyTechnicalName, attribute);
        } else if (node != null) {
            String rangeConceptGUID = node.toString();
            Concept rangeConcept = this.conceptGUIDMap.get(rangeConceptGUID);
            if (rangeConcept != null) {
                if (rangeConceptGUID.equals(rangeConcept.getGUID())) {
                    Link link = this.getLink(propertyGUID, propertyTechnicalName, propertyDescription, concept, rangeConcept, maxCount, minCount);
                    concept.setDomainOfLink(propertyTechnicalName, link);
                    rangeConcept.setRangeOfLink(propertyTechnicalName, link);
                }
            } else {
                Map xorMap = (Map)node;
                Map xor = (Map)xorMap.get(XOR_TAG);
                List atList = (List)xor.get("@list");
                if (atList != null) {
                    LinkChoice linkChoice = new LinkChoice(propertyGUID, propertyTechnicalName, propertyDescription);
                    for (Map idMap : atList) {
                        Object nodeIdObject = idMap.get(AT_ID_TAG);
                        String nodeIdChoice = this.getStringValue(nodeIdObject);
                        Concept rangeConceptChoice = this.conceptGUIDMap.get(nodeIdChoice);
                        if (rangeConceptChoice == null || !nodeIdChoice.equals(rangeConceptChoice.getGUID())) continue;
                        Link link = this.getLink(propertyGUID, propertyTechnicalName, propertyDescription, concept, rangeConceptChoice, maxCount, minCount);
                        rangeConceptChoice.setRangeOfLink(propertyTechnicalName, link);
                        linkChoice.addLinkChoice(link);
                    }
                    concept.setDomainOfLink(propertyTechnicalName, linkChoice);
                } else {
                    String errorText = "ERROR: invalid node: " + node + " for property " + propertyTechnicalName + " for concept " + concept.getTechnicalName() + "(" + concept.getGUID() + ")";
                    System.out.println(errorText);
                    this.errorReport.add(errorText);
                }
            }
        } else {
            String errorText = "ERROR: invalid property: " + propertyTechnicalName + " for concept " + concept.getTechnicalName() + "(" + concept.getGUID() + ") with neither data type nor node";
            System.out.println(errorText);
            this.errorReport.add(errorText);
        }
    }

    private Link getLink(String propertyGUID, String propertyTechnicalName, PropertyDescription propertyDescription, Concept domainConcept, Concept rangeConcept, String maxCount, String minCount) {
        Link link = new Link(propertyGUID, propertyTechnicalName, propertyDescription);
        link.setDomainConceptGUID(domainConcept.getGUID());
        link.setDomainConceptGUID(domainConcept.getTechnicalName());
        link.setRangeConceptGUID(rangeConcept.getGUID());
        link.setRangeConceptName(rangeConcept.getTechnicalName());
        link.setMaxCount(maxCount);
        link.setMinCount(minCount);
        return link;
    }

    private PropertyDescription getPropertyDescription(String propertyTechnicalName) {
        PropertyDescription propertyDescription = this.propertyDescriptionMap.get(propertyTechnicalName);
        if (propertyDescription == null) {
            System.out.println("WARN: property description not in a property group: " + propertyTechnicalName);
            this.errorReport.add("WARN: property description not in a property group: " + propertyTechnicalName);
            propertyDescription = new PropertyDescription();
            propertyDescription.setTechnicalName(propertyTechnicalName);
            propertyDescription.setDisplayName(propertyTechnicalName);
            this.propertyDescriptionMap.put(propertyTechnicalName, propertyDescription);
        }
        return propertyDescription;
    }

    private void getPropertyGroup(Map<String, Object> conceptsJsonLD) {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setTechnicalName(this.getStringValue(conceptsJsonLD.get(AT_ID_TAG)));
        propertyGroup.setDisplayName(this.getStringValue(conceptsJsonLD.get(NAME_TAG)));
        this.propertyGroupMap.put(propertyGroup.getTechnicalName(), propertyGroup);
        List propertyConceptsJsonLD = (List)conceptsJsonLD.get(PROPERTY_CONCEPTS_TAG);
        if (propertyConceptsJsonLD != null) {
            for (Map propertyConceptJsonLD : propertyConceptsJsonLD) {
                if (propertyConceptJsonLD == null) continue;
                String propertyTechnicalName = this.getStringValue(propertyConceptJsonLD.get(AT_ID_TAG));
                PropertyDescription propertyDescription = this.getPropertyDescription(propertyTechnicalName, this.getStringValue(propertyConceptJsonLD.get(RANGE_TAG)));
                propertyDescription.setTechnicalName(propertyTechnicalName);
                propertyDescription.setDisplayName(this.getStringValue(propertyConceptJsonLD.get(NAME_TAG)));
                propertyDescription.setDescription(this.getStringValue(propertyConceptJsonLD.get(DESCRIPTION_TAG)));
                if (propertyDescription.isPrimitive()) {
                    System.out.println("==> Property name: " + propertyTechnicalName + " is an attribute ");
                } else if (propertyDescription.getDataTypeId() != null) {
                    System.out.println("==> Property name: " + propertyTechnicalName + " links to " + propertyDescription.getDataTypeId());
                } else {
                    System.out.println("ERROR: no data type Id for property: " + propertyTechnicalName);
                    this.errorReport.add("ERROR: no data type Id for property: " + propertyTechnicalName);
                }
                propertyGroup.addPropertyDescription(propertyTechnicalName, propertyDescription);
            }
        }
    }

    private void getConceptsForEntityGroup(ConceptGroup conceptGroup, Map<String, Object> classConceptJsonLD) {
        if (classConceptJsonLD != null) {
            String conceptTechnicalName = this.getStringValue(classConceptJsonLD.get(AT_ID_TAG));
            if (conceptTechnicalName != null) {
                Concept concept = this.getConcept(conceptTechnicalName);
                concept.setTechnicalName(conceptTechnicalName);
                concept.setDisplayName(this.getStringValue(classConceptJsonLD.get(NAME_TAG)));
                concept.setDescription(this.getStringValue(classConceptJsonLD.get(DESCRIPTION_TAG)));
                concept.setVersion(conceptGroup.getVersion());
                String superClassName = this.getStringValue(classConceptJsonLD.get(SUB_CLASS_TAG));
                if (superClassName != null) {
                    Concept superClass = this.getConcept(superClassName);
                    superClass.addSubClass(conceptTechnicalName);
                    concept.setSuperClassName(superClass.getTechnicalName());
                    System.out.println("     ==> Concept Bead name: " + conceptTechnicalName + " has superclass " + superClassName);
                } else {
                    System.out.println("     ==> Concept Bead name: " + conceptTechnicalName + " is top level class ");
                }
                conceptGroup.addConcept(conceptTechnicalName, concept);
            } else {
                System.out.println("ERROR: no id for concept properties: " + classConceptJsonLD);
                this.errorReport.add("ERROR: no id for concept properties: " + classConceptJsonLD);
            }
        }
    }

    private void validatePropertiesForEntityGroup(Map<String, Object> propertyConceptJsonLD) {
        String propertyTechnicalName = this.getStringValue(propertyConceptJsonLD.get(AT_ID_TAG));
        Object domainNamesObject = propertyConceptJsonLD.get(DOMAIN_TAG);
        ArrayList domainNames = new ArrayList((List)domainNamesObject);
        if (!domainNames.isEmpty()) {
            for (String domainName : domainNames) {
                if (domainName == null) continue;
                Concept concept = this.getConcept(domainName);
                if (concept.getGUID() != null) {
                    Attribute attribute = concept.getAttribute(propertyTechnicalName);
                    Link link = concept.getDomainLink(propertyTechnicalName);
                    if (attribute != null || link != null) continue;
                    String errorText = "WARN: missing property: " + propertyTechnicalName + " in concept " + domainName;
                    System.out.println(errorText);
                    this.errorReport.add(errorText);
                    continue;
                }
                String errorText = "WARN: missing concept: " + domainName + " for property " + propertyTechnicalName;
                System.out.println(errorText);
                this.errorReport.add(errorText);
            }
        } else {
            System.out.println("WARN: no domains for property name: " + propertyTechnicalName);
            this.errorReport.add("WARN: no domains for property name: " + propertyTechnicalName);
        }
    }

    private void getGUIDsForConcepts(Map<String, Object> schemaJsonLD) {
        try {
            String schemaType = this.getStringValue(schemaJsonLD.get(AT_TYPE_TAG));
            if (SHAPE_TYPE.equals(schemaType)) {
                String conceptTechnicalName = this.getStringValue(schemaJsonLD.get(TARGET_CLASS_PROPERTY));
                String conceptGUID = this.getStringValue(schemaJsonLD.get(AT_ID_TAG));
                if (conceptTechnicalName != null) {
                    Concept concept = this.getConcept(conceptTechnicalName);
                    concept.setGUID(conceptGUID);
                    this.conceptGUIDMap.put(conceptGUID, concept);
                } else {
                    System.out.println("ERROR: no name for concept: " + schemaJsonLD);
                    this.errorReport.add("ERROR: no name for concept: " + schemaJsonLD);
                }
            }
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    private void getPropertiesForConcepts(Map<String, Object> schemaJsonLD) {
        try {
            String schemaType = this.getStringValue(schemaJsonLD.get(AT_TYPE_TAG));
            if (SHAPE_TYPE.equals(schemaType)) {
                String conceptTechnicalName = this.getStringValue(schemaJsonLD.get(TARGET_CLASS_PROPERTY));
                if (conceptTechnicalName != null) {
                    Concept concept = this.getConcept(conceptTechnicalName);
                    List propertiesJsonLD = (List)schemaJsonLD.get(PROPERTIES_TAG);
                    if (propertiesJsonLD != null) {
                        for (Map propertyJsonLD : propertiesJsonLD) {
                            String propertyGUID = this.getStringValue(propertyJsonLD.get(AT_TYPE_TAG));
                            String propertyTechnicalName = this.getStringValue(propertyJsonLD.get(PATH_TAG));
                            String dataType = this.getStringValue(propertyJsonLD.get(DATA_TYPE_TAG));
                            Object node = propertyJsonLD.get(NODE_TAG);
                            String maxCount = this.getStringValue(propertyJsonLD.get(MAX_COUNT_TAG));
                            String minCount = this.getStringValue(propertyJsonLD.get(MIN_COUNT_TAG));
                            this.addProperty(concept, propertyGUID, propertyTechnicalName, dataType, node, maxCount, minCount);
                        }
                    }
                } else {
                    System.out.println("ERROR: no name for concept: " + schemaJsonLD);
                    this.errorReport.add("ERROR: no name for concept: " + schemaJsonLD);
                }
            }
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    private void reviewConcepts() {
        for (Concept concept : this.conceptNameMap.values()) {
            if (concept == null) continue;
            if (concept.getRangeOfLinks() == null) {
                List<Link> domainOfLinks = concept.getDomainOfLinks();
                if (domainOfLinks != null) {
                    if (domainOfLinks.size() == 2 && concept.getRangeOfLinks() == null) {
                        concept.setRelationship(true);
                        System.out.println("Concept: " + concept.getTechnicalName() + " is a relationship linking two concepts: " + domainOfLinks.get(0).getTechnicalName() + " and " + domainOfLinks.get(1).getTechnicalName());
                        continue;
                    }
                    System.out.println("Concept: " + concept.getTechnicalName() + " is a master-detail record");
                    continue;
                }
                System.out.println("Concept: " + concept.getTechnicalName() + " is isolated - it is not linked to anything");
                continue;
            }
            System.out.println("Concept: " + concept.getTechnicalName() + " is linked to by other concepts");
        }
    }

    public Model getModel() {
        Model model = new Model();
        model.setModelName(modelName);
        model.setModelTechnicalName(modelTechnicalName);
        model.setModelDescription(modelDescription);
        model.setModelLocation(modelLocation);
        model.setModelScope(modelScope);
        model.setModelLanguage(modelLanguage);
        model.setSubjectAreaMap(this.subjectAreaMap);
        model.setPropertyGroupMap(this.propertyGroupMap);
        model.setPropertyDescriptionMap(this.propertyDescriptionMap);
        model.setConceptBeadMap(this.conceptNameMap);
        model.setOrphanedConceptGroups(this.orphanedConceptGroups);
        model.setErrorReport(this.errorReport);
        return model;
    }
}

