/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Attribute;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Link;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.ModelElement;

public class Concept
extends ModelElement {
    private boolean relationship = false;
    private String superClassGUID = null;
    private String superClassName = null;
    private List<String> subClasses = new ArrayList<String>();
    private Map<String, Link> domainOfLinks = new HashMap<String, Link>();
    private Map<String, Link> rangeOfLinks = new HashMap<String, Link>();
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();

    public boolean isRelationship() {
        return this.relationship;
    }

    public void setRelationship(boolean relationship) {
        this.relationship = relationship;
    }

    public void addSubClass(String subClassTechnicalName) {
        this.subClasses.add(subClassTechnicalName);
    }

    public List<String> getSubClasses() {
        if (this.subClasses.isEmpty()) {
            return null;
        }
        return this.subClasses;
    }

    public String getSuperClassGUID() {
        return this.superClassGUID;
    }

    public void setSuperClassGUID(String superClassGUID) {
        this.superClassGUID = superClassGUID;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public void setDomainOfLink(String linkTechnicalName, Link link) {
        this.domainOfLinks.put(linkTechnicalName, link);
    }

    public Link getDomainLink(String linkTechnicalName) {
        if (this.domainOfLinks.isEmpty()) {
            return null;
        }
        return this.domainOfLinks.get(linkTechnicalName);
    }

    public List<Link> getDomainOfLinks() {
        if (this.domainOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<Link>(this.domainOfLinks.values());
    }

    public List<String> getDomainOfLinkNames() {
        if (this.domainOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.domainOfLinks.keySet());
    }

    public void setRangeOfLink(String linkTechnicalName, Link link) {
        this.rangeOfLinks.put(linkTechnicalName, link);
    }

    public List<Link> getRangeOfLinks() {
        if (this.rangeOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<Link>(this.rangeOfLinks.values());
    }

    public List<String> getRangeOfLinkNames() {
        if (this.rangeOfLinks.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.rangeOfLinks.keySet());
    }

    public Link getRangeLink(String linkTechnicalName) {
        if (this.rangeOfLinks.isEmpty()) {
            return null;
        }
        return this.rangeOfLinks.get(linkTechnicalName);
    }

    public void setAttribute(String attributeTechnicalName, Attribute attribute) {
        this.attributes.put(attributeTechnicalName, attribute);
    }

    public Attribute getAttribute(String attributeTechnicalName) {
        return this.attributes.get(attributeTechnicalName);
    }

    public List<String> getAttributeNames() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.attributes.keySet());
    }

    public List<Attribute> getAttributes() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return new ArrayList<Attribute>(this.attributes.values());
    }
}

