/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.CloudInformationModelParser;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Concept;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.ConceptGroup;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Model;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.PropertyDescription;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.PropertyGroup;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.SubjectArea;

public class CloudInformationModelArchiveWriter
extends OMRSArchiveWriter {
    static final String defaultOpenMetadataArchiveFileName = "content-packs/CloudInformationModel.omarchive";
    private static final String archiveGUID = "9dc75637-92a7-4926-b47b-a3d407546f89";
    private static final String archiveName = "CloudInformationModel";
    private static final String archiveLicense = "SPDX-License-Identifier: Apache-2.0";
    private static final String archiveDescription = "Cloud Information Model (CIM) glossary and concept model.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "The Cloud Information Model";
    private static final Date creationDate = new Date(1570383385107L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final SimpleCatalogArchiveHelper archiveHelper;
    private final OMRSArchiveBuilder archiveBuilder;
    private final CloudInformationModelParser parser;

    CloudInformationModelArchiveWriter(String cimModelLocation) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new SimpleCatalogArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, 1L, versionName, "CloudInformationModelGUIDMap.json");
        this.parser = new CloudInformationModelParser(cimModelLocation);
    }

    private OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.parser != null) {
            Model model = this.parser.getModel();
            String modelId = this.archiveHelper.addDesignModel(null, "ConceptModel", "DesignModel:" + model.getModelTechnicalName(), "Concept Model:" + model.getModelName(), model.getModelName(), model.getModelDescription(), null, null, null, null);
            String glossaryId = this.archiveHelper.addGlossary("Glossary:" + model.getModelTechnicalName(), model.getModelName(), model.getModelDescription(), model.getModelLanguage(), archiveDescription, model.getModelLocation(), model.getModelScope());
            this.archiveHelper.addMoreInformationLink(modelId, glossaryId);
            String cimModelCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, true, "ModelVocabulary:" + model.getModelTechnicalName(), "Model Vocabulary: " + model.getModelName(), model.getModelDescription(), null, null);
            this.archiveHelper.addMoreInformationLink(glossaryId, cimModelCategoryId);
            String modelTermId = this.archiveHelper.addTerm(glossaryId, null, "GlossaryDescription-" + model.getModelTechnicalName(), model.getModelName(), model.getModelDescription());
            this.archiveHelper.addMoreInformationLink(modelTermId, cimModelCategoryId);
            String propertyGroupsCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, "PropertyGroups-" + model.getModelTechnicalName(), "Property Groups for the " + model.getModelName(), "Collections of properties found in the CIM Model.", null);
            this.archiveHelper.addCategoryToCategory(cimModelCategoryId, propertyGroupsCategoryId);
            Map<String, PropertyGroup> propertyGroupMap = model.getPropertyGroupMap();
            if (propertyGroupMap != null) {
                for (PropertyGroup propertyGroup : propertyGroupMap.values()) {
                    String propertyGroupCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, propertyGroup.getGUID() + ":" + propertyGroup.getTechnicalName(), propertyGroup.getDisplayName(), propertyGroup.getDescription(), null);
                    this.archiveHelper.addCategoryToCategory(propertyGroupsCategoryId, propertyGroupCategoryId);
                    ArrayList<String> categoryList = new ArrayList<String>();
                    categoryList.add(propertyGroupCategoryId);
                    List<PropertyDescription> propertyDescriptions = propertyGroup.getPropertyDescriptions();
                    if (propertyDescriptions == null) continue;
                    for (PropertyDescription propertyDescription : propertyDescriptions) {
                        if (propertyDescription == null) continue;
                        String string = this.archiveHelper.addTerm(glossaryId, categoryList, propertyGroup.getGUID() + propertyGroup.getTechnicalName() + ":" + propertyDescription.getTechnicalName(), propertyDescription.getDisplayName(), propertyDescription.getDescription());
                    }
                }
            }
            String subjectAreasCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, "ModelSubjectAreas-" + model.getModelTechnicalName(), "Subject Areas for the " + model.getModelName() + " model", "Collections of related concepts (entities and relationships) found in the CIM Model that describe an area of interest.", null);
            this.archiveHelper.addCategoryToCategory(cimModelCategoryId, subjectAreasCategoryId);
            Map<String, SubjectArea> subjectAreaMap = model.getSubjectAreaMap();
            if (subjectAreaMap != null) {
                for (SubjectArea subjectArea : subjectAreaMap.values()) {
                    String subjectAreaCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, "SubjectArea:" + subjectArea.getTechnicalName(), subjectArea.getDisplayName(), subjectArea.getDescription(), subjectArea.getDisplayName());
                    this.archiveHelper.addCategoryToCategory(subjectAreasCategoryId, subjectAreaCategoryId);
                    String subjectAreaTermId = this.archiveHelper.addTerm(glossaryId, null, "ModelSubjectArea:" + model.getModelTechnicalName() + ":" + subjectArea.getTechnicalName(), subjectArea.getDisplayName(), subjectArea.getDescription());
                    this.archiveHelper.addMoreInformationLink(subjectAreaTermId, subjectAreaCategoryId);
                    Map<String, ConceptGroup> conceptGroupMap = subjectArea.getConceptGroups();
                    if (conceptGroupMap == null) continue;
                    for (ConceptGroup conceptGroup : conceptGroupMap.values()) {
                        if (conceptGroup == null) continue;
                        String conceptGroupCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, "ConceptGroup:" + conceptGroup.getGUID() + ":" + conceptGroup.getTechnicalName(), conceptGroup.getDisplayName(), conceptGroup.getDescription(), conceptGroup.getDisplayName());
                        this.archiveHelper.addCategoryToCategory(subjectAreaCategoryId, conceptGroupCategoryId);
                        String conceptGroupTermId = this.archiveHelper.addTerm(glossaryId, null, "ModelConceptGroup:" + model.getModelTechnicalName() + ":" + subjectArea.getTechnicalName() + ":" + conceptGroup.getGUID() + ":" + conceptGroup.getTechnicalName(), conceptGroup.getDisplayName(), conceptGroup.getDescription());
                        this.archiveHelper.addMoreInformationLink(conceptGroupTermId, conceptGroupCategoryId);
                        ArrayList<String> categoryList = new ArrayList<String>();
                        categoryList.add(conceptGroupCategoryId);
                        List<Concept> concepts = conceptGroup.getConcepts();
                        if (concepts == null) continue;
                        for (Concept concept : concepts) {
                            if (concept == null) continue;
                            String string = this.archiveHelper.addTerm(glossaryId, categoryList, "SubjectArea:" + subjectArea.getTechnicalName() + "::" + conceptGroup.getGUID() + concept.getTechnicalName(), concept.getDisplayName(), concept.getDescription());
                        }
                    }
                }
            }
            this.archiveHelper.saveGUIDs();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        this.archiveBuilder.logBadArchiveContent("getOpenMetadataArchive");
        return null;
    }

    void writeOpenMetadataArchive() {
        try {
            super.writeOpenMetadataArchive(defaultOpenMetadataArchiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    public static void main(String[] args) {
        String fileName = "cloud-information-model.jsonld";
        if (args.length > 0) {
            fileName = args[0];
        }
        try {
            CloudInformationModelArchiveWriter archiveWriter = new CloudInformationModelArchiveWriter(fileName);
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

