/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.CloudInformationModelParser;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Attribute;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Concept;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.ConceptGroup;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Link;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.LinkChoice;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.Model;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.PropertyDescription;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.PropertyGroup;
import org.odpi.openmetadata.samples.archiveutilities.cloudinformationmodel.properties.SubjectArea;

public class CloudInformationModelArchiveWriter
extends OMRSArchiveWriter {
    static final String defaultOpenMetadataArchiveFileName = "content-packs/CloudInformationModel.omarchive";
    private static final String archiveGUID = "9dc75637-92a7-4926-b47b-a3d407546f89";
    private static final String archiveName = "CloudInformationModel";
    private static final String archiveLicense = "SPDX-License-Identifier: Apache-2.0";
    private static final String archiveDescription = "Cloud Information Model (CIM) glossary and concept model.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "The Cloud Information Model";
    private static final Date creationDate = new Date(1570383385107L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final SimpleCatalogArchiveHelper archiveHelper;
    private final OMRSArchiveBuilder archiveBuilder;
    private final CloudInformationModelParser parser;

    CloudInformationModelArchiveWriter(String cimModelLocation) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new SimpleCatalogArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, 1L, versionName, "CloudInformationModelGUIDMap.json");
        this.parser = new CloudInformationModelParser(cimModelLocation);
    }

    private OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.parser != null) {
            Model model = this.parser.getModel();
            String dataDictionaryId = this.archiveHelper.addCollection(null, null, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, null, OpenMetadataType.DATA_DICTIONARY_COLLECTION.typeName, "DataDictionary::" + model.getModelName(), model.getModelName(), model.getModelSummary(), null, null, null, null);
            String glossaryId = this.archiveHelper.addGlossary("Glossary::" + model.getModelTechnicalName(), model.getModelName(), model.getModelSummary(), model.getModelLanguage(), archiveDescription, model.getModelLocation(), model.getModelScope());
            String modelTermId = this.archiveHelper.addTerm(glossaryId, null, false, "GlossaryTerm::CIMDescription-" + model.getModelTechnicalName(), model.getModelName(), model.getModelSummary(), model.getModelDescription(), null, null, model.getModelUsage(), false, false, false, null, null, null, null);
            this.archiveHelper.addMoreInformationLink(dataDictionaryId, modelTermId);
            String topLevelSubjectAreaFolderId = this.archiveHelper.addCollection(null, dataDictionaryId, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, null, OpenMetadataType.FOLDER.typeName, "Folder::ModelSubjectAreas-" + model.getModelTechnicalName(), "Subject Areas for the " + model.getModelName() + " model", "Collections of related concepts (entities and relationships) found in the CIM Model that describe an area of interest.", null, null, null, null);
            this.archiveHelper.addMemberToCollection(dataDictionaryId, topLevelSubjectAreaFolderId, null);
            Map<String, SubjectArea> subjectAreaMap = model.getSubjectAreaMap();
            if (subjectAreaMap != null) {
                for (SubjectArea subjectArea : subjectAreaMap.values()) {
                    String subjectAreaFolderId = this.archiveHelper.addCollection(null, null, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, null, OpenMetadataType.FOLDER.typeName, "Folder::ModelSubjectAreas-" + model.getModelTechnicalName() + "::" + subjectArea.getTechnicalName(), subjectArea.getDisplayName(), subjectArea.getDescription(), null, null, null, null);
                    this.archiveHelper.addMemberToCollection(topLevelSubjectAreaFolderId, subjectAreaFolderId, null);
                    Map<String, ConceptGroup> conceptGroupMap = subjectArea.getConceptGroups();
                    ArrayList<String> existingProperties = new ArrayList<String>();
                    if (conceptGroupMap == null) continue;
                    for (ConceptGroup conceptGroup : conceptGroupMap.values()) {
                        if (conceptGroup == null) continue;
                        String conceptGroupCategoryId = this.archiveHelper.addCollection(null, null, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, null, OpenMetadataType.FOLDER.typeName, "Folder::ConceptGroup::" + conceptGroup.getGUID() + "::" + conceptGroup.getTechnicalName(), conceptGroup.getDisplayName(), conceptGroup.getDescription(), null, null, null, null);
                        this.archiveHelper.addMemberToCollection(subjectAreaFolderId, conceptGroupCategoryId, null);
                        List<Concept> concepts = conceptGroup.getConcepts();
                        if (concepts == null) continue;
                        for (Concept concept : concepts) {
                            if (concept == null) continue;
                            String conceptQualifiedName = "DataField::SubjectArea::" + subjectArea.getTechnicalName() + "::" + concept.getTechnicalName();
                            this.archiveHelper.setGUID(conceptQualifiedName, concept.getGUID());
                            String conceptFieldId = this.archiveHelper.addDataField(null, null, OpenMetadataType.DATA_FIELD.typeName, OpenMetadataType.DATA_FIELD.typeName, null, null, conceptQualifiedName, concept.getDisplayName(), concept.getDescription(), model.getModelVersion(), null, null, null, null, null);
                            assert (conceptFieldId.equals(concept.getGUID()));
                            this.archiveHelper.addMemberToCollection(conceptGroupCategoryId, concept.getGUID(), null);
                            if (concept.getAttributes() == null) continue;
                            for (Attribute attribute : concept.getAttributes()) {
                                if (!existingProperties.contains(attribute.getGUID())) {
                                    String attributeQualifiedName = "DataField::" + model.getModelTechnicalName() + "::" + attribute.getTechnicalName();
                                    this.archiveHelper.setGUID(attributeQualifiedName, attribute.getGUID());
                                    String dataFieldId = this.archiveHelper.addDataField(null, null, OpenMetadataType.DATA_FIELD.typeName, OpenMetadataType.DATA_FIELD.typeName, null, null, attributeQualifiedName, attribute.getDisplayName(), attribute.getDescription(), model.getModelVersion(), null, attribute.getDataType(), null, null, null);
                                    assert (dataFieldId.equals(attribute.getGUID()));
                                    existingProperties.add(attribute.getGUID());
                                }
                                this.archiveHelper.addNestedDataField(concept.getGUID(), attribute.getGUID(), 0, 1, 1);
                            }
                        }
                    }
                    for (ConceptGroup conceptGroup : conceptGroupMap.values()) {
                        List<Concept> concepts;
                        if (conceptGroup == null || (concepts = conceptGroup.getConcepts()) == null) continue;
                        for (Concept concept : concepts) {
                            if (concept == null || concept.getDomainOfLinks() == null) continue;
                            for (Link link : concept.getDomainOfLinks()) {
                                if (link instanceof LinkChoice) {
                                    for (Link linkOption : ((LinkChoice)link).getLinkChoices()) {
                                        if (!existingProperties.contains(linkOption.getGUID())) {
                                            String attributeQualifiedName = "DataField::" + model.getModelTechnicalName() + "::" + linkOption.getTechnicalName();
                                            if (linkOption.getGUID() == null) {
                                                linkOption.setGUID(UUID.randomUUID().toString());
                                            }
                                            this.archiveHelper.setGUID(attributeQualifiedName, linkOption.getGUID());
                                            String dataFieldId = this.archiveHelper.addDataField(null, null, OpenMetadataType.DATA_FIELD.typeName, OpenMetadataType.DATA_FIELD.typeName, null, null, attributeQualifiedName, link.getDisplayName(), link.getDescription(), model.getModelVersion(), null, link.getRangeConceptName(), null, null, null);
                                            assert (linkOption.getGUID().equals(dataFieldId));
                                            existingProperties.add(linkOption.getGUID());
                                        }
                                        this.archiveHelper.addNestedDataField(concept.getGUID(), linkOption.getGUID(), 0, 1, 1);
                                    }
                                } else if (!existingProperties.contains(link.getGUID())) {
                                    String attributeQualifiedName = "DataField::" + model.getModelTechnicalName() + "::" + link.getTechnicalName();
                                    if (link.getGUID() == null) {
                                        link.setGUID(UUID.randomUUID().toString());
                                    }
                                    this.archiveHelper.setGUID(attributeQualifiedName, link.getGUID());
                                    String dataFieldId = this.archiveHelper.addDataField(null, null, OpenMetadataType.DATA_FIELD.typeName, OpenMetadataType.DATA_FIELD.typeName, null, null, attributeQualifiedName, link.getDisplayName(), link.getDescription(), model.getModelVersion(), null, link.getRangeConceptName(), null, null, null);
                                    assert (link.getGUID().equals(dataFieldId));
                                    existingProperties.add(link.getGUID());
                                }
                                this.archiveHelper.addNestedDataField(concept.getGUID(), link.getGUID(), 0, 1, 1);
                            }
                        }
                    }
                }
            }
            String propertyGroupsCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, true, "GlossaryCategory::PropertyGroups-" + model.getModelTechnicalName(), "Property Groups for the " + model.getModelName(), "Collections of properties found in the CIM Model.", null, null);
            Map<String, PropertyGroup> propertyGroupMap = model.getPropertyGroupMap();
            if (propertyGroupMap != null) {
                for (PropertyGroup propertyGroup : propertyGroupMap.values()) {
                    String propertyGroupCategoryId = this.archiveHelper.addGlossaryCategory(glossaryId, "GlossaryCategory::" + propertyGroup.getGUID() + "::" + propertyGroup.getTechnicalName(), propertyGroup.getDisplayName(), propertyGroup.getDescription(), null);
                    this.archiveHelper.addCategoryToCategory(propertyGroupsCategoryId, propertyGroupCategoryId);
                    String propertyGroupFolderId = this.archiveHelper.addCollection(null, dataDictionaryId, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, dataDictionaryId, OpenMetadataType.FOLDER.typeName, "Folder::" + propertyGroup.getGUID() + "::" + propertyGroup.getTechnicalName(), propertyGroup.getDisplayName(), propertyGroup.getDescription(), null, null, null, null);
                    this.archiveHelper.addMemberToCollection(dataDictionaryId, propertyGroupFolderId, null);
                    ArrayList<String> categoryList = new ArrayList<String>();
                    categoryList.add(propertyGroupCategoryId);
                    List<PropertyDescription> propertyDescriptions = propertyGroup.getPropertyDescriptions();
                    if (propertyDescriptions == null) continue;
                    for (PropertyDescription propertyDescription : propertyDescriptions) {
                        if (propertyDescription == null || propertyDescription.getDescription() == null) continue;
                        String string = this.archiveHelper.addTerm(glossaryId, categoryList, propertyGroup.getGUID() + propertyGroup.getTechnicalName() + "::" + propertyDescription.getTechnicalName(), propertyDescription.getDisplayName(), propertyDescription.getDescription());
                        if (propertyDescription.getAttributes() == null) continue;
                        for (Attribute attribute : propertyDescription.getAttributes()) {
                            this.archiveHelper.addSemanticDefinition(attribute.getGUID(), string);
                        }
                    }
                }
            }
            this.archiveHelper.saveGUIDs();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        this.archiveBuilder.logBadArchiveContent("getOpenMetadataArchive");
        return null;
    }

    void writeOpenMetadataArchive() {
        try {
            super.writeOpenMetadataArchive(defaultOpenMetadataArchiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + String.valueOf(error));
        }
    }

    public static void main(String[] args) {
        String fileName = "cloud-information-model.jsonld";
        if (args.length > 0) {
            fileName = args[0];
        }
        try {
            CloudInformationModelArchiveWriter archiveWriter = new CloudInformationModelArchiveWriter(fileName);
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + String.valueOf(error));
            System.exit(-1);
        }
    }
}

