/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.businesssystems;

import java.util.Arrays;
import java.util.List;

public enum DataStoreDefinition {
    ODS("DGG-ODS-01", "Central operational data store feeding the accounts/ledgers.", "Database", "V2.6", new String[]{"business-systems", "sustainability"}, 0L);

    private final String dataStoreId;
    private final String description;
    private final String typeName;
    private final String versionIdentifier;
    private final String[] zones;
    private final long loadTime;

    private DataStoreDefinition(String dataStoreId, String description, String typeName, String versionIdentifier, String[] zones, long loadTime) {
        this.dataStoreId = dataStoreId;
        this.description = description;
        this.typeName = typeName;
        this.versionIdentifier = versionIdentifier;
        this.zones = zones;
        this.loadTime = loadTime;
    }

    public String getQualifiedName() {
        return "DataStore:" + this.typeName + ":" + this.dataStoreId;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<String> getZones() {
        if (this.zones != null) {
            return Arrays.asList(this.zones);
        }
        return null;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public String toString() {
        return "DataStoreDefinition{" + this.dataStoreId + "}";
    }
}

