/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.businesssystems;

public enum SystemTypeDefinition {
    COTS_SERVER("cots-application-server", "Custom off-the-shelf application server", "Server deployed as part of a COTS application package.  Coco Pharmaceuticals has minimal control over the structure and naming of this type of software server.", "These servers drive the business.  They provide standard business functions.", new String[]{"Application"}, "ApplicationServer"),
    HOME_GROWN_APP_SERVER("homegrown-application-server", "Homegrown application server", "Server deployed as part of a bespoke application written by Coco Pharmaceuticals.", "These servers drive specialized aspects of the business.", new String[]{"Application"}, "ApplicationServer"),
    ETL_ENGINE("etl-engine", "Extract-Transform-Load (ETL) engine", "Server deployed to run jobs that copy and transform data from one system to another.", "These servers are part of a middleware deployment.", new String[]{"DataMovementEngine"}, "IntegrationServer"),
    DATABASE_SERVER("database-server", "Database Server", "Database server providing a collection of data that can be flexibly queried.", "These servers are part of a middleware deployment.", new String[]{"DatabaseManager"}, "DatabaseServer"),
    EVENT_BROKER("event-broker", "Event Broker", "Event broker server providing event notifications based on subscriptions.", "These servers are part of a middleware deployment.", new String[]{"EventBroker"}, "IntegrationServer"),
    REPORTING_SERVER("reporting-server", "Reporting Server", "Server that delivers business reports.", "These servers are part of a middleware deployment.", new String[]{"ReportingEngine"}, "ApplicationServer"),
    OPEN_METADATA_ACCESS_STORE("metadata-access-store", "Open Metadata Access Store", "Metadata server with a repository that is part of the open metadata ecosystem.", "These servers are part of a middleware deployment.", new String[]{"MetadataAccessService", "MetadataRepositoryService", "CohortMember"}, "MetadataServer"),
    OPEN_METADATA_ACCESS_POINT("metadata-access-point", "Open Metadata Access Point", "Server supporting Open Metadata Access Services (OMASs) but no metadata repository. It is connected to the open metadata ecosystem via a cohort.", "These servers are part of a middleware deployment.", new String[]{"MetadataAccessService", "CohortMember"}, null),
    ENGINE_HOST_SERVER("engine-host", "Open Metadata Engine Host Server", "Server hosting governance engine. It is part of the open metadata ecosystem.", "These servers are part of a middleware deployment.", new String[]{"EngineHostingService"}, "GovernanceDaemon"),
    INTEGRATION_DAEMON("integration-daemon", "Open Metadata Integration Daemon", "Server hosting integration connectors responsible for synchronizing metadata. It is part of the open metadata ecosystem.", "These servers are part of a middleware deployment.", new String[]{"MetadataIntegrationService"}, "GovernanceDaemon"),
    REPOSITORY_PROXY("repository-proxy", "Open Metadata Repository Proxy", "Server hosting a repository connector responsible for synchronizing metadata from a third party metadata repository. It is part of the open metadata ecosystem.", "These servers are part of a middleware deployment.", new String[]{"MetadataIntegrationService", "CohortMember"}, "RepositoryProxy"),
    VIEW_SERVER("view-server", "Open Metadata View Server", "Server providing REST API implementations for a UI.", "These servers are part of a middleware deployment.", new String[]{"MetadataViewService"}, null),
    VIEW_CLIENT("view-client", "Open Metadata View Client", "UI server supplying UI code (javascript/typescript) to the browser.", "These servers are part of a middleware deployment.", null, "null"),
    CLOUD_SAAS_SERVICE("cloud-saas-service", "External Business Cloud Service", "Application or service hosted by an external cloud provider.", "These servers are managed by an external organization.", null, "ApplicationServer");

    public static final String validValueSetName = "SystemType";
    public static final String validValueSetDescription = "Describes the type of system.";
    public static final String validValueSetUsage = "Used to identify the types of software capabilities that are associated with this type of system.";
    public static final String validValueSetScope = "Used to tag system definitions.";
    private final String preferredValue;
    private final String displayName;
    private final String description;
    private final String usage;
    private final String[] softwareServerCapabilities;
    private final String serverPurpose;

    private SystemTypeDefinition(String preferredValue, String displayName, String description, String usage, String[] softwareServerCapabilities, String serverPurpose) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
        this.usage = usage;
        this.softwareServerCapabilities = softwareServerCapabilities;
        this.serverPurpose = serverPurpose;
    }

    public String getQualifiedName() {
        return "SystemType." + this.preferredValue;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public String[] getSoftwareServerCapabilities() {
        return this.softwareServerCapabilities;
    }

    public String getServerPurpose() {
        return this.serverPurpose;
    }

    public String toString() {
        return "SystemTypeDefinition{" + this.displayName + "}";
    }
}

