/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.PlaceholderPropertyType;

public enum PlaceholderProperty {
    CLINICAL_TRIAL_ID("clinicalTrialId", "Add the identifier of the clinical trial.", "string", "xxx"),
    CLINICAL_TRIAL_NAME("clinicalTrialName", "Add the display name of the clinical trial.", "string", "xxx"),
    HOSPITAL_NAME("hospitalName", "Add the name of the hospital that sent the measurements.", "string", "xxx"),
    CONTACT_NAME("contactName", "Add the name of the person at the hospital who is responsible for supplying the measurements.", "string", "xxx"),
    CONTACT_DEPT("contactDept", "Add the hospital department where the contact name works.", "string", "xxx"),
    RECEIVED_DATE("receivedDate", "Add the date that the measurements were received.", "string", "xxx"),
    PATH_NAME("pathName", "Add the full name (absolute file name) of the file and its enclosing directory structure.", "string", "xxx"),
    FILE_NAME("fileName", "Add the name of the file without directory information.", "string", "xxx");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private PlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        for (PlaceholderProperty placeholderProperty : PlaceholderProperty.values()) {
            placeholderPropertyTypes.add(placeholderProperty.getPlaceholderType());
        }
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

