/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.combo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.odpi.openmetadata.archiveutilities.openconnectors.OpenConnectorArchiveWriter;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.samples.archiveutilities.CocoArchiveHelper;

public abstract class CocoBaseArchiveWriter
extends OMRSArchiveWriter {
    protected static final String archiveLicense = "Apache 2.0";
    protected static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    protected static final String originatorName = "Egeria Project";
    protected static final String guidMapFileName = "CocoComboGUIDMap.json";
    protected static final String openMetadataValidValueSetPrefix = "OpenMetadata.ValidValueSet.";
    protected static final long versionNumber = 1L;
    protected static final String versionName = "1.0";
    protected OMRSArchiveBuilder archiveBuilder;
    protected CocoArchiveHelper archiveHelper;
    protected final String archiveGUID;
    protected final String archiveName;
    protected final Date creationDate;
    protected final String archiveFileName;

    protected CocoBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, Date creationDate, String archiveFileName) {
        this(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, null);
    }

    protected CocoBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, Date creationDate, String archiveFileName, OpenMetadataArchive[] additionalDependencies) {
        this.archiveGUID = archiveGUID;
        this.archiveName = archiveName;
        this.creationDate = creationDate;
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        dependentOpenMetadataArchives.add(new OpenConnectorArchiveWriter().getOpenMetadataArchive());
        if (additionalDependencies != null) {
            dependentOpenMetadataArchives.addAll(Arrays.asList(additionalDependencies));
        }
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new CocoArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, 1L, versionName, guidMapFileName);
        this.archiveFileName = archiveFileName;
    }

    protected void setArchiveBuilder(OMRSArchiveBuilder archiveBuilder, CocoArchiveHelper archiveHelper) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = archiveHelper;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        this.getArchiveContent();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    public abstract void getArchiveContent();

    public void writeOpenMetadataArchive() {
        try {
            System.out.println("Writing to file: " + this.archiveFileName);
            super.writeOpenMetadataArchive(this.archiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
        this.archiveHelper.saveGUIDs();
    }
}

