/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.combo;

import java.util.Date;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.CocoBusinessSystemsArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates.CocoClinicalTrialsArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.combo.CocoBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.governanceengines.CocoGovernanceEnginesArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoGovernanceProgramArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.organization.CocoOrganizationArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.CocoSustainabilityArchiveWriter;

public class CocoComboArchiveWriter
extends CocoBaseArchiveWriter {
    private static final String archiveFileName = "CocoComboArchive.omarchive";
    private static final String archiveGUID = "655b1965-4c29-4a0e-8a5d-3f55a37b3799";
    private static final String archiveName = "Coco Pharmaceuticals Combination";
    private static final String archiveDescription = "The combination of the contents of the Coco Pharmaceuticals' business systems, clinical trials templates, organization, and sustainability definitions.";

    public CocoComboArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, new Date(), archiveFileName);
    }

    @Override
    public OpenMetadataArchive getOpenMetadataArchive() {
        this.getArchiveContent();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    @Override
    public void getArchiveContent() {
        CocoOrganizationArchiveWriter organizationArchiveWriter = new CocoOrganizationArchiveWriter();
        CocoGovernanceProgramArchiveWriter governanceProgramArchiveWriter = new CocoGovernanceProgramArchiveWriter();
        CocoClinicalTrialsArchiveWriter clinicalTrialsArchiveWriter = new CocoClinicalTrialsArchiveWriter();
        CocoGovernanceEnginesArchiveWriter governanceEnginesArchiveWriter = new CocoGovernanceEnginesArchiveWriter();
        CocoBusinessSystemsArchiveWriter businessSystemsArchiveWriter = new CocoBusinessSystemsArchiveWriter();
        CocoSustainabilityArchiveWriter sustainabilityArchiveWriter = new CocoSustainabilityArchiveWriter();
        organizationArchiveWriter.setArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        organizationArchiveWriter.getArchiveContent();
        governanceProgramArchiveWriter.setArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        governanceProgramArchiveWriter.getArchiveContent();
        clinicalTrialsArchiveWriter.setArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        clinicalTrialsArchiveWriter.getArchiveContent();
        governanceEnginesArchiveWriter.setArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        governanceEnginesArchiveWriter.getArchiveContent();
        sustainabilityArchiveWriter.setArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        sustainabilityArchiveWriter.getArchiveContent();
        businessSystemsArchiveWriter.setArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        businessSystemsArchiveWriter.getArchiveContent();
    }
}

