/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceengines;

import java.util.Date;
import java.util.HashMap;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.ZonePublisherGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericFolderWatchdogGovernanceActionProvider;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.archiveutilities.combo.CocoBaseArchiveWriter;

public class CocoGovernanceEnginesArchiveWriter
extends CocoBaseArchiveWriter {
    private static final String archiveFileName = "CocoGovernanceEngineDefinitionsArchive.omarchive";
    private static final String archiveGUID = "9cbd2b33-e80f-4df2-adc6-d859ebff4c34";
    private static final String archiveName = "CocoGovernanceEngineDefinitions";
    private static final String archiveDescription = "Governance Engines for Coco Pharmaceuticals.";

    public CocoGovernanceEnginesArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, new Date(), archiveFileName, null);
    }

    private String getAssetGovernanceEngine() {
        String assetGovernanceEngineName = "AssetGovernance";
        String assetGovernanceEngineDisplayName = "AssetGovernance Governance Action Engine";
        String assetGovernanceEngineDescription = "Monitors, validates and enriches metadata relating to assets.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "AssetGovernance", "AssetGovernance Governance Action Engine", "Monitors, validates and enriches metadata relating to assets.", null, null, null, null, null, null);
    }

    private String getAssetDiscoveryEngine() {
        String assetDiscoveryEngineName = "AssetDiscovery";
        String assetDiscoveryEngineDisplayName = "AssetDiscovery Survey Action Engine";
        String assetDiscoveryEngineDescription = "Extracts metadata about a digital resource and attach it to its asset description.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "AssetDiscovery", "AssetDiscovery Survey Action Engine", "Extracts metadata about a digital resource and attach it to its asset description.", null, null, null, null, null, null);
    }

    private String getAssetQualityEngine() {
        String assetQualityEngineName = "AssetQuality";
        String assetQualityEngineDisplayName = "AssetQuality Survey Action Engine";
        String assetQualityEngineDescription = "Assess the quality of a digital resource identified by the asset in the request.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "AssetQuality", "AssetQuality Survey Action Engine", "Assess the quality of a digital resource identified by the asset in the request.", null, null, null, null, null, null);
    }

    private String getFileProvisioningGovernanceActionService() {
        String governanceServiceName = "coco-file-provisioning-governance-action-service";
        String governanceServiceDisplayName = "File {move, copy, delete} Governance Action Service";
        String governanceServiceDescription = "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination, along with lineage options";
        String ftpGovernanceServiceProviderClassName = MoveCopyFileGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ftpGovernanceServiceProviderClassName, null, "coco-file-provisioning-governance-action-service", "File {move, copy, delete} Governance Action Service", "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination, along with lineage options", null);
    }

    private String getWatchdogGovernanceActionService() {
        String governanceServiceName = "coco-new-measurements-watchdog-governance-action-service";
        String governanceServiceDisplayName = "New Measurements Watchdog Governance Action Service";
        String governanceServiceDescription = "Initiates a governance action process when a new weekly measurements file arrives.";
        String governanceServiceProviderClassName = GenericFolderWatchdogGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "coco-new-measurements-watchdog-governance-action-service", "New Measurements Watchdog Governance Action Service", "Initiates a governance action process when a new weekly measurements file arrives.", null);
    }

    private String getZonePublisherGovernanceActionService() {
        String governanceServiceName = "coco-zone-publisher-governance-action-service";
        String governanceServiceDisplayName = "Update Asset's Zone Membership Governance Action Service";
        String governanceServiceDescription = "Set up the zone membership for one or more assets supplied as action targets.";
        String governanceServiceProviderClassName = ZonePublisherGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "coco-zone-publisher-governance-action-service", "Update Asset's Zone Membership Governance Action Service", "Set up the zone membership for one or more assets supplied as action targets.", null);
    }

    private String getOriginSeekerGovernanceActionService() {
        String governanceServiceName = "coco-origin-seeker-governance-action-service";
        String governanceServiceDisplayName = "Locate and Set Origin Governance Action Service";
        String governanceServiceDescription = "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.";
        String governanceServiceProviderClassName = OriginSeekerGovernanceActionProvider.class.getName();
        return this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "coco-origin-seeker-governance-action-service", "Locate and Set Origin Governance Action Service", "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.", null);
    }

    private void addFTPFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "simulate-ftp";
        String serviceRequestType = "copy-file";
        String noLineagePropertyName = "noLineage";
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("noLineage", "");
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "simulate-ftp", "copy-file", requestParameters, governanceServiceGUID);
    }

    private void addWatchNestedInFolderRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "watch-for-new-files";
        String serviceRequestType = "watch-nested-in-folder";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "watch-for-new-files", "watch-nested-in-folder", null, governanceServiceGUID);
    }

    private void addCopyFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "copy-file";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "copy-file", null, null, governanceServiceGUID);
    }

    private void addMoveFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "move-file";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "move-file", null, null, governanceServiceGUID);
    }

    private void addDeleteFileRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceRequestType = "delete-file";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "delete-file", null, null, governanceServiceGUID);
    }

    private void addSeekOriginRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceServiceRequestType = "seek-origin";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "seek-origin", null, null, governanceServiceGUID);
    }

    private void addSetZoneMembershipRequestType(String governanceEngineGUID, String governanceServiceGUID) {
        String governanceServiceRequestType = "set-zone-membership";
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, "set-zone-membership", null, null, governanceServiceGUID);
    }

    @Override
    public void getArchiveContent() {
        String fileProvisionerGUID = this.getFileProvisioningGovernanceActionService();
        String watchDogServiceGUID = this.getWatchdogGovernanceActionService();
        String originSeekerGUID = this.getOriginSeekerGovernanceActionService();
        String zonePublisherGUID = this.getZonePublisherGovernanceActionService();
        String assetGovernanceEngineGUID = this.getAssetGovernanceEngine();
        this.addFTPFileRequestType(assetGovernanceEngineGUID, fileProvisionerGUID);
        this.addWatchNestedInFolderRequestType(assetGovernanceEngineGUID, watchDogServiceGUID);
        this.addSeekOriginRequestType(assetGovernanceEngineGUID, originSeekerGUID);
        this.addSetZoneMembershipRequestType(assetGovernanceEngineGUID, zonePublisherGUID);
        this.addMoveFileRequestType(assetGovernanceEngineGUID, fileProvisionerGUID);
        this.addDeleteFileRequestType(assetGovernanceEngineGUID, fileProvisionerGUID);
        String assetDiscoveryEngineGUID = this.getAssetDiscoveryEngine();
        String assetQualityEngineGUID = this.getAssetQualityEngine();
    }

    @Override
    public void writeOpenMetadataArchive() {
        try {
            System.out.println("Writing to file: CocoGovernanceEngineDefinitionsArchive.omarchive");
            super.writeOpenMetadataArchive(archiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }
}

