/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

public enum CocoSubjectAreaDefinition {
    ORGANIZATION("Organization", null, "Organization", "Information relating to an organization.", "Across Coco Pharmaceuticals.", "Controlling data management relating to different types of organizational structures and catalogues.", 0),
    HOSPITAL("Organization:Hospital", ORGANIZATION, "Hospital", "Information relating to a hospital's organization.", "Across Coco Pharmaceuticals.", "Controlling data management relating to different types of hospital organizational structures and catalogues.", 0),
    SUPPLIER("Organization:Supplier", ORGANIZATION, "Supplier", "Information relating to a supplier's organization.", "Across Coco Pharmaceuticals.", "Controlling data management relating to different types of supplier organizational structures and catalogues.", 0),
    PERSON("Person", null, "Person", "Information relating to an individual.", "Across Coco Pharmaceuticals.", "Controlling data management relating to information that describes an individual.", 0),
    PATIENT("Person:Patient", PERSON, "Patient", "Information relating to an individual patient.", "Across Coco Pharmaceuticals.", "Controlling data management relating to information that describes an individual patient.", 0),
    CLINICIAN("Person:Clinician", PERSON, "Clinician", "Information relating to an individual who works with patients.", "Across Coco Pharmaceuticals.", "Controlling data management relating to information that describes an individual working with patients.", 0),
    EMPLOYEE("Person:Employee", PERSON, "Employee", "Information relating to an individual who is employed by an organization.", "Across Coco Pharmaceuticals.", "Controlling data management relating to information that describes an employee.", 0),
    COLLABORATOR("Person:Collaborator", PERSON, "Collaborator", "Information relating to an individual who works for a business partner.", "Across Coco Pharmaceuticals.", "Controlling data management relating to information that describes an individuals who are business partners.", 0),
    CLINICAL("Clinical", null, "Clinical", "Information relating to the work understanding medical conditions and their resolution.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", 0),
    SYMPTOM("Clinical:Symptom", CLINICAL, "Clinical", "Information relating to the symptoms of a medical condition.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", 0),
    MEASUREMENT("Clinical:Measurement", CLINICAL, "Measurement", "Information relating to the measurements taken to understanding medical conditions and their effectiveness.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", 0),
    PRESCRIPTION("Clinical:Prescription", CLINICAL, "Prescription", "Information relating to the treatment defined for a specific patient.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", 0),
    OUTCOME("Clinical:Outcome", CLINICAL, "Outcome", "Information relating to the work understanding the result of a course of treatment.", "Within research, sales and the data lake.", "Controlling data management relating to research and patient care.", 0),
    TREATMENT("Treatment", null, "Treatment", "Information relating to the Coco Pharmaceutical products and practices around patient care.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", 0),
    PRODUCT("Treatment:Product", TREATMENT, "Product", "Information relating to the Coco Pharmaceutical products to be used in particular treatments.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", 0),
    ORDER("Treatment:Order", TREATMENT, "Order", "Information relating to orders for Coco Pharmaceutical products.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", 0),
    RECIPE("Treatment:Recipe", TREATMENT, "Recipe", "Information relating to the ingredients and manufacturing know-how for Coco Pharmaceutical products.", "Within research, sales, manufacturing and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' treatments.", 0),
    SERVICE_QUALITY("ServiceQuality", null, "Service Quality", "Information relating to the Coco Pharmaceuticals' business operations.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", 0),
    CONTRACT("ServiceQuality:Contract", SERVICE_QUALITY, "Contract", "Information relating to the Coco Pharmaceuticals' contracts.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", 0),
    STOCK("ServiceQuality:Stock", SERVICE_QUALITY, "Stock", "Information relating to the Coco Pharmaceuticals' stock management and control.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", 0),
    DISTRIBUTION("ServiceQuality:Distribution", SERVICE_QUALITY, "Distribution", "Information relating to the Coco Pharmaceuticals' distribution of treatments.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", 0),
    INVOICE("ServiceQuality:Invoice", SERVICE_QUALITY, "Invoice", "Information relating to the Coco Pharmaceuticals' billing and payments.", "Within research, sales, manufacturing, finance and the data lake.", "Controlling data management relating to Coco Pharmaceuticals' business operations.", 0);

    private final String subjectAreaName;
    private final CocoSubjectAreaDefinition parent;
    private final String displayName;
    private final String description;
    private final String scope;
    private final String usage;
    private final int domain;

    private CocoSubjectAreaDefinition(String name, CocoSubjectAreaDefinition parent, String displayName, String description, String scope, String usage, int domain) {
        this.subjectAreaName = name;
        this.parent = parent;
        this.displayName = displayName;
        this.description = description;
        this.scope = scope;
        this.usage = usage;
        this.domain = domain;
    }

    public String getQualifiedName() {
        return "SubjectArea:" + this.subjectAreaName;
    }

    public String getSubjectAreaName() {
        return this.subjectAreaName;
    }

    public CocoSubjectAreaDefinition getParent() {
        return this.parent;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsage() {
        return this.usage;
    }

    public int getDomain() {
        return this.domain;
    }

    public String toString() {
        return "CocoSubjectAreaDefinition{subjectAreaName='" + this.subjectAreaName + "'}";
    }
}

