/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public enum GovernanceDomainDefinition {
    ALL(0, "All Governance Domains", "Relevant to all governance domains.", "Governance Leadership Community", PersonDefinition.JULES_KEEPER),
    DATA(1, "Data (Information) Governance", "Management and use of data.", "Data Governance Community", PersonDefinition.ERIN_OVERVIEW),
    PRIVACY(2, "Data Privacy", "Ensuring individual privacy both in research and operations.", "Data Privacy Community", PersonDefinition.FAITH_BROKER),
    SECURITY(3, "Information Security", "Ensuring the security of Coco Pharmaceuticals' systems, data and processes.", "InfoSec Community", PersonDefinition.IVOR_PADLOCK),
    IT_INFRASTRUCTURE(4, "IT Governance", "Management of IT infrastructure such as hosts, servers, applications, databases and network infrastructure descriptions.", "IT Governance Community", PersonDefinition.GARY_GEEKE),
    SOFTWARE_DEVELOPMENT(5, "Software Development Assurance", "Managing the development of new software and systems.", "Software Development Leadership Community", PersonDefinition.POLLY_TASKER),
    CORPORATE(6, "Corporate Governance", "Ensuring the legal operation of Coco Pharmaceuticals.", "Corporate Governance Community", PersonDefinition.REGGIE_MINT),
    ASSET_MANAGEMENT(7, "Physical Asset Management", "Management of assets that describe the physical equipment of Coco Pharmaceuticals.", "Asset Management Community", PersonDefinition.SIDNEY_SEEKER);

    private final int domainIdentifier;
    private final String displayName;
    private final String description;
    private final String communityName;
    private final PersonDefinition governanceOfficer;

    private GovernanceDomainDefinition(int domainIdentifier, String displayName, String description, String communityName, PersonDefinition governanceOfficer) {
        this.domainIdentifier = domainIdentifier;
        this.displayName = displayName;
        this.description = description;
        this.communityName = communityName;
        this.governanceOfficer = governanceOfficer;
    }

    public String getQualifiedName() {
        return "GovernanceDomain:" + this.domainIdentifier;
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCommunityName() {
        return this.communityName;
    }

    public PersonDefinition getGovernanceOfficer() {
        return this.governanceOfficer;
    }

    public String toString() {
        return "GovernanceDomain{" + this.displayName + "}";
    }
}

