/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.ProjectStatusDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public enum ProjectDefinition {
    MANUFACTURING_MOD("Campaign:Manufacturing Modernization", "CAMP-MM", "Manufacturing Modernization Project", "Project to upgrade manufacturing process to support personalized medicine.", true, false, null, ProjectStatusDefinition.ACTIVATING, null, null, PersonDefinition.STEW_FASTER, null),
    CLINICAL_TRIALS("Campaign:Clinical Trials Management", "CAMP-CT", "Clinical Trials Management", "Developing efficient ways to manage each of the clinical trials.", true, false, "GovernanceProject", ProjectStatusDefinition.ACTIVE, null, null, PersonDefinition.TANYA_TIDIE, null),
    DROP_FOOT_CLINICAL_TRIAL("Clinical Trial:Teddy Bear Drop Foot", "PROJ-CT-TBDF", "Teddy Bear Drop Foot Clinical Trial", "Clinical trial related to the new treatment for Teddy Bear Drop Foot.", false, false, "GovernanceProject", ProjectStatusDefinition.ACTIVE, CLINICAL_TRIALS, null, PersonDefinition.TANYA_TIDIE, null),
    DROP_FOOT_CLINICAL_TRIAL_IT("Clinical Trial:Teddy Bear Drop Foot:IT Setup", "PROJ-CT-TBDF-001", "Teddy Bear Drop Foot Clinical Trial IT Setup", "Setting up the systems that will support the clinical trial related to the new treatment for Teddy Bear Drop Foot.", false, false, null, ProjectStatusDefinition.COMPLETED, DROP_FOOT_CLINICAL_TRIAL, null, PersonDefinition.ERIN_OVERVIEW, null),
    DROP_FOOT_TEMPLATES("Clinical Trial:Teddy Bear Drop Foot:Templates", "PROJ-CT-TBDF-002", "Teddy Bear Drop Foot Clinical Trial Templates", "Templates for onboarding of Teddy Bear Drop Foot related data.", false, true, null, ProjectStatusDefinition.ACTIVATING, DROP_FOOT_CLINICAL_TRIAL_IT, null, PersonDefinition.PETER_PROFILE, null),
    DROP_FOOT_DATA_PIPELINES("Clinical Trial:Teddy Bear Drop Foot:Data Pipelines", "PROJ-CT-TBDF-003", "Teddy Bear Drop Foot Clinical Trial Data Pipelines", "Pipelines for onboarding of Teddy Bear Drop Foot related data.", false, true, null, ProjectStatusDefinition.PLANNED, DROP_FOOT_CLINICAL_TRIAL_IT, new ProjectDefinition[]{DROP_FOOT_TEMPLATES}, PersonDefinition.BOB_NITTER, null);

    private final String qualifiedName;
    private final String identifier;
    private final String displayName;
    private final String description;
    private final boolean isCampaign;
    private final boolean isTask;
    private final String projectTypeClassification;
    private final ProjectStatusDefinition projectStatus;
    private final ProjectDefinition controllingProject;
    private final ProjectDefinition[] dependentOn;
    private final PersonDefinition leader;
    private final PersonDefinition[] members;

    private ProjectDefinition(String qualifiedName, String identifier, String displayName, String description, boolean isCampaign, boolean isTask, String projectTypeClassification, ProjectStatusDefinition projectStatus, ProjectDefinition controllingProject, ProjectDefinition[] dependentOn, PersonDefinition leader, PersonDefinition[] members) {
        this.qualifiedName = qualifiedName;
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
        this.isCampaign = isCampaign;
        this.isTask = isTask;
        this.projectTypeClassification = projectTypeClassification;
        this.projectStatus = projectStatus;
        this.dependentOn = dependentOn;
        this.controllingProject = controllingProject;
        this.leader = leader;
        this.members = members;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCampaign() {
        return this.isCampaign;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public String getProjectTypeClassification() {
        return this.projectTypeClassification;
    }

    public ProjectStatusDefinition getProjectStatus() {
        return this.projectStatus;
    }

    public ProjectDefinition getControllingProject() {
        return this.controllingProject;
    }

    public List<ProjectDefinition> getDependentOn() {
        if (this.dependentOn != null) {
            return Arrays.asList(this.dependentOn);
        }
        return null;
    }

    public PersonDefinition getLeader() {
        return this.leader;
    }

    public List<PersonDefinition> getMembers() {
        if (this.members != null) {
            return Arrays.asList(this.members);
        }
        return null;
    }

    public String toString() {
        return "ProjectDefinition{" + this.displayName + "}";
    }
}

