/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

public enum ContactTypeDefinition {
    COMPANY_EMAIL("Work Email", "Work Email Address", "Email address assigned by Coco Pharmaceuticals."),
    PERSONAL_EMAIL("Personal Email", "Personal Email Address", "Email address supplied by the employee."),
    EMERGENCY_CONTACT_EMAIL("Emergency Contact Email", "Emergency Contact (Email)", "Email address of a relative or friend to call in an emergency."),
    OFFICE_PHONE("Office Phone", "Office Phone Number", "Phone number fixed to a desk or work location."),
    MOBILE_PHONE("Mobile Phone", "Mobile Phone Number", "Number of mobile/cell phone."),
    EMERGENCY_CONTACT_PHONE("Emergency Contact Phone", "Emergency Contact (Phone Number)", "Phone number of a relative or friend to call in an emergency."),
    LINKED_IN("LinkedIn", "LinkedIn Profile", "URL link to person's LinkedIn account."),
    TWITTER("Twitter", "Twitter Handler", "Name of person's Twitter account."),
    WEBSITE("Website", "Personal Web Site", "URL of a website related to the individual.");

    public static final String validValueSetName = "ContactType";
    public static final String validValueSetDescription = "Identifies the purpose of an individual's contact details.";
    public static final String validValueSetUsage = "Used in the contactType attribute of ContactDetails entities.";
    public static final String validValueSetScope = "For profiles of Coco Pharmaceuticals' employees and partners.";
    private final String preferredValue;
    private final String displayName;
    private final String description;

    private ContactTypeDefinition(String preferredValue, String displayName, String description) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ContactTypeDefinition{" + this.displayName + "}";
    }
}

