/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.types;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;

public class CocoTypesArchiveWriter
extends OMRSArchiveWriter {
    private static final String cocoTypesArchiveFileName = "CocoTypesArchive.omarchive";
    private static final String archiveGUID = "50874908-01f1-47e2-83ea-e571109a946e";
    private static final String archiveName = "CocoTypes";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Specialized types for Coco Pharmaceuticals.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria Project";
    private static final Date creationDate = new Date(1639984840038L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public CocoTypesArchiveWriter() {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new OMRSArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    private EnumDef getBiopsyScopeEnum() {
        String guid = "fdb05618-d0fe-4725-946f-138ba74f6f43";
        String name = "BiopsyScope";
        String description = "Defines scope of the tissue removal for a biopsy.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("fdb05618-d0fe-4725-946f-138ba74f6f43", "BiopsyScope", "Defines scope of the tissue removal for a biopsy.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Unclassified";
        String element1Description = "There is no information on the scope of the biopsy.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unclassified", "There is no information on the scope of the biopsy.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Excisional";
        String element2Description = "The biopsy removed all of the suspicious tissue.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Excisional", "The biopsy removed all of the suspicious tissue.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Incisional";
        String element3Description = "The biopsy took a sample of the tissue under examination.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Incisional", "The biopsy took a sample of the tissue under examination.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another biopsy scope.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another biopsy scope.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getBiopsyReportEntity() {
        String guid = "78479770-79ae-4bd8-b0ec-bf5e60c01e66";
        String name = "BiopsyReport";
        String description = "Results from a patient biopsy.";
        String descriptionGUID = null;
        String superTypeName = "Document";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("78479770-79ae-4bd8-b0ec-bf5e60c01e66", "BiopsyReport", (TypeDefLink)this.archiveBuilder.getEntityDef("Document"), "Results from a patient biopsy.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "biopsyScope";
        String attribute1Description = "Is this biopsy excisional (targeted removal) or incisional (sample taken).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "biopsyTechniqueType";
        String attribute2Description = "How was the biopsy taken?";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("BiopsyScope", "biopsyScope", "Is this biopsy excisional (targeted removal) or incisional (sample taken).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("biopsyTechniqueType", "How was the biopsy taken?", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getBiopsySupportingEvidenceRelationship() {
        String guid = "54300f97-0140-4adb-b9a9-308514694f8d";
        String name = "BiopsySupportingEvidence";
        String description = "Link between a biopsy report and other data sources.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("54300f97-0140-4adb-b9a9-308514694f8d", "BiopsySupportingEvidence", null, "Link between a biopsy report and other data sources.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "BiopsyReport";
        String end1AttributeName = "report";
        String end1AttributeDescription = "Report that the evidence is being linked to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef((TypeDefLink)this.archiveBuilder.getEntityDef("BiopsyReport"), "report", "Report that the evidence is being linked to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "evidence";
        String end2AttributeDescription = "Further information to support the report.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef((TypeDefLink)this.archiveBuilder.getEntityDef("Referenceable"), "evidence", "Further information to support the report.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "notes";
        String attribute1Description = "Information for the clinical trials team relating to the evidence.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute("notes", "Information for the clinical trials team relating to the evidence.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getReviewedByClinicalTrialsClassification() {
        String guid = "c2fa7555-f366-4869-88f3-897d6f2ec5a4";
        String name = "ReviewedByClinicalTrials";
        String description = "Declares that a report or data set has been assessed by the clinical trials team.";
        String descriptionGUID = null;
        ArrayList<EntityDef> linkedToEntities = new ArrayList<EntityDef>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("Asset"));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("c2fa7555-f366-4869-88f3-897d6f2ec5a4", "ReviewedByClinicalTrials", null, "Declares that a report or data set has been assessed by the clinical trials team.", descriptionGUID, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "reviewer";
        String attribute1Description = "Person responsible for maintaining this relationship.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "reviewerTypeName";
        String attribute2Description = "Type of element used to identify the reviewer.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "reviewerPropertyName";
        String attribute3Description = "Name of property used to identify the reviewer.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "notes";
        String attribute4Description = "Information for the clinical trials team relating to the review.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("reviewer", "Person responsible for maintaining this relationship.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("reviewerTypeName", "Type of element used to identify the reviewer.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("reviewerPropertyName", "Name of property used to identify the reviewer.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("notes", "Information for the clinical trials team relating to the review.", attribute4DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    protected OpenMetadataArchive getOpenMetadataArchive() {
        this.archiveBuilder.addEnumDef(this.getBiopsyScopeEnum());
        this.archiveBuilder.addEntityDef(this.getBiopsyReportEntity());
        this.archiveBuilder.addRelationshipDef(this.getBiopsySupportingEvidenceRelationship());
        this.archiveBuilder.addClassificationDef(this.getReviewedByClinicalTrialsClassification());
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    public void writeOpenMetadataArchive() {
        try {
            System.out.println("Writing to file: CocoTypesArchive.omarchive");
            super.writeOpenMetadataArchive(cocoTypesArchiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }
}

