/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.businesssystems;

import java.util.Date;
import java.util.HashMap;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.HostDefinition;
import org.odpi.openmetadata.samples.archiveutilities.businesssystems.SystemDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.CocoOrganizationArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.CocoSustainabilityArchiveWriter;

public class CocoBusinessSystemsArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoBusinessSystemsArchive.omarchive";
    private static final String archiveGUID = "ac202586-4042-407b-ae51-8096dfda223e";
    private static final String archiveName = "Coco Pharmaceuticals Business Systems";
    private static final String archiveDescription = "The data flows from Coco Pharmaceuticals business systems to the data lake.";

    public CocoBusinessSystemsArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, new Date(), archiveFileName, new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive(), new CocoOrganizationArchiveWriter().getOpenMetadataArchive(), new CocoSustainabilityArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        this.addHosts();
        this.addSystems();
    }

    private void addHosts() {
        for (HostDefinition hostDefinition : HostDefinition.values()) {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(OpenMetadataProperty.OPERATING_SYSTEM.name, hostDefinition.getOperatingSystem());
            additionalProperties.put(OpenMetadataProperty.PATCH_LEVEL.name, hostDefinition.getPatchLevel());
            this.archiveHelper.addAsset(hostDefinition.getHostType().getOpenMetadataTypeName(), hostDefinition.getQualifiedName(), hostDefinition.getHostId(), null, hostDefinition.getDescription(), hostDefinition.getZones(), additionalProperties, null);
            this.archiveHelper.addAssetLocationRelationship(hostDefinition.getHostLocation().getQualifiedName(), hostDefinition.getQualifiedName());
        }
    }

    private void addSystems() {
        for (SystemDefinition systemDefinition : SystemDefinition.values()) {
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, systemDefinition.getSystemType().getPreferredValue());
            extendedProperties.put(OpenMetadataProperty.USER_ID.name, systemDefinition.getUserId());
            String serverGUID = this.archiveHelper.addAsset(OpenMetadataType.SOFTWARE_SERVER.typeName, systemDefinition.getQualifiedName(), systemDefinition.getSystemId(), systemDefinition.getVersionIdentifier(), systemDefinition.getDescription(), systemDefinition.getZones(), null, extendedProperties);
            if (systemDefinition.getSystemType().getServerPurpose() != null) {
                this.archiveHelper.addServerPurposeClassification(serverGUID, systemDefinition.getSystemType().getServerPurpose(), null);
            }
            if (systemDefinition.getSystemType().getSoftwareServerCapabilities() != null) {
                for (String string : systemDefinition.getSystemType().getSoftwareServerCapabilities()) {
                    String softwareCapabilityQName = string + " for " + systemDefinition.getQualifiedName();
                    this.archiveHelper.addSoftwareCapability(string, softwareCapabilityQName, softwareCapabilityQName, null, null, null, null, null, null, null, (Classification)null, serverGUID, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.ASSET.typeName);
                    this.archiveHelper.addSupportedSoftwareCapabilityRelationship(softwareCapabilityQName, systemDefinition.getQualifiedName(), null, null, null, null, 1);
                }
            }
            if (systemDefinition.getSystemLocation() != null) {
                this.archiveHelper.addAssetLocationRelationship(systemDefinition.getSystemLocation().getQualifiedName(), systemDefinition.getQualifiedName());
            }
            if (systemDefinition.getDeployedOn() == null) continue;
            for (HostDefinition hostDefinition : systemDefinition.getDeployedOn()) {
                this.archiveHelper.addDeployedOnRelationship(systemDefinition.getQualifiedName(), hostDefinition.getQualifiedName(), null, null, null, null, 1);
            }
        }
    }
}

