/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import org.odpi.openmetadata.samples.archiveutilities.organization.ScopeDefinition;

public enum DataProcessingPurposeDefinition {
    CLINICAL_TRIAL_VALIDATION("Clinical Trial Validation", "Data is approved for processing that validates the efficacy of the treatments trialed.", "This purpose limits the processing of the data to the clinical trial in which it was collected.", "This purpose should be applied to data collected during a clinical trial. It is the minimal amount of permission needed from the patient, medical staff and hospital in order for the patient to participate in the clinical trial.  Additional purposes can be negotiated and attached to the data.  Data associated with this purpose will be retained beyond the end of the clinical trial for the regulatory required period.", ScopeDefinition.WITHIN_PROJECT),
    CROSS_CLINICAL_TRIAL_ANALYSIS("Cross Clinical Trial Analysis", "Data is approved for analysis across clinical trials, looking for trends, potential improvements in the processes and potential new treatments.", "This purpose allows processing of the data beyond the scope of the specific clinical trial.  However, it can only be used for processing that advances the clinical trial process, or the development of new treatments.", "This purpose should be applied to data collected during a clinical trial, or associated processes. It allows the data to be retained beyond the minimal length of time specified by the regulations.  This is typically limited to the retention period required by the last clinical trial to use the data.", ScopeDefinition.WITHIN_DISCIPLINE),
    GENERAL_PURPOSE("General Purpose", "Data may be processed for any purpose.", "This purpose allows any purpose since the data either has no license, or an open license that permits all types of processing.", "This purpose should be applied with care since even data generated by Coco Pharmaceuticals, or freely available on the internet may have a license, or be a type of data governed by a regulation, that restricts its use.", ScopeDefinition.ALL_COCO);

    private final String title;
    private final String summary;
    private final String description;
    private final String details;
    private final ScopeDefinition scope;

    private DataProcessingPurposeDefinition(String title, String summary, String description, String details, ScopeDefinition scope) {
        this.title = title;
        this.summary = summary;
        this.description = description;
        this.details = details;
        this.scope = scope;
    }

    public String getQualifiedName() {
        return "DataProcessingPurpose: " + this.title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetails() {
        return this.details;
    }

    public ScopeDefinition getScope() {
        return this.scope;
    }

    public String toString() {
        return "LicenseTypeDefinition{" + this.summary + "}";
    }
}

