/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

public enum ProjectStatusDefinition {
    PROPOSED("0", "Proposed", "This project has been proposed but there is no agreement to allocate resources or proceed."),
    APPROVED("1", "Approved", "This project has be approved to go ahead.  Resources a approved for it in principle, but specific resources may not have been allocated yet."),
    PLANNED("2", "Planned", "This project has an outline project plan and timeline.  Resources have been allocated."),
    ACTIVATING("3", "Activating", "This project is in final preparations to start."),
    ACTIVE("4", "Active", "This project is running."),
    STALLED("5", "Stalled", "This project is not able to make progress because of an external factor."),
    COMPLETED("6", "Completed", "This project has completed."),
    ABANDONED("7", "Abandoned", "This project has been abandoned and no further work on it is expected.");

    public static final String validValueSetName = "ProjectStatus";
    public static final String validValueSetPropertyName = "projectStatus";
    public static final String validValueSetDescription = "Describes the stages that a project may pass through.";
    public static final String validValueSetUsage = "Stored in the `projectStatus` property of the Project entity.";
    public static final String validValueSetScope = "Used when operating a project.";
    public static final ProjectStatusDefinition defaultValue;
    private final String preferredValue;
    private final String displayName;
    private final String description;

    private ProjectStatusDefinition(String preferredValue, String displayName, String description) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ProjectStatusDefinition{" + this.displayName + "}";
    }

    static {
        defaultValue = PROPOSED;
    }
}

