/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.organization.BusinessAreaDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.ContactTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.CountryCodeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.DeptDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.EmployeeTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.JobLevelDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.OrganizationDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.OrganizationTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.ScopeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.WorkLocationDefinition;

public class CocoOrganizationArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoOrganizationArchive.omarchive";
    private static final String archiveGUID = "3250f0f9-99fc-4af5-bed9-b746577f119b";
    private static final String archiveName = "Coco Pharmaceuticals' organization and operations";
    private static final String archiveDescription = "The base definitions for Coco Pharmaceuticals' organization and business capabilities.";
    static final String distinguishedNamePattern = "cn={0},ou=people,ou=users,o=cocoPharma";
    static final String userIdPattern = "ANON{0, number, 000000}";
    private int anonymousEmployeeCount = 0;

    public CocoOrganizationArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, new Date(), archiveFileName);
    }

    public void getArchiveContent() {
        this.writeContactTypesValidValueSet();
        this.writeCountryCodesValidValueSet();
        this.writeEmployeeTypeValidValueSet();
        this.writeJobLevelDefinitionValidValueSet();
        this.writeOrganizationTypeValidValueSet();
        this.writeWorkLocationsValidValueSet();
        this.writeScopeValidValueSet();
        this.writeBusinessAreas();
        this.writeOrganizations();
        this.writePersonProfiles();
        this.writeTeams();
    }

    private void writeContactTypesValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.ContactType";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "ContactType", "Identifies the purpose of an individual's contact details.", "Used in the contactType attribute of ContactDetails entities.", "For profiles of Coco Pharmaceuticals' employees and partners.", null, false, null);
        if (validValueSetGUID != null) {
            for (ContactTypeDefinition contactTypeDefinition : ContactTypeDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.ContactType." + contactTypeDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, contactTypeDefinition.getDisplayName(), contactTypeDefinition.getDescription(), "Used in the contactType attribute of ContactDetails entities.", "For profiles of Coco Pharmaceuticals' employees and partners.", contactTypeDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writeJobLevelDefinitionValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.JobLevel";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "JobLevel", "Describes the seniority of an employee in the Coco Pharmaceuticals' organization.", "Stored in the `jobLevel` additional property of the Person entity.", "Used when the person described has an employment contract with Coco Pharmaceuticals.", null, false, null);
        if (validValueSetGUID != null) {
            for (JobLevelDefinition jobLevelDefinition : JobLevelDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.JobLevel." + jobLevelDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, jobLevelDefinition.getDisplayName(), jobLevelDefinition.getDescription(), "Stored in the `jobLevel` additional property of the Person entity.", "Used when the person described has an employment contract with Coco Pharmaceuticals.", jobLevelDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, jobLevelDefinition.equals((Object)JobLevelDefinition.defaultValue));
            }
        }
    }

    private void writeEmployeeTypeValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.EmployeeType";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "EmployeeType", "Describes the type of employment contract that a person has with Coco Pharmaceuticals.", "Stored in the `employeeType` property of the Person entity.", "Used when the person described has an employment contract with Coco Pharmaceuticals.", null, false, null);
        if (validValueSetGUID != null) {
            for (EmployeeTypeDefinition employeeTypeDefinition : EmployeeTypeDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.EmployeeType." + employeeTypeDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, employeeTypeDefinition.getDisplayName(), employeeTypeDefinition.getDescription(), "Stored in the `employeeType` property of the Person entity.", "Used when the person described has an employment contract with Coco Pharmaceuticals.", employeeTypeDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writeOrganizationTypeValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.OrganizationType";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "OrganizationType", "Describes the reason behind a team's formation.", "Used in the 'teamType' property of the Team entity.", "Used for all types of Teams/Organizations.", null, false, null);
        if (validValueSetGUID != null) {
            for (OrganizationTypeDefinition organizationTypeDefinition : OrganizationTypeDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.OrganizationType." + organizationTypeDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, organizationTypeDefinition.getDisplayName(), organizationTypeDefinition.getDescription(), "Used in the 'teamType' property of the Team entity.", "Used for all types of Teams/Organizations.", organizationTypeDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writeWorkLocationsValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.OrganizationType";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, "OpenMetadata.ValidValueSet.WorkLocation", "WorkLocation", "Describes the reason behind a team's formation.", "Used as a tag to identify an employee's primary work location.", "Used for all types of people associated with Coco Pharmaceuticals.", null, false, null);
        if (validValueSetGUID != null) {
            for (WorkLocationDefinition workLocationDefinition : WorkLocationDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.WorkLocation." + workLocationDefinition.getWorkLocationId();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, workLocationDefinition.getDisplayName(), workLocationDefinition.getPostalAddress(), "Used as a tag to identify an employee's primary work location.", "Used for all types of people associated with Coco Pharmaceuticals.", workLocationDefinition.getWorkLocationId(), false, workLocationDefinition.getAddressProperties());
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writeCountryCodesValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.CountryCode";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "CountryCode", "Identifies the countries that Coco Pharmaceuticals operates in.", "Used in locations and profiles to identify the country where the location or person is based.", "For property of Coco Pharmaceuticals, their employees and partners.", null, false, null);
        if (validValueSetGUID != null) {
            for (CountryCodeDefinition countryCodeDefinition : CountryCodeDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.CountryCode." + countryCodeDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, countryCodeDefinition.getDisplayName(), null, "Used in locations and profiles to identify the country where the location or person is based.", "For property of Coco Pharmaceuticals, their employees and partners.", countryCodeDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writeScopeValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.Scope";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "Scope", "Identifies the scope of responsibility assigned to an individual term, person or activity.", "Used in relationships and definition that imply responsibility.", "For properties relating to Coco Pharmaceuticals, their employees and partners.", null, false, null);
        if (validValueSetGUID != null) {
            for (ScopeDefinition scopeDefinition : ScopeDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.Scope." + scopeDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, scopeDefinition.getDisplayName(), null, "Used in relationships and definition that imply responsibility.", "For properties relating to Coco Pharmaceuticals, their employees and partners.", scopeDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writePersonProfiles() {
        for (PersonDefinition personDefinition : PersonDefinition.values()) {
            String userIdQualifiedName = "UserIdentity:" + personDefinition.getDistinguishedName();
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            if (personDefinition.getJobLevel() != null) {
                additionalProperties.put("jobLevel", personDefinition.getJobLevel().getPreferredValue());
            }
            if (personDefinition.getOrganization() != null) {
                additionalProperties.put("organization", personDefinition.getOrganization().getDisplayName());
            }
            if (personDefinition.getWorkLocation() != null) {
                additionalProperties.put("workLocation", personDefinition.getWorkLocation().getWorkLocationId());
            }
            if (personDefinition.getCountryCode() != null) {
                additionalProperties.put("countryCode", personDefinition.getCountryCode().getPreferredValue());
            }
            String profileGUID = this.archiveHelper.addPerson(personDefinition.getQualifiedName(), personDefinition.getDisplayName(), personDefinition.getPronouns(), null, personDefinition.getInitials(), personDefinition.getTitle(), personDefinition.getGivenNames(), personDefinition.getSurname(), personDefinition.getFullName(), personDefinition.getJobTitle(), personDefinition.getEmployeeNumber(), personDefinition.getEmployeeType().getPreferredValue(), null, true, additionalProperties);
            String userIdGUID = this.archiveHelper.addUserIdentity(userIdQualifiedName, personDefinition.getUserId(), personDefinition.getDistinguishedName(), null);
            this.archiveHelper.addProfileIdentity(profileGUID, userIdGUID, null, null, null);
            if (personDefinition.getEmail() == null) continue;
            this.archiveHelper.addContactDetails(profileGUID, OpenMetadataType.PERSON.typeName, ContactTypeDefinition.COMPANY_EMAIL.getDisplayName(), ContactTypeDefinition.COMPANY_EMAIL.getPreferredValue(), ContactMethodType.EMAIL.getOrdinal(), ContactTypeDefinition.COMPANY_EMAIL.getDescription(), personDefinition.getEmail());
        }
    }

    private void writeBusinessAreas() {
        for (BusinessAreaDefinition businessAreaDefinition : BusinessAreaDefinition.values()) {
            this.archiveHelper.addBusinessArea(businessAreaDefinition.getQualifiedName(), businessAreaDefinition.getIdentifier(), businessAreaDefinition.getDisplayName(), businessAreaDefinition.getDescription(), null);
        }
    }

    private void writeOrganizations() {
        for (OrganizationDefinition organizationDefinition : OrganizationDefinition.values()) {
            this.archiveHelper.addTeam("Organization", organizationDefinition.getQualifiedName(), organizationDefinition.getDisplayName(), organizationDefinition.getDescription(), organizationDefinition.getOrganizationType().getPreferredValue(), null, null);
        }
    }

    private void writeTeams() {
        for (DeptDefinition deptDefinition : DeptDefinition.values()) {
            this.archiveHelper.addTeam(null, deptDefinition.getQualifiedName(), deptDefinition.getDisplayName(), deptDefinition.getDescription(), OrganizationTypeDefinition.DEPT.getPreferredValue(), deptDefinition.getTeamId(), null);
            Object superTeamQName = deptDefinition.getSuperTeam() == null ? "Organization:" + OrganizationDefinition.COCO.getDisplayName() : deptDefinition.getSuperTeam().getQualifiedName();
            this.archiveHelper.addTeamStructureRelationship((String)superTeamQName, deptDefinition.getQualifiedName(), true);
            String leadershipRoleQName = "TeamLeader:" + deptDefinition.getQualifiedName();
            this.archiveHelper.addPersonRole(OpenMetadataType.TEAM_LEADER.typeName, leadershipRoleQName, leadershipRoleQName, null, null, null, true, 1, null, null);
            this.archiveHelper.addTeamLeadershipRelationship(leadershipRoleQName, deptDefinition.getQualifiedName(), null);
            if (deptDefinition.getLeaders() != null) {
                for (PersonDefinition appointee : deptDefinition.getLeaders()) {
                    this.archiveHelper.addPersonRoleAppointmentRelationship(appointee.getQualifiedName(), leadershipRoleQName, true);
                }
            }
            String membershipRoleQName = "TeamMembers:" + deptDefinition.getQualifiedName();
            this.archiveHelper.addPersonRole(OpenMetadataType.TEAM_MEMBER.typeName, membershipRoleQName, membershipRoleQName, null, null, null, false, 0, null, null);
            this.archiveHelper.addTeamMembershipRelationship(membershipRoleQName, deptDefinition.getQualifiedName(), null);
            if (deptDefinition.getMembers() != null) {
                for (PersonDefinition appointee : deptDefinition.getLeaders()) {
                    this.archiveHelper.addPersonRoleAppointmentRelationship(appointee.getQualifiedName(), membershipRoleQName, true);
                }
            }
            if (deptDefinition.getAdditionalMembers() != 0) {
                this.archiveHelper.addPersonRoleAppointmentRelationship(this.getAnonymousMember(deptDefinition.getWorkLocation()), membershipRoleQName, true);
            }
            if (deptDefinition.getBusinessArea() == null) continue;
            this.archiveHelper.addOrganizationalCapabilityRelationship(deptDefinition.getBusinessArea().getQualifiedName(), deptDefinition.getQualifiedName(), deptDefinition.getBusinessAreaScope().getPreferredValue());
        }
    }

    private String getAnonymousMember(WorkLocationDefinition workLocationDefinition) {
        ++this.anonymousEmployeeCount;
        Object[] messageParameters = new Object[]{this.anonymousEmployeeCount};
        MessageFormat mf = new MessageFormat(userIdPattern);
        String userId = mf.format(messageParameters);
        Object[] dnMessageParameters = new Object[]{userId};
        mf = new MessageFormat(distinguishedNamePattern);
        String distinguishedName = mf.format(dnMessageParameters);
        String userIdQualifiedName = "UserIdentity:" + distinguishedName;
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("organization", OrganizationDefinition.COCO.getDisplayName());
        additionalProperties.put("workLocation", workLocationDefinition.getWorkLocationId());
        String personQName = "Person:Anon:" + userId;
        String profileGUID = this.archiveHelper.addPerson(personQName, userId, null, null, null, null, null, null, null, null, userId, EmployeeTypeDefinition.FULL_TIME_PERMANENT.getPreferredValue(), null, true, additionalProperties);
        String userIdGUID = this.archiveHelper.addUserIdentity(userIdQualifiedName, userId, distinguishedName, null);
        this.archiveHelper.addProfileIdentity(profileGUID, userIdGUID, null, null, null);
        return personQName;
    }
}

