/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.organization;

public enum EmployeeTypeDefinition {
    EXECUTIVE("Exec", "Executive", "This person is not an employee - they are an executive of the organization."),
    BOARD_ADVISOR("BDA", "Board Advisor", "This person is on the board and does not work for the organization."),
    FULL_TIME_PERMANENT("FTP", "Full-time permanent employee", "This permanent employee is contracted to work 35 hours or more per week."),
    PART_TIME_PERMANENT("PTP", "Part-time permanent employee", "This permanent employee is contracted to work less than 35 hours a week."),
    STUDENT("Intern", "Intern", "This temporary employee is a trainee gaining work experience."),
    SABBATICAL("Sab", "On Sabbatical", "This permanent employee has a leave of absence."),
    CONTRACTOR("Contractor", "Contractor", "This employee is on a temporary contract."),
    PARTNER("Partner", "Partner", "This person works for a partner organization."),
    LEFT("Resigner", "Former Employee - resigned", "This employee has left the company either because they resigned or took redundancy."),
    RETIRED("Retiree", "Former Employee - retired", "This employee has retired from the company."),
    DISMISSED("RTL", "Former Employee - dismissed", "This employee was dismissed from the company.");

    public static final String validValueSetName = "EmployeeType";
    public static final String validValueSetDescription = "Describes the type of employment contract that a person has with Coco Pharmaceuticals.";
    public static final String validValueSetUsage = "Stored in the `employeeType` property of the Person entity.";
    public static final String validValueSetScope = "Used when the person described has an employment contract with Coco Pharmaceuticals.";
    private final String preferredValue;
    private final String displayName;
    private final String description;

    private EmployeeTypeDefinition(String preferredValue, String displayName, String description) {
        this.preferredValue = preferredValue;
        this.displayName = displayName;
        this.description = description;
    }

    public String getPreferredValue() {
        return this.preferredValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "EmployeeTypeDefinition{" + this.displayName + "}";
    }
}

