/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates;

import org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates.GlossaryCategoryDefinition;

public enum GlossaryTermDefinition {
    PATIENT_IDENTIFIER("Patient Identifier", "Unique identifier of patient.", "Unique identifier for the teddy bear that has agree to take part in this study.  The identifier on its own is anonymous, preserving the privacy of the patient.  However, there is a database that ties the patient identifier to the name of the bear.", "PatientId", GlossaryCategoryDefinition.DATA_FIELDS),
    MEASUREMENT_DATE("Measurement Date", "The date that the measurement was made.", "The measurements are from a discrete day so that any changes in a patient's condition can be measured.  The format of the date may vary depending on the source of the measurement.", "MeasurementDate", GlossaryCategoryDefinition.DATA_FIELDS),
    ANGLE_LEFT("Left Hip Rotation Angle", "The number of degrees of rotation of the left foot measured from vertical.", "As the stuffing around the hip weakens, the foot on the attached leg rotates, typically outwards when the teddy bear is sitting.  This measurement is an integer measuring the number of degrees of rotation of the left foot measured from vertical. Positive values measure that the foot is rotating outwards.", "AngleLeft", GlossaryCategoryDefinition.DATA_FIELDS),
    ANGLE_RIGHT("Right Hip Rotation Angle", "The number of degrees of rotation of the right foot measured from vertical.", "As the stuffing around the hip weakens, the foot on the attached leg rotates, typically outwards when the teddy bear is sitting.  This measurement is an integer measuring the number of degrees of rotation of the right foot measured from vertical. Positive values measure that the foot is rotating outwards.", "AngleRight", GlossaryCategoryDefinition.DATA_FIELDS);

    private final String name;
    private final String summary;
    private final String description;
    private final String abbreviation;
    private final GlossaryCategoryDefinition category;

    private GlossaryTermDefinition(String name, String summary, String description, String abbreviation, GlossaryCategoryDefinition category) {
        this.name = name;
        this.summary = summary;
        this.description = description;
        this.abbreviation = abbreviation;
        this.category = category;
    }

    public String getQualifiedName() {
        return "GlossaryTerm:TeddyBearDropFootTerminology:" + this.name;
    }

    public String getTemplateSubstituteQualifiedName() {
        return "GlossaryTerm:TeddyBearDropFootTerminology:TemplateSubstitute:" + this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public String getTemplateSubstituteName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getUsage() {
        return "Definition for use in the Teddy Bear Drop Foot demonstration study.";
    }

    public String getTemplateSubstituteUsage() {
        return "Only for use in templates.";
    }

    public String getDescription() {
        return this.description;
    }

    public String getTemplateSubstituteSummary() {
        return "Template Substitute for " + this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public GlossaryCategoryDefinition getCategory() {
        return this.category;
    }

    public String toString() {
        return "GlossaryTermDefinition{" + this.summary + "}";
    }
}

