/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.governanceprogram;

import java.util.Date;
import java.util.HashMap;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.CollectionType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CertificationTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoGovernanceZoneDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoSubjectAreaDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CommunityDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.DataProcessingPurposeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.GovernanceDomainDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.GovernanceRoleDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.LicenseTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.ProjectDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.ProjectStatusDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.CocoOrganizationArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public class CocoGovernanceProgramArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoGovernanceProgramArchive.omarchive";
    private static final String archiveGUID = "ac202586-4042-407b-ae51-8096dfda223e";
    private static final String archiveName = "Coco Pharmaceuticals Governance Program";
    private static final String archiveDescription = "The core definition of Coco Pharmaceuticals' governance program.";
    private static final Date creationDate = new Date(1639984840038L);

    public CocoGovernanceProgramArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive(), new CocoOrganizationArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        this.writeDomains();
        this.writeLicenseTypes();
        this.writeCertificationTypes();
        this.writeDataProcessingPurposes();
        this.writeZones();
        this.writeSubjectAreaDefinitions();
        this.writeCommunities();
        this.writeProjectStatusValidValueSet();
        this.writeProjects();
        this.writeRoles();
    }

    private void writeDomains() {
        String governanceDomainSetGUID = this.archiveHelper.addCollection(OpenMetadataType.COLLECTION.typeName, null, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, "GovernanceDomainSet", "GovernanceDomainSet:Coco Pharmaceuticals", "Coco Pharmaceuticals Governance Domains", "List of active governance domains at Coco Pharmaceuticals.", CollectionType.GOVERNANCE_DOMAIN_SET.getName(), null, null, null);
        for (GovernanceDomainDefinition domainDefinition : GovernanceDomainDefinition.values()) {
            this.archiveHelper.addGovernanceDomainDescription(governanceDomainSetGUID, domainDefinition.getQualifiedName(), domainDefinition.getDomainIdentifier(), domainDefinition.getDisplayName(), domainDefinition.getDescription(), null);
            String communityQName = "Community: " + domainDefinition.getQualifiedName();
            this.archiveHelper.addCommunity(null, communityQName, domainDefinition.getCommunityName(), "Community supporting " + domainDefinition.getDisplayName() + " that is lead by the governance domain leader and includes all the people supporting the domain.", "To provide a mechanism for communication and coordination of work across Coco Pharmaceuticals that supports this governance domain.", null, null);
            this.archiveHelper.addResourceListRelationship(domainDefinition.getQualifiedName(), communityQName, ResourceUse.SUPPORTING_PEOPLE.getResourceUse(), null);
            String governanceOfficerQName = "GovernanceOfficer: " + domainDefinition.getQualifiedName();
            this.archiveHelper.addGovernanceRole("GovernanceOfficer", governanceOfficerQName, domainDefinition.getDomainIdentifier(), "GOV_OFFICER:" + domainDefinition.getDomainIdentifier(), "Governance Officer for " + domainDefinition.getDisplayName(), null, null, true, 1, null, null);
            if (domainDefinition.getGovernanceOfficer() == null) continue;
            this.archiveHelper.addPersonRoleAppointmentRelationship(domainDefinition.getGovernanceOfficer().getQualifiedName(), governanceOfficerQName, true);
        }
    }

    private void writeLicenseTypes() {
        for (LicenseTypeDefinition licenseTypeDefinition : LicenseTypeDefinition.values()) {
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("details", licenseTypeDefinition.getDetails());
            this.archiveHelper.addGovernanceDefinition("LicenseType", licenseTypeDefinition.getQualifiedName(), licenseTypeDefinition.getTitle(), licenseTypeDefinition.getSummary(), licenseTypeDefinition.getScope().getPreferredValue(), licenseTypeDefinition.getDescription(), 0, null, null, null, null, null, extendedProperties);
        }
    }

    private void writeCertificationTypes() {
        for (CertificationTypeDefinition certificationTypeDefinition : CertificationTypeDefinition.values()) {
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("details", certificationTypeDefinition.getDetails());
            this.archiveHelper.setGUID(certificationTypeDefinition.getQualifiedName(), certificationTypeDefinition.getGUID());
            String guid = this.archiveHelper.addGovernanceDefinition("CertificationType", certificationTypeDefinition.getQualifiedName(), certificationTypeDefinition.getTitle(), certificationTypeDefinition.getSummary(), certificationTypeDefinition.getScope().getPreferredValue(), certificationTypeDefinition.getDescription(), 0, null, null, null, null, null, extendedProperties);
            assert (certificationTypeDefinition.getGUID().equals(guid));
        }
    }

    private void writeDataProcessingPurposes() {
        for (DataProcessingPurposeDefinition dataProcessingPurposeDefinition : DataProcessingPurposeDefinition.values()) {
            this.archiveHelper.addGovernanceDefinition(OpenMetadataType.DATA_PROCESSING_PURPOSE.typeName, dataProcessingPurposeDefinition.getQualifiedName(), dataProcessingPurposeDefinition.getTitle(), dataProcessingPurposeDefinition.getSummary(), dataProcessingPurposeDefinition.getScope().getPreferredValue(), dataProcessingPurposeDefinition.getDescription(), 0, null, null, null, null, null, null);
        }
    }

    private void writeZones() {
        for (CocoGovernanceZoneDefinition zoneDefinition : CocoGovernanceZoneDefinition.values()) {
            this.archiveHelper.addGovernanceZone(zoneDefinition.getQualifiedName(), zoneDefinition.getZoneName(), zoneDefinition.getDisplayName(), zoneDefinition.getDescription(), zoneDefinition.getCriteria(), "Coco Pharmaceuticals", 0, null);
        }
    }

    private void writeSubjectAreaDefinitions() {
        HashMap<String, String> subjectAreaMap = new HashMap<String, String>();
        for (CocoSubjectAreaDefinition subjectAreaDefinition : CocoSubjectAreaDefinition.values()) {
            String subjectAreaGUID = this.archiveHelper.addSubjectAreaDefinition(subjectAreaDefinition.getQualifiedName(), subjectAreaDefinition.getSubjectAreaName(), subjectAreaDefinition.getDisplayName(), subjectAreaDefinition.getDescription(), subjectAreaDefinition.getScope(), subjectAreaDefinition.getUsage(), subjectAreaDefinition.getDomain(), null, null);
            subjectAreaMap.put(subjectAreaDefinition.getSubjectAreaName(), subjectAreaGUID);
            if (subjectAreaDefinition.getParent() == null) continue;
            this.archiveHelper.addSubjectAreaHierarchy((String)subjectAreaMap.get(subjectAreaDefinition.getParent().getSubjectAreaName()), subjectAreaGUID);
        }
    }

    private void writeCommunities() {
        for (CommunityDefinition communityDefinition : CommunityDefinition.values()) {
            this.archiveHelper.addCommunity(null, communityDefinition.getQualifiedName(), communityDefinition.getDisplayName(), communityDefinition.getDescription(), null, null, null);
            if (communityDefinition.getLeaders() != null) {
                String leaderRoleQName = "Leader: " + communityDefinition.getQualifiedName();
                this.archiveHelper.addPersonRole(OpenMetadataType.COMMUNITY_MEMBER.typeName, leaderRoleQName, "Community Leader", null, null, "Community", false, 0, null, null);
                this.archiveHelper.addCommunityMembershipRelationship(communityDefinition.getQualifiedName(), leaderRoleQName, CommunityMembershipType.LEADER.getOrdinal());
                for (PersonDefinition leader : communityDefinition.getLeaders()) {
                    this.archiveHelper.addPersonRoleAppointmentRelationship(leader.getQualifiedName(), leaderRoleQName, true);
                }
            }
            if (communityDefinition.getMembers() == null) continue;
            String memberRoleQName = "Member: " + communityDefinition.getQualifiedName();
            this.archiveHelper.addPersonRole(OpenMetadataType.COMMUNITY_MEMBER.typeName, memberRoleQName, "CommunityMember", null, null, "Community", false, 0, null, null);
            this.archiveHelper.addCommunityMembershipRelationship(communityDefinition.getQualifiedName(), memberRoleQName, CommunityMembershipType.CONTRIBUTOR.getOrdinal());
            for (PersonDefinition member : communityDefinition.getMembers()) {
                this.archiveHelper.addPersonRoleAppointmentRelationship(member.getQualifiedName(), memberRoleQName, true);
            }
        }
    }

    private void writeRoles() {
        for (GovernanceRoleDefinition roleDefinition : GovernanceRoleDefinition.values()) {
            this.archiveHelper.addGovernanceRole(roleDefinition.getTypeName(), roleDefinition.getQualifiedName(), roleDefinition.getDomain().getDomainIdentifier(), roleDefinition.getIdentifier(), roleDefinition.getDisplayName(), roleDefinition.getDescription(), roleDefinition.getScope(), roleDefinition.isHeadCountSet(), roleDefinition.getHeadCount(), null, null);
            if (roleDefinition.getAppointees() == null) continue;
            for (PersonDefinition appointee : roleDefinition.getAppointees()) {
                this.archiveHelper.addPersonRoleAppointmentRelationship(appointee.getQualifiedName(), roleDefinition.getQualifiedName(), true);
            }
        }
    }

    private void writeProjectStatusValidValueSet() {
        String validValueSetQName = "OpenMetadata.ValidValueSet.ProjectStatus";
        String validValueSetGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_SET.typeName, validValueSetQName, "ProjectStatus", "Describes the stages that a project may pass through.", "Stored in the `projectStatus` property of the Project entity.", "Used when operating a project.", null, false, null);
        if (validValueSetGUID != null) {
            for (ProjectStatusDefinition projectStatusDefinition : ProjectStatusDefinition.values()) {
                String validValueQName = "OpenMetadata.ValidValueSet.ProjectStatus." + projectStatusDefinition.getPreferredValue();
                String validValueGUID = this.archiveHelper.addValidValue(OpenMetadataType.VALID_VALUE_DEFINITION.typeName, validValueQName, projectStatusDefinition.getDisplayName(), null, "Stored in the `projectStatus` property of the Project entity.", "Used when operating a project.", projectStatusDefinition.getPreferredValue(), false, null);
                if (validValueGUID == null) continue;
                this.archiveHelper.addValidValueMembershipRelationship(validValueSetQName, validValueQName, false);
            }
        }
    }

    private void writeProjects() {
        for (ProjectDefinition projectDefinition : ProjectDefinition.values()) {
            this.archiveHelper.addProject(null, projectDefinition.getQualifiedName(), projectDefinition.getIdentifier(), projectDefinition.getDisplayName(), projectDefinition.getDescription(), new Date(), null, null, null, projectDefinition.getProjectStatus().getPreferredValue(), projectDefinition.isCampaign(), projectDefinition.isTask(), projectDefinition.getProjectTypeClassification(), null, null, null);
            String projectManagerQName = projectDefinition.getQualifiedName() + ":ProjectManager";
            this.archiveHelper.addPersonRole(OpenMetadataType.PROJECT_MANAGER.typeName, projectManagerQName, projectDefinition.getIdentifier() + ":ProjectManager", projectDefinition.getDisplayName() + " project manager", null, null, true, 1, null, null);
            this.archiveHelper.addProjectManagementRelationship(projectDefinition.getQualifiedName(), projectManagerQName);
            if (projectDefinition.getControllingProject() != null) {
                this.archiveHelper.addProjectHierarchyRelationship(projectDefinition.getControllingProject().getQualifiedName(), projectDefinition.getQualifiedName());
            }
            if (projectDefinition.getDependentOn() != null) {
                for (ProjectDefinition dependentOnProject : projectDefinition.getDependentOn()) {
                    this.archiveHelper.addProjectDependencyRelationship(dependentOnProject.getQualifiedName(), projectDefinition.getQualifiedName(), null);
                }
            }
            if (projectDefinition.getLeader() != null) {
                this.archiveHelper.addPersonRoleAppointmentRelationship(projectDefinition.getLeader().getQualifiedName(), projectManagerQName, true);
            }
            if (projectDefinition.getMembers() == null) continue;
            for (PersonDefinition member : projectDefinition.getMembers()) {
                this.archiveHelper.addProjectTeamRelationship(projectDefinition.getQualifiedName(), member.getQualifiedName(), null);
            }
        }
    }
}

