/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.sustainability;

import org.odpi.openmetadata.samples.archiveutilities.organization.OrganizationDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.WorkLocationDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.FacilityTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.sustainability.SustainabilityRoleDefinition;

public enum FacilityDefinition {
    AMSTERDAM_SITE("AMS-SITE", "Amsterdam Site", null, FacilityTypeDefinition.SITE, null, WorkLocationDefinition.AMSTERDAM_SITE, SustainabilityRoleDefinition.AMS_SITE_LEADER, PersonDefinition.STEVE_STARTER, OrganizationDefinition.COCO),
    AMSTERDAM_LAB("AMS-LAB", "Van Leeuwenhoek Cancer Research Laboratory", "Skin Oncology Research Lab.", FacilityTypeDefinition.LAB, AMSTERDAM_SITE, null, SustainabilityRoleDefinition.AMS_LAB_LEADER, PersonDefinition.STEVE_STARTER, OrganizationDefinition.COCO),
    AMSTERDAM_OFFICE("AMS-OFFICE", "Amsterdam Office", "Amsterdam Sales, Administration and IT Office.", FacilityTypeDefinition.OFFICE, AMSTERDAM_SITE, null, SustainabilityRoleDefinition.AMS_OFFICE_LEADER, PersonDefinition.STEVE_STARTER, OrganizationDefinition.COCO),
    AMSTERDAM_DC("AMS-DATA-CENTER", "Amsterdam Data Centre", "Shared systems data located on the Amsterdam Site.", FacilityTypeDefinition.DATA_CENTER, AMSTERDAM_SITE, null, SustainabilityRoleDefinition.AMS_OFFICE_LEADER, PersonDefinition.GARY_GEEKE, OrganizationDefinition.COCO),
    AMSTERDAM_DEPOT("AMS-DEPOT", "Amsterdam Distribution Centre", "Distribution center and warehouse located on the Amsterdam Site.", FacilityTypeDefinition.DEPOT, AMSTERDAM_SITE, null, SustainabilityRoleDefinition.AMS_DEPOT_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    LONDON_SITE("LDN-SITE", "London Site", null, FacilityTypeDefinition.SITE, null, WorkLocationDefinition.LONDON_SITE, SustainabilityRoleDefinition.LONDON_SITE_LEADER, PersonDefinition.TERRI_DARING, OrganizationDefinition.COCO),
    LONDON_LAB("LDN-LAB", "Nightingale Cancer Research Laboratory", "Leukemia Research Lab.", FacilityTypeDefinition.LAB, LONDON_SITE, null, SustainabilityRoleDefinition.LONDON_LAB_LEADER, PersonDefinition.TERRI_DARING, OrganizationDefinition.COCO),
    LONDON_OFFICE("LDN-OFFICE", "London Office", "Finance and HR Office", FacilityTypeDefinition.OFFICE, LONDON_SITE, null, SustainabilityRoleDefinition.LONDON_OFFICE_LEADER, PersonDefinition.REGGIE_MINT, OrganizationDefinition.COCO),
    LONDON_DC("LDN-DC", "London Data Centre", "", FacilityTypeDefinition.DATA_CENTER, LONDON_SITE, null, SustainabilityRoleDefinition.LONDON_DC_LEADER, PersonDefinition.GARY_GEEKE, OrganizationDefinition.COCO),
    NEW_YORK_SITE("NY-SITE", "New York Site", null, FacilityTypeDefinition.SITE, null, WorkLocationDefinition.NEW_YORK_SITE, SustainabilityRoleDefinition.NEW_YORK_SITE_LEADER, PersonDefinition.ZACH_NOW, OrganizationDefinition.COCO),
    NEW_YORK_LAB("NY-LAB", "Salk Cancer Research Laboratory", "Organ Oncology Research Lab.", FacilityTypeDefinition.LAB, NEW_YORK_SITE, null, SustainabilityRoleDefinition.NEW_YORK_LAB_LEADER, PersonDefinition.TESSA_TUBE, OrganizationDefinition.COCO),
    NEW_YORK_OFFICE("NY-OFFICE", "New York Office", "", FacilityTypeDefinition.OFFICE, NEW_YORK_SITE, null, SustainabilityRoleDefinition.NEW_YORK_OFFICE_LEADER, PersonDefinition.ZACH_NOW, OrganizationDefinition.COCO),
    NEW_YORK_DC("NY-DC", "New York Data Center", "", FacilityTypeDefinition.DATA_CENTER, NEW_YORK_SITE, null, SustainabilityRoleDefinition.NEW_YORK_DC_LEADER, PersonDefinition.GARY_GEEKE, OrganizationDefinition.COCO),
    WINCHESTER_SITE("WINCH-SITE", "Winchester Site", "UK Manufacturing site", FacilityTypeDefinition.SITE, null, WorkLocationDefinition.WINCHESTER_SITE, SustainabilityRoleDefinition.WINCHESTER_SITE_LEADER, null, OrganizationDefinition.COCO),
    WINCHESTER_FACTORY("WINCH-FACTORY", "Rosalind Franklin Factory", "UK and EU Manufacturing.", FacilityTypeDefinition.FACTORY, WINCHESTER_SITE, null, SustainabilityRoleDefinition.WINCHESTER_FACTORY_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    WINCHESTER_OFFICE("WINCH-OFFICE", "Winchester Office", "UK and EU Manufacturing Office.", FacilityTypeDefinition.OFFICE, WINCHESTER_SITE, null, SustainabilityRoleDefinition.WINCHESTER_OFFICE_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    WINCHESTER_DC("WINCH-DC", "Winchester Data Centre", "UK and EU Manufacturing Data Centre.", FacilityTypeDefinition.DATA_CENTER, WINCHESTER_SITE, null, SustainabilityRoleDefinition.WINCHESTER_DC_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    WINCHESTER_DEPOT("WINCH-DEPOT", "Winchester Distribution Center", "Distribution center and warehouse located on the Winchester Site.", FacilityTypeDefinition.DEPOT, WINCHESTER_SITE, null, SustainabilityRoleDefinition.WINCHESTER_DEPOT_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    KANSAS_CITY_SITE("KC-SITE", "Kansas City Site", "NA Distribution Center", FacilityTypeDefinition.SITE, null, WorkLocationDefinition.KANSAS_CITY_SITE, SustainabilityRoleDefinition.KANSAS_CITY_SITE_LEADER, null, OrganizationDefinition.COCO),
    KANSAS_CITY_OFFICE("KC-OFFICE", "Kansas City Office", "Distribution center and warehouse office, Kansas City.", FacilityTypeDefinition.OFFICE, KANSAS_CITY_SITE, null, SustainabilityRoleDefinition.KANSAS_CITY_OFFICE_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    KANSAS_CITY_DEPOT("KC-DEPOT", "Kansas City Distribution Center", "Distribution center and warehouse located on the Kansas City Site.", FacilityTypeDefinition.DEPOT, KANSAS_CITY_SITE, null, SustainabilityRoleDefinition.KANSAS_CITY_DEPOT_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    EDMONTON_SITE("ED-SITE", "Edmonton Site", "NA Manufacturing Site", FacilityTypeDefinition.SITE, null, WorkLocationDefinition.EDMONTON_SITE, SustainabilityRoleDefinition.EDMONTON_SITE_LEADER, null, OrganizationDefinition.COCO),
    EDMONTON_OFFICE("ED-OFFICE", "Edmonton Office", "Edmonton office.", FacilityTypeDefinition.OFFICE, EDMONTON_SITE, null, SustainabilityRoleDefinition.EDMONTON_OFFICE_LEADER, null, OrganizationDefinition.COCO),
    EDMONTON_FACTORY("ED-FACTORY", "Edmonton Manufacturing Center", "", FacilityTypeDefinition.FACTORY, EDMONTON_SITE, null, SustainabilityRoleDefinition.EDMONTON_FACTORY_LEADER, null, OrganizationDefinition.COCO),
    EDMONTON_DEPOT("ED-DEPOT", "Edmonton Distribution Center", "Distribution center and warehouse located on the Edmonton Site.", FacilityTypeDefinition.DEPOT, EDMONTON_SITE, null, SustainabilityRoleDefinition.EDMONTON_DEPOT_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    AUSTIN_SITE("AUS-SITE", "Austin Site", "US advanced manufacturing site", FacilityTypeDefinition.SITE, null, WorkLocationDefinition.AUSTIN_SITE, SustainabilityRoleDefinition.AUSTIN_SITE_LEADER, null, OrganizationDefinition.COCO),
    AUSTIN_FACTORY("AUS-FACTORY", "Austin Factory", "US manufacturing site specializing in small batches.", FacilityTypeDefinition.FACTORY, AUSTIN_SITE, null, SustainabilityRoleDefinition.AUSTIN_FACTORY_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    AUSTIN_OFFICE("AUS-OFFICE", "Austin Office", "Austin Manufacturing Office.", FacilityTypeDefinition.OFFICE, AUSTIN_SITE, null, SustainabilityRoleDefinition.AUSTIN_OFFICE_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    AUSTIN_DC("AUS-DC", "Austin Data Center", "Austin Data Center.", FacilityTypeDefinition.DATA_CENTER, AUSTIN_SITE, null, SustainabilityRoleDefinition.AUSTIN_DC_LEADER, PersonDefinition.STEW_FASTER, OrganizationDefinition.COCO),
    HAMPTON_HOSPITAL("HH", "Hampton Hospital", "Oncology Unit 1, Hampton Hospital", FacilityTypeDefinition.SITE, null, WorkLocationDefinition.HAMPTON_HOSPITAL, null, null, OrganizationDefinition.HAMPTON),
    OAK_DENE_HOSPITAL("ODH", "Oak Dene Hospital", null, FacilityTypeDefinition.SITE, null, WorkLocationDefinition.OAK_DENE_HOSPITAL, null, null, OrganizationDefinition.OAK_DENE),
    OLD_MARKET_HOSPITAL("OMH", "Old Market Hospital", null, FacilityTypeDefinition.SITE, null, WorkLocationDefinition.OLD_MARKET_HOSPITAL, null, null, OrganizationDefinition.OLD_MARKET),
    CLOUD_PROVIDER_SALES("Sales4U", "Sales4U", "Customer Sales and Invoicing Cloud Services", FacilityTypeDefinition.CLOUD, null, null, null, null, OrganizationDefinition.SALES_CP),
    CLOUD_PROVIDER_FINANCE("FinMagic", "FinMagic", "Accounting Cloud Services supporting book-keeping and ledgers for international businesses.", FacilityTypeDefinition.CLOUD, null, null, null, null, OrganizationDefinition.FINANCE_CP),
    CLOUD_PROVIDER_TRAVEL("BeThere", "BeThere Travel and Expenses", "Travel booking and employee expenses cloud services.", FacilityTypeDefinition.CLOUD, null, null, null, null, OrganizationDefinition.TRAVEL_CP);

    private final String identifier;
    private final String displayName;
    private final String description;
    private final FacilityTypeDefinition facilityType;
    private final FacilityDefinition parentSite;
    private final WorkLocationDefinition associatedWorkLocation;
    private final SustainabilityRoleDefinition facilityLeaderRole;
    private final PersonDefinition facilityLeader;
    private final OrganizationDefinition owningOrganization;

    private FacilityDefinition(String identifier, String displayName, String description, FacilityTypeDefinition facilityType, FacilityDefinition parentSite, WorkLocationDefinition associatedWorkLocation, SustainabilityRoleDefinition facilityLeaderRole, PersonDefinition facilityLeader, OrganizationDefinition owningOrganization) {
        this.identifier = identifier;
        this.displayName = displayName;
        this.description = description;
        this.facilityType = facilityType;
        this.parentSite = parentSite;
        this.associatedWorkLocation = associatedWorkLocation;
        this.facilityLeaderRole = facilityLeaderRole;
        this.facilityLeader = facilityLeader;
        this.owningOrganization = owningOrganization;
    }

    public String getQualifiedName() {
        return this.facilityType.getPreferredValue() + ":" + this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public FacilityTypeDefinition getFacilityType() {
        return this.facilityType;
    }

    public FacilityDefinition getParentSite() {
        return this.parentSite;
    }

    public WorkLocationDefinition getAssociatedWorkLocation() {
        return this.associatedWorkLocation;
    }

    public SustainabilityRoleDefinition getFacilityLeaderRole() {
        return this.facilityLeaderRole;
    }

    public PersonDefinition getFacilityLeader() {
        return this.facilityLeader;
    }

    public String toString() {
        return "FacilityDefinition{" + this.displayName + "}";
    }
}

