/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.sustainability;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.samples.archiveutilities.organization.PersonDefinition;

public enum SustainabilityProjectDefinition {
    SUS_GOV("Campaign:Sustainability", "Sustainability Campaign", "Campaign coordinating the sustainability initiatives in Coco Pharmaceuticals.", true, false, null, null, null),
    SUS_BOOTSTRAP("Project:Sustainability Bootstrap", "Sustainability Bootstrap Project", "Project to establish a sustainability focus and practices in Coco Pharmaceuticals.", false, false, SUS_GOV, null, null);

    private final String qualifiedName;
    private final String displayName;
    private final String description;
    private final boolean isCampaign;
    private final boolean isTask;
    private final SustainabilityProjectDefinition controllingProject;
    private final PersonDefinition[] leaders;
    private final PersonDefinition[] members;

    private SustainabilityProjectDefinition(String qualifiedName, String displayName, String description, boolean isCampaign, boolean isTask, SustainabilityProjectDefinition controllingProject, PersonDefinition[] leaders, PersonDefinition[] members) {
        this.qualifiedName = qualifiedName;
        this.displayName = displayName;
        this.description = description;
        this.isCampaign = isCampaign;
        this.isTask = isTask;
        this.controllingProject = controllingProject;
        this.leaders = leaders;
        this.members = members;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCampaign() {
        return this.isCampaign;
    }

    public boolean isTask() {
        return this.isTask;
    }

    public SustainabilityProjectDefinition getControllingProject() {
        return this.controllingProject;
    }

    public List<PersonDefinition> getLeader() {
        if (this.leaders != null) {
            return Arrays.asList(this.leaders);
        }
        return null;
    }

    public List<PersonDefinition> getMembers() {
        if (this.members != null) {
            return Arrays.asList(this.members);
        }
        return null;
    }

    public String toString() {
        return "SustainabilityProjectDefinition{" + this.displayName + "}";
    }
}

