/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates.GlossaryCategoryDefinition;
import org.odpi.openmetadata.samples.archiveutilities.clinicaltrialtemplates.GlossaryTermDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoGovernanceProgramArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.CocoGovernanceZoneDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.DataProcessingPurposeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.LicenseTypeDefinition;
import org.odpi.openmetadata.samples.archiveutilities.governanceprogram.ProjectDefinition;
import org.odpi.openmetadata.samples.archiveutilities.organization.ScopeDefinition;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialPlaceholderProperty;

public class CocoClinicalTrialsArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final String archiveFileName = "CocoClinicalTrialsTemplatesArchive.omarchive";
    private static final String archiveGUID = "74a786b2-d6d7-401d-b8c1-7d798f752c55";
    private static final String archiveName = "Coco Pharmaceuticals Clinical Trials Templates";
    private static final String archiveDescription = "Templates for new assets relating to a clinical trial.";
    private static final Date creationDate = new Date(1639984840038L);
    private static final String clinicalTrialsSubjectArea = "SubjectArea:ClinicalTrial:TeddyBearDropFoot";

    public CocoClinicalTrialsArchiveWriter() {
        super(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive(), new CocoGovernanceProgramArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        this.writeGlossary();
        this.writeLandingAreaWeeklyMeasurementsTemplate();
        this.writeDataLakeWeeklyMeasurementsTemplate();
    }

    private void writeGlossary() {
        String methodName = "writeGlossary";
        String glossaryGUID = this.archiveHelper.addGlossary("Glossary:TeddyBearDropFootTerminology", "Teddy Bear Drop Foot Terminology", "This glossary describes terminology invented for the fictitious study into Teddy Bear Drop Foot that is being used to demonstrate aspects of open governance without risk to real patient data. ", "English", "Used with the Teddy Bear Drop Foot Demonstration Study.", null, ScopeDefinition.ALL_COCO.getPreferredValue());
        this.archiveHelper.addSubjectAreaClassification(glossaryGUID, clinicalTrialsSubjectArea);
        HashMap<String, String> categoryLookup = new HashMap<String, String>();
        for (GlossaryCategoryDefinition glossaryCategoryDefinition : GlossaryCategoryDefinition.values()) {
            String glossaryCategoryGUID = this.archiveHelper.addGlossaryCategory(glossaryGUID, glossaryCategoryDefinition.getQualifiedName(), glossaryCategoryDefinition.getName(), glossaryCategoryDefinition.getDescription(), null);
            categoryLookup.put(glossaryCategoryDefinition.getName(), glossaryCategoryGUID);
        }
        for (Enum enum_ : GlossaryTermDefinition.values()) {
            String glossaryTermGUID = this.archiveHelper.addTerm(glossaryGUID, null, false, ((GlossaryTermDefinition)enum_).getQualifiedName(), ((GlossaryTermDefinition)enum_).getName(), ((GlossaryTermDefinition)enum_).getSummary(), ((GlossaryTermDefinition)enum_).getDescription(), null, ((GlossaryTermDefinition)enum_).getAbbreviation(), ((GlossaryTermDefinition)enum_).getUsage(), false, false, false, null, null, null, null);
            ArrayList<Classification> classificationList = new ArrayList<Classification>();
            classificationList.add(this.archiveHelper.getTemplateSubstituteClassification());
            String substituteGlossaryTermGUID = this.archiveHelper.addTerm(glossaryGUID, null, false, ((GlossaryTermDefinition)enum_).getTemplateSubstituteQualifiedName(), ((GlossaryTermDefinition)enum_).getTemplateSubstituteName(), ((GlossaryTermDefinition)enum_).getTemplateSubstituteSummary(), null, null, null, ((GlossaryTermDefinition)enum_).getTemplateSubstituteUsage(), false, false, false, null, null, null, classificationList);
            this.archiveHelper.addSourcedFromRelationship(substituteGlossaryTermGUID, 1L, glossaryTermGUID, "writeGlossary");
            if (((GlossaryTermDefinition)enum_).getCategory() == null) continue;
            this.archiveHelper.addTermToCategory((String)categoryLookup.get(((GlossaryTermDefinition)enum_).getCategory().getName()), glossaryTermGUID);
        }
    }

    private void writeLandingAreaWeeklyMeasurementsTemplate() {
        String methodName = "writeLandingAreaWeeklyMeasurementsTemplate";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, PlaceholderProperty.FILE_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, FileType.CSV_FILE.getDeployedImplementationType().getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, FileType.CSV_FILE.getFileTypeName());
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, "csv");
        extendedProperties.put(OpenMetadataProperty.DELIMITER_CHARACTER.name, ",");
        extendedProperties.put(OpenMetadataProperty.QUOTE_CHARACTER.name, "\"");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        ArrayList<String> zones = new ArrayList<String>();
        zones.add(CocoGovernanceZoneDefinition.LANDING_AREA.getZoneName());
        zones.add(CocoGovernanceZoneDefinition.QUARANTINE.getZoneName());
        zones.add(CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getPlaceholder());
        classifications.add(this.archiveHelper.getAssetZoneMembershipClassification(zones));
        HashMap<String, String> otherOriginValues = new HashMap<String, String>();
        otherOriginValues.put("contact", CocoClinicalTrialPlaceholderProperty.CONTACT_NAME.getPlaceholder());
        otherOriginValues.put("dept", CocoClinicalTrialPlaceholderProperty.CONTACT_EMAIL.getPlaceholder());
        classifications.add(this.archiveHelper.getAssetOriginClassification(CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder(), OpenMetadataProperty.NAME.name, null, null, otherOriginValues));
        classifications.add(this.archiveHelper.getConfidentialityClassification(3, 100, "tanyatidie", OpenMetadataType.USER_IDENTITY.typeName, OpenMetadataProperty.USER_ID.name, "Clinical Trial Board", "Level approved assuming the data remains anonymized.", 2));
        classifications.add(this.archiveHelper.getTemplateClassification("Landing Area weekly teddy bear measurements for drop foot clinical trial", "This template supports the cataloguing of weekly measurement files. Use it to catalog the files as they come into the landing area.", "2.4", null, "writeLandingAreaWeeklyMeasurementsTemplate"));
        String qualifiedName = "CSVFile:LandingArea:ClinicalTrial:" + CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getPlaceholder() + ":WeeklyMeasurement:" + CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder() + ":" + PlaceholderProperty.RECEIVED_DATE.getPlaceholder() + ":" + PlaceholderProperty.FILE_PATH_NAME.getPlaceholder();
        String assetGUID = this.archiveHelper.addAsset(FileType.CSV_FILE.getAssetSubTypeName(), qualifiedName, CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder() + " teddy bear measurements received on " + PlaceholderProperty.RECEIVED_DATE.getPlaceholder() + " for " + CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_NAME.getPlaceholder(), "V1.0", "Dated measurements of patient's progression presented in a tabular format with columns of PatientId, Date, AngleLeft and AngleRight.", this.getAssetAdditionalProperties(), extendedProperties, classifications);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + "_endpoint", null, null, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder(), null, null);
        CSVFileStoreProvider connectorProvider = new CSVFileStoreProvider();
        String connectorTypeGUID = connectorProvider.getConnectorType().getGUID();
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + "_connection", null, null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), OpenMetadataType.ASSET.typeName, CocoClinicalTrialPlaceholderProperty.getPlaceholderPropertyTypes());
        String licenseTypeGUID = this.archiveHelper.getGUID(LicenseTypeDefinition.CLINICAL_TRIAL_LICENSE.getQualifiedName());
        HashMap<String, String> entitlements = new HashMap<String, String>();
        entitlements.put("research", "true");
        entitlements.put("marketing", "false");
        HashMap<String, String> restrictions = new HashMap<String, String>();
        restrictions.put("copying", "in-house-only");
        HashMap<String, String> obligations = new HashMap<String, String>();
        obligations.put("retention", "20 years");
        this.archiveHelper.addLicense(assetGUID, "ClinicalTrial:" + CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getPlaceholder() + ":WeeklyMeasurement:" + CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder(), null, null, null, CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder(), "Organization", "name", "tanyatidie", "UserIdentity", "userId", "tessatube", "UserIdentity", "userId", entitlements, restrictions, obligations, null, licenseTypeGUID);
        String dataProcessingPurposeGUID = this.archiveHelper.getGUID(DataProcessingPurposeDefinition.CLINICAL_TRIAL_VALIDATION.getQualifiedName());
        this.archiveHelper.addApprovedPurpose(assetGUID, dataProcessingPurposeGUID);
        String topLevelSchemaTypeGUID = this.archiveHelper.addTopLevelSchemaType(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularSchemaType", qualifiedName + "_schemaType", null, null, null);
        String schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_patientId_column", "PatientId", null, "string", 0, 0, null, null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        String glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.PATIENT_IDENTIFIER.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_date_column", "Date", null, "date", 0, 1, "YYYY-MM-DD", null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.MEASUREMENT_DATE.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_angleLeft_column", "AngleLeft", null, "integer", 0, 2, null, null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.ANGLE_LEFT.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_angleRight_column", "AngleRight", null, "integer", 0, 3, null, null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.ANGLE_RIGHT.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        this.archiveHelper.addResourceListRelationship(ProjectDefinition.DROP_FOOT_CLINICAL_TRIAL.getQualifiedName(), qualifiedName, ResourceUse.SUPPORTING_TEMPLATE.getResourceUse(), ResourceUse.SUPPORTING_TEMPLATE.getDescription());
    }

    private Map<String, String> getAssetAdditionalProperties() {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        for (CocoClinicalTrialPlaceholderProperty placeholderProperty : CocoClinicalTrialPlaceholderProperty.values()) {
            additionalProperties.put(placeholderProperty.getName(), placeholderProperty.getPlaceholder());
        }
        return additionalProperties;
    }

    private void writeDataLakeWeeklyMeasurementsTemplate() {
        String methodName = "writeDataLakeWeeklyMeasurementsTemplate";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, PlaceholderProperty.FILE_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, FileType.CSV_FILE.getDeployedImplementationType().getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, FileType.CSV_FILE.getFileTypeName());
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, "csv");
        extendedProperties.put(OpenMetadataProperty.DELIMITER_CHARACTER.name, ",");
        extendedProperties.put(OpenMetadataProperty.QUOTE_CHARACTER.name, "\"");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        ArrayList<String> zones = new ArrayList<String>();
        zones.add(CocoGovernanceZoneDefinition.QUARANTINE.getZoneName());
        zones.add(ProjectDefinition.DROP_FOOT_CLINICAL_TRIAL.getIdentifier());
        classifications.add(this.archiveHelper.getAssetZoneMembershipClassification(zones));
        classifications.add(this.archiveHelper.getTemplateClassification("Data Lake weekly teddy bear measurements for drop foot clinical trial", "This template supports the cataloguing of weekly measurement files. Use it to catalog the files as they come into the data lake.", "2.4", null, "writeDataLakeWeeklyMeasurementsTemplate"));
        String qualifiedName = "CSVFile:DataLake:ClinicalTrial:" + CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getPlaceholder() + ":WeeklyMeasurement:" + CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder() + ":" + PlaceholderProperty.RECEIVED_DATE.getPlaceholder() + ":" + PlaceholderProperty.FILE_PATH_NAME.getPlaceholder();
        String assetGUID = this.archiveHelper.addAsset(FileType.CSV_FILE.getAssetSubTypeName(), qualifiedName, CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder() + " teddy bear measurements received on " + PlaceholderProperty.RECEIVED_DATE.getPlaceholder() + " for " + CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_NAME.getPlaceholder(), "V1.0", "Dated measurements of patient's progression presented in a tabular format with columns of PatientId, Date, AngleLeft and AngleRight.", this.getAssetAdditionalProperties(), extendedProperties, classifications);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + "_endpoint", null, null, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder(), null, null);
        CSVFileStoreProvider connectorProvider = new CSVFileStoreProvider();
        String connectorTypeGUID = connectorProvider.getConnectorType().getGUID();
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + "_connection", null, null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), OpenMetadataType.ASSET.typeName, CocoClinicalTrialPlaceholderProperty.getPlaceholderPropertyTypes());
        String licenseTypeGUID = this.archiveHelper.getGUID(LicenseTypeDefinition.CLINICAL_TRIAL_LICENSE.getQualifiedName());
        HashMap<String, String> entitlements = new HashMap<String, String>();
        entitlements.put("research", "true");
        entitlements.put("marketing", "false");
        HashMap<String, String> restrictions = new HashMap<String, String>();
        restrictions.put("copying", "in-house-only");
        HashMap<String, String> obligations = new HashMap<String, String>();
        obligations.put("retention", "20 years");
        this.archiveHelper.addLicense(assetGUID, "ClinicalTrial:" + CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getPlaceholder() + ":WeeklyMeasurement:" + CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder(), null, null, null, CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getPlaceholder(), "Organization", "name", "tanyatidie", "UserIdentity", "userId", "tessatube", "UserIdentity", "userId", entitlements, restrictions, obligations, null, licenseTypeGUID);
        String dataProcessingPurposeGUID = this.archiveHelper.getGUID(DataProcessingPurposeDefinition.CLINICAL_TRIAL_VALIDATION.getQualifiedName());
        this.archiveHelper.addApprovedPurpose(assetGUID, dataProcessingPurposeGUID);
        String topLevelSchemaTypeGUID = this.archiveHelper.addTopLevelSchemaType(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularSchemaType", qualifiedName + "_schemaType", null, null, null);
        String schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_patientId_column", "PatientId", null, "string", 0, 0, null, null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        String glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.PATIENT_IDENTIFIER.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_date_column", "Date", null, "date", 0, 1, "YYYY-MM-DD", null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.MEASUREMENT_DATE.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_angleLeft_column", "AngleLeft", null, "integer", 0, 2, null, null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.ANGLE_LEFT.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
        schemaAttributeGUID = this.archiveHelper.addSchemaAttribute(assetGUID, FileType.CSV_FILE.getAssetSubTypeName(), "TabularColumn", "PrimitiveSchemaType", qualifiedName + "_angleRight_column", "AngleRight", null, "integer", 0, 3, null, null);
        this.archiveHelper.addAttributeForSchemaType(topLevelSchemaTypeGUID, schemaAttributeGUID);
        glossaryTermGUID = this.archiveHelper.getGUID(GlossaryTermDefinition.ANGLE_RIGHT.getTemplateSubstituteQualifiedName());
        this.archiveHelper.addSemanticAssignment(schemaAttributeGUID, glossaryTermGUID);
    }
}

